/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARVec;

public class NyARMat {
    protected double[][] m;
    private int clm;
    private int row;
    private int[] wk_nos_matrixSelfInv = new int[50];
    private static final double PCA_EPS = 1.0E-6;
    private static final int PCA_MAX_ITER = 100;
    private static final double PCA_VZERO = 1.0E-16;
    private final NyARVec wk_PCA_QRM_ev = new NyARVec(1);
    private NyARMat wk_PCA_PCA_u = null;
    private NyARMat wk_work_matrixPCA = null;
    private final NyARVec wk_vecTridiagonalize_vec = new NyARVec(0);
    private final NyARVec wk_vecTridiagonalize_vec2 = new NyARVec(0);

    protected NyARMat() throws NyARException {
        throw new NyARException();
    }

    public NyARMat(int i_row, int i_clm) {
        this.m = new double[i_row][i_clm];
        this.clm = i_clm;
        this.row = i_row;
    }

    public void realloc(int i_row, int i_clm) {
        if (i_row > this.m.length || i_clm > this.m[0].length) {
            this.m = new double[i_row][i_clm];
        }
        this.clm = i_clm;
        this.row = i_row;
    }

    public int getClm() {
        return this.clm;
    }

    public int getRow() {
        return this.row;
    }

    public void zeroClear() {
        for (int i = this.row - 1; i >= 0; --i) {
            for (int i2 = this.clm - 1; i2 >= 0; --i2) {
                this.m[i][i2] = 0.0;
            }
        }
    }

    public void copyFrom(NyARMat i_copy_from) throws NyARException {
        if (this.row != i_copy_from.row || this.clm != i_copy_from.clm) {
            throw new NyARException();
        }
        for (int r = this.row - 1; r >= 0; --r) {
            for (int c = this.clm - 1; c >= 0; --c) {
                this.m[r][c] = i_copy_from.m[r][c];
            }
        }
    }

    public double[][] getArray() {
        return this.m;
    }

    public void matrixMul(NyARMat a, NyARMat b) throws NyARException {
        if (a.clm != b.row || this.row != a.row || this.clm != b.clm) {
            throw new NyARException();
        }
        double[][] am = a.m;
        double[][] bm = b.m;
        double[][] dm = this.m;
        for (int r = 0; r < this.row; ++r) {
            for (int c = 0; c < this.clm; ++c) {
                double w = 0.0;
                for (int i = 0; i < a.clm; ++i) {
                    w += am[r][i] * bm[i][c];
                }
                dm[r][c] = w;
            }
        }
    }

    public boolean matrixSelfInv() throws NyARException {
        double[] ap_i;
        double work;
        int j;
        int i;
        int n;
        double[][] ap = this.m;
        int dimen = this.row;
        int dimen_1 = dimen - 1;
        int[] nos = this.wk_nos_matrixSelfInv;
        switch (dimen) {
            case 0: {
                throw new NyARException();
            }
            case 1: {
                ap[0][0] = 1.0 / ap[0][0];
                return true;
            }
        }
        for (n = 0; n < dimen; ++n) {
            nos[n] = n;
        }
        int ip = 0;
        for (n = 0; n < dimen; ++n) {
            double[] ap_n = ap[n];
            double p = 0.0;
            for (i = n; i < dimen; ++i) {
                double d;
                double pbuf = Math.abs(ap[i][0]);
                if (!(p < d)) continue;
                p = pbuf;
                ip = i;
            }
            if (p == 0.0) {
                return false;
            }
            int nwork = nos[ip];
            nos[ip] = nos[n];
            nos[n] = nwork;
            double[] ap_ip = ap[ip];
            for (j = 0; j < dimen; ++j) {
                work = ap_ip[j];
                ap_ip[j] = ap_n[j];
                ap_n[j] = work;
            }
            work = ap_n[0];
            for (j = 0; j < dimen_1; ++j) {
                ap_n[j] = ap_n[j + 1] / work;
            }
            ap_n[j] = 1.0 / work;
            for (i = 0; i < dimen; ++i) {
                if (i == n) continue;
                ap_i = ap[i];
                work = ap_i[0];
                for (j = 0; j < dimen_1; ++j) {
                    ap_i[j] = ap_i[j + 1] - work * ap_n[j];
                }
                ap_i[j] = -work * ap_n[j];
            }
        }
        for (n = 0; n < dimen; ++n) {
            for (j = n; j < dimen && nos[j] != n; ++j) {
            }
            nos[j] = nos[n];
            for (i = 0; i < dimen; ++i) {
                ap_i = ap[i];
                work = ap_i[j];
                ap_i[j] = ap_i[n];
                ap_i[n] = work;
            }
        }
        return true;
    }

    public static void matrixTrans(NyARMat dest, NyARMat source) throws NyARException {
        if (dest.row != source.clm || dest.clm != source.row) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        for (int r = 0; r < dest.row; ++r) {
            for (int c = 0; c < dest.clm; ++c) {
                dest.m[r][c] = source.m[c][r];
            }
        }
    }

    public static void matrixUnit(NyARMat unit) throws NyARException {
        if (unit.row != unit.clm) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        for (int r = 0; r < unit.getRow(); ++r) {
            for (int c = 0; c < unit.getClm(); ++c) {
                unit.m[r][c] = r == c ? 1.0 : 0.0;
            }
        }
    }

    public void matrixDup(NyARMat i_source) throws NyARException {
        this.realloc(i_source.row, i_source.clm);
        double[][] src_m = i_source.m;
        double[][] dest_m = this.m;
        for (int r = this.row - 1; r >= 0; --r) {
            for (int c = this.clm - 1; c >= 0; --c) {
                dest_m[r][c] = src_m[r][c];
            }
        }
    }

    public NyARMat matrixAllocDup() throws NyARException {
        NyARMat result = new NyARMat(this.row, this.clm);
        double[][] dest_m = result.m;
        double[][] src_m = this.m;
        for (int r = this.row - 1; r >= 0; --r) {
            for (int c = this.clm - 1; c >= 0; --c) {
                dest_m[r][c] = src_m[r][c];
            }
        }
        return result;
    }

    public static void matrixInv(NyARMat dest, NyARMat source) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixDup(source);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixSelfInv();
    }

    public NyARMat matrixAllocInv() throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat result = this.matrixAllocDup();
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        result.matrixSelfInv();
        return result;
    }

    public static NyARMat matrixAllocUnit(int dim) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat result = new NyARMat(dim, dim);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat.matrixUnit(result);
        return result;
    }

    public int matrixDisp() throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        System.out.println(" === matrix (" + this.row + "," + this.clm + ") ===");
        for (int r = 0; r < this.row; ++r) {
            System.out.print(" |");
            for (int c = 0; c < this.clm; ++c) {
                System.out.print(" " + this.m[r][c]);
            }
            System.out.println(" |");
        }
        System.out.println(" ======================");
        return 0;
    }

    private void PCA_EX(NyARVec mean) throws NyARException {
        int lrow = this.row;
        int lclm = this.clm;
        double[][] lm = this.m;
        if (lrow <= 0 || lclm <= 0) {
            throw new NyARException();
        }
        if (mean.getClm() != lclm) {
            throw new NyARException();
        }
        double[] mean_array = mean.getArray();
        for (int i2 = 0; i2 < lclm; ++i2) {
            double w = 0.0;
            for (int i = 0; i < lrow; ++i) {
                w += lm[i][i2];
            }
            mean_array[i2] = w / (double)lrow;
        }
    }

    private static void PCA_CENTER(NyARMat inout, NyARVec mean) throws NyARException {
        int row = inout.getRow();
        int clm = inout.getClm();
        if (mean.getClm() != clm) {
            throw new NyARException();
        }
        double[][] im = inout.m;
        double[] v = mean.getArray();
        switch (clm) {
            case 1: {
                double w0 = v[0];
                for (int i = 0; i < row; ++i) {
                    double[] dArray = im[i];
                    dArray[0] = dArray[0] - w0;
                }
                break;
            }
            case 2: {
                double w0 = v[0];
                double w1 = v[1];
                for (int i = 0; i < row; ++i) {
                    double[] im_i = im[i];
                    im_i[0] = im_i[0] - w0;
                    im_i[1] = im_i[1] - w1;
                }
                break;
            }
            default: {
                for (int i = 0; i < row; ++i) {
                    double[] im_i = im[i];
                    for (int j = 0; j < clm; ++j) {
                        int n = j;
                        im_i[n] = im_i[n] - v[j];
                    }
                }
            }
        }
    }

    private static void PCA_x_by_xt(NyARMat input, NyARMat output) throws NyARException {
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        if (output.row != row || output.clm != row) {
            throw new NyARException();
        }
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < row; ++j) {
                if (j < i) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    output.m[i][j] = output.m[j][i];
                    continue;
                }
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                double[] in1 = input.m[i];
                double[] in2 = input.m[j];
                output.m[i][j] = 0.0;
                for (int k = 0; k < clm; ++k) {
                    double[] dArray = output.m[i];
                    int n = j;
                    dArray[n] = dArray[n] + in1[k] * in2[k];
                }
            }
        }
    }

    private static void PCA_xt_by_x(NyARMat input, NyARMat i_output) throws NyARException {
        int row = input.row;
        int clm = input.clm;
        if (i_output.row != clm || i_output.clm != clm) {
            throw new NyARException();
        }
        double[][] out_m = i_output.m;
        for (int i = 0; i < clm; ++i) {
            for (int j = 0; j < clm; ++j) {
                if (j < i) {
                    out_m[i][j] = out_m[j][i];
                    continue;
                }
                double w = 0.0;
                for (int k = 0; k < row; ++k) {
                    double[] in = input.m[k];
                    w += in[i] * in[j];
                }
                out_m[i][j] = w;
            }
        }
    }

    private void PCA_QRM(NyARVec dv) throws NyARException {
        double t;
        double[] dv_array = dv.getArray();
        int dim = this.row;
        if (dim != this.clm || dim < 2) {
            throw new NyARException();
        }
        if (dv.getClm() != dim) {
            throw new NyARException();
        }
        NyARVec ev = this.wk_PCA_QRM_ev;
        ev.realloc(dim);
        double[] ev_array = ev.getArray();
        if (ev == null) {
            throw new NyARException();
        }
        double[][] L_m = this.m;
        this.vecTridiagonalize(dv, ev, 1);
        ev_array[0] = 0.0;
        for (int h = dim - 1; h > 0; --h) {
            int j;
            for (j = h; j > 0 && Math.abs(ev_array[j]) > 1.0E-6 * (Math.abs(dv_array[j - 1]) + Math.abs(dv_array[j])); --j) {
            }
            if (j == h) continue;
            int iter = 0;
            while (++iter <= 100) {
                double w = (dv_array[h - 1] - dv_array[h]) / 2.0;
                t = ev_array[h] * ev_array[h];
                double s = Math.sqrt(w * w + t);
                if (w < 0.0) {
                    s = -s;
                }
                double x = dv_array[j] - dv_array[h] + t / (w + s);
                double y = ev_array[j + 1];
                for (int k = j; k < h; ++k) {
                    double c;
                    if (Math.abs(x) >= Math.abs(y)) {
                        if (Math.abs(x) > 1.0E-16) {
                            t = -y / x;
                            c = 1.0 / Math.sqrt(t * t + 1.0);
                            s = t * c;
                        } else {
                            c = 1.0;
                            s = 0.0;
                        }
                    } else {
                        t = -x / y;
                        s = 1.0 / Math.sqrt(t * t + 1.0);
                        c = t * s;
                    }
                    w = dv_array[k] - dv_array[k + 1];
                    t = (w * s + 2.0 * c * ev_array[k + 1]) * s;
                    int n = k;
                    dv_array[n] = dv_array[n] - t;
                    int n2 = k + 1;
                    dv_array[n2] = dv_array[n2] + t;
                    if (k > j) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                        ev_array[k] = c * ev_array[k] - s * y;
                    }
                    int n3 = k + 1;
                    ev_array[n3] = ev_array[n3] + s * (c * w - 2.0 * s * ev_array[k + 1]);
                    for (int i = 0; i < dim; ++i) {
                        x = L_m[k][i];
                        y = L_m[k + 1][i];
                        L_m[k][i] = c * x - s * y;
                        L_m[k + 1][i] = s * x + c * y;
                    }
                    if (k >= h - 1) continue;
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                    x = ev_array[k + 1];
                    y = -s * ev_array[k + 2];
                    int n4 = k + 2;
                    ev_array[n4] = ev_array[n4] * c;
                }
                if (Math.abs(ev_array[h]) > 1.0E-6 * (Math.abs(dv_array[h - 1]) + Math.abs(dv_array[h]))) continue;
            }
        }
        for (int k = 0; k < dim - 1; ++k) {
            int h = k;
            t = dv_array[h];
            for (int i = k + 1; i < dim; ++i) {
                if (!(dv_array[i] > t)) continue;
                h = i;
                t = dv_array[h];
            }
            dv_array[h] = dv_array[k];
            dv_array[k] = t;
            this.flipRow(h, k);
        }
    }

    private void flipRow(int i_row_1, int i_row_2) {
        double[] r1 = this.m[i_row_1];
        double[] r2 = this.m[i_row_2];
        for (int i = this.clm - 1; i >= 0; --i) {
            double w = r1[i];
            r1[i] = r2[i];
            r2[i] = w;
        }
    }

    private static void PCA_EV_create(NyARMat input, NyARMat u, NyARMat output, NyARVec ev) throws NyARException {
        int j;
        int i;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        if (row <= 0 || clm <= 0) {
            throw new NyARException();
        }
        if (u.row != row || u.clm != row) {
            throw new NyARException();
        }
        if (output.row != row || output.clm != clm) {
            throw new NyARException();
        }
        if (ev.getClm() != row) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        double[][] m = output.m;
        double[][] in = input.m;
        double[] ev_array = ev.getArray();
        for (i = 0; i < row; ++i) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            if (ev_array[i] < 1.0E-16) break;
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            double work = 1.0 / Math.sqrt(Math.abs(ev_array[i]));
            for (j = 0; j < clm; ++j) {
                double sum = 0.0;
                double[] m1 = u.m[i];
                for (int k = 0; k < row; ++k) {
                    sum += m1[k] + in[k][j];
                }
                m1[j] = sum * work;
            }
        }
        while (i < row) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            ev_array[i] = 0.0;
            for (j = 0; j < clm; ++j) {
                m[i][j] = 0.0;
            }
            ++i;
        }
    }

    private void PCA_PCA(NyARMat o_output, NyARVec o_ev) throws NyARException {
        NyARMat u;
        int min;
        double[] ev_array = o_ev.getArray();
        int l_clm = this.clm;
        int l_row = this.row;
        int n = min = l_clm < l_row ? l_clm : l_row;
        if (l_row < 2 || l_clm < 2) {
            throw new NyARException();
        }
        if (o_output.clm != this.clm) {
            throw new NyARException();
        }
        if (o_output.row != min) {
            throw new NyARException();
        }
        if (o_ev.getClm() != min) {
            throw new NyARException();
        }
        if (this.wk_PCA_PCA_u == null) {
            this.wk_PCA_PCA_u = u = new NyARMat(min, min);
        } else {
            u = this.wk_PCA_PCA_u;
            u.realloc(min, min);
        }
        if (l_row < l_clm) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            NyARMat.PCA_x_by_xt(this, u);
        } else {
            NyARMat.PCA_xt_by_x(this, u);
        }
        u.PCA_QRM(o_ev);
        if (l_row < l_clm) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            NyARMat.PCA_EV_create(this, u, o_output, o_ev);
        } else {
            int j;
            int i;
            double[][] m1 = u.m;
            double[][] m2 = o_output.m;
            for (i = 0; i < min && !(ev_array[i] < 1.0E-16); ++i) {
                for (j = 0; j < min; ++j) {
                    m2[i][j] = m1[i][j];
                }
            }
            while (i < min) {
                ev_array[i] = 0.0;
                for (j = 0; j < min; ++j) {
                    m2[i][j] = 0.0;
                }
                ++i;
            }
        }
    }

    public void matrixPCA(NyARMat o_evec, NyARVec o_ev, NyARVec mean) throws NyARException {
        int i;
        NyARMat work;
        int check;
        int l_row = this.row;
        int l_clm = this.clm;
        int n = check = l_row < l_clm ? l_row : l_clm;
        if (l_row < 2 || l_clm < 2) {
            throw new NyARException();
        }
        if (o_evec.clm != l_clm || o_evec.row != check) {
            throw new NyARException();
        }
        if (o_ev.getClm() != check) {
            throw new NyARException();
        }
        if (mean.getClm() != l_clm) {
            throw new NyARException();
        }
        if (this.wk_work_matrixPCA == null) {
            this.wk_work_matrixPCA = work = this.matrixAllocDup();
        } else {
            work = this.wk_work_matrixPCA;
            work.matrixDup(this);
        }
        double srow = Math.sqrt(l_row);
        work.PCA_EX(mean);
        NyARMat.PCA_CENTER(work, mean);
        for (i = 0; i < l_row; ++i) {
            int j = 0;
            while (j < l_clm) {
                double[] dArray = work.m[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] / srow;
            }
        }
        work.PCA_PCA(o_evec, o_ev);
        double sum = 0.0;
        double[] ev_array = o_ev.getArray();
        int ev_clm = o_ev.getClm();
        for (i = 0; i < ev_clm; ++i) {
            sum += ev_array[i];
        }
        i = 0;
        while (i < ev_clm) {
            int n3 = i++;
            ev_array[n3] = ev_array[n3] / sum;
        }
    }

    public static void arMatrixPCA2(NyARMat input, NyARMat evec, NyARVec ev) throws NyARException {
        int i;
        int check;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        int n = check = row < clm ? row : clm;
        if (row < 2 || clm < 2) {
            throw new NyARException();
        }
        if (evec.getClm() != input.clm || evec.row != check) {
            throw new NyARException();
        }
        if (ev.getClm() != check) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat work = input.matrixAllocDup();
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
        work.PCA_PCA(evec, ev);
        double sum = 0.0;
        double[] ev_array = ev.getArray();
        for (i = 0; i < ev.getClm(); ++i) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            sum += ev_array[i];
        }
        i = 0;
        while (i < ev.getClm()) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            int n2 = i++;
            ev_array[n2] = ev_array[n2] / sum;
        }
    }

    public static NyARMat matrixAllocMul(NyARMat a, NyARMat b) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat dest = new NyARMat(a.row, b.clm);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixMul(a, b);
        return dest;
    }

    private static double Det_mdet(double[][] ap, int dimen, int rowa) throws NyARException {
        int i;
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        double det = 1.0;
        int is = 0;
        for (int k = 0; k < dimen - 1; ++k) {
            double work;
            int i2;
            int mmax = k;
            for (i2 = k + 1; i2 < dimen; ++i2) {
                if (!(Math.abs(ap[i2][k]) > Math.abs(ap[mmax][k]))) continue;
                mmax = i2;
            }
            if (mmax != k) {
                for (int j = k; j < dimen; ++j) {
                    work = ap[k][j];
                    ap[k][j] = ap[mmax][j];
                    ap[mmax][j] = work;
                }
                ++is;
            }
            for (i2 = k + 1; i2 < dimen; ++i2) {
                work = ap[i2][k] / ap[k][k];
                for (int j = k + 1; j < dimen; ++j) {
                    double[] dArray = ap[i2];
                    int n = j;
                    dArray[n] = dArray[n] - work * ap[k][j];
                }
            }
        }
        for (i = 0; i < dimen; ++i) {
            det = ap[i][i];
        }
        for (i = 0; i < is; ++i) {
            det *= -1.0;
        }
        return det;
    }

    public static double arMatrixDet(NyARMat m) throws NyARException {
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        if (m.row != m.clm) {
            return 0.0;
        }
        return NyARMat.Det_mdet(m.getArray(), m.row, m.clm);
    }

    private void vecTridiagonalize(NyARVec d, NyARVec e, int i_e_start) throws NyARException {
        double t;
        double[] a_vec_k;
        NyARVec vec = this.wk_vecTridiagonalize_vec;
        if (this.clm != this.row) {
            throw new NyARException();
        }
        if (this.clm != d.getClm()) {
            throw new NyARException();
        }
        if (this.clm != e.getClm()) {
            throw new NyARException();
        }
        int dim = this.getClm();
        double[] d_vec = d.getArray();
        double[] e_vec = e.getArray();
        for (int k = 0; k < dim - 2; ++k) {
            int j;
            int i;
            a_vec_k = this.m[k];
            vec.setNewArray(a_vec_k, this.clm);
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            d_vec[k] = a_vec_k[k];
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            e_vec[k + i_e_start] = vec.vecHousehold(k + 1);
            if (e_vec[k + i_e_start] == 0.0) continue;
            for (i = k + 1; i < dim; ++i) {
                double s = 0.0;
                for (j = k + 1; j < i; ++j) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    s += this.m[j][i] * a_vec_k[j];
                }
                for (j = i; j < dim; ++j) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    s += this.m[i][j] * a_vec_k[j];
                }
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                d_vec[i] = s;
            }
            a_vec_k = this.m[k];
            vec.setNewArray(a_vec_k, this.clm);
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            t = vec.vecInnerproduct(d, k + 1) / 2.0;
            for (i = dim - 1; i > k; --i) {
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                double p = a_vec_k[i];
                int n = i;
                d_vec[n] = d_vec[n] - t * p;
                double q = d_vec[i];
                for (j = i; j < dim; ++j) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                    double[] dArray = this.m[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - p * (d_vec[j] + q * a_vec_k[j]);
                }
            }
        }
        if (dim >= 2) {
            d_vec[dim - 2] = this.m[dim - 2][dim - 2];
            e_vec[dim - 2 + i_e_start] = this.m[dim - 2][dim - 1];
        }
        if (dim >= 1) {
            d_vec[dim - 1] = this.m[dim - 1][dim - 1];
        }
        NyARVec vec2 = this.wk_vecTridiagonalize_vec2;
        for (int k = dim - 1; k >= 0; --k) {
            int i;
            a_vec_k = this.m[k];
            vec.setNewArray(a_vec_k, this.clm);
            if (k < dim - 2) {
                for (i = k + 1; i < dim; ++i) {
                    vec2.setNewArray(this.m[i], this.clm);
                    t = vec.vecInnerproduct(vec2, k + 1);
                    for (int j = k + 1; j < dim; ++j) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                        double[] dArray = this.m[i];
                        int n = j;
                        dArray[n] = dArray[n] - t * a_vec_k[j];
                    }
                }
            }
            for (i = 0; i < dim; ++i) {
                a_vec_k[i] = 0.0;
            }
            a_vec_k[k] = 1.0;
        }
    }
}

