/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.match;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt;

public class NyARMatchPatt_Color_WITH_PCA
implements NyARMatchPatt {
    private final int EVEC_MAX = 10;
    private int evec_dim;
    private int[][][] input;
    private double[][][][] evec;
    private double[][] epat = new double[4][10];
    private int ave;
    private double datapow;
    private int width;
    private int height;
    private double cf = 0.0;
    private int dir = 0;

    @Override
    public double getConfidence() {
        return this.cf;
    }

    @Override
    public int getDirection() {
        return this.dir;
    }

    @Override
    public boolean setPatt(NyARColorPatt i_target_patt) throws NyARException {
        int i2;
        int i;
        this.width = i_target_patt.getWidth();
        this.height = i_target_patt.getHeight();
        int[][][] data = i_target_patt.getPatArray();
        this.input = new int[this.height][this.width][3];
        this.evec = new double[10][this.height][this.width][3];
        this.ave = 0;
        int sum = 0;
        for (i = 0; i < this.height; ++i) {
            for (i2 = 0; i2 < this.width; ++i2) {
                this.ave += 255 - data[i][i2][0] + (255 - data[i][i2][1]) + (255 - data[i][i2][2]);
            }
        }
        this.ave /= this.height * this.width * 3;
        for (i = 0; i < this.height; ++i) {
            for (i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < 3; ++i3) {
                    this.input[i][i2][i3] = 255 - data[i][i2][i3] - this.ave;
                    sum += this.input[i][i2][i3] * this.input[i][i2][i3];
                }
            }
        }
        this.datapow = Math.sqrt(sum);
        return this.datapow != 0.0;
    }

    @Override
    public void evaluate(NyARCode i_code) {
        int[][][][] pat = i_code.getPat();
        double[] patpow = i_code.getPatPow();
        double[] invec = new double[10];
        double max = 0.0;
        int i = 0;
        while (i < this.evec_dim) {
            invec[i] = 0.0;
            for (int j = 0; j < this.height; ++j) {
                for (int j2 = 0; j2 < this.width; ++j2) {
                    for (int j3 = 0; j3 < 3; ++j3) {
                        int n = i;
                        invec[n] = invec[n] + this.evec[i][j][j2][j3] * (double)this.input[j][j2][j3];
                    }
                }
            }
            int n = i++;
            invec[n] = invec[n] / this.datapow;
        }
        double min = 10000.0;
        int res = -1;
        for (int j = 0; j < 4; ++j) {
            double sum2 = 0.0;
            for (int i2 = 0; i2 < this.evec_dim; ++i2) {
                sum2 += (invec[i2] - this.epat[j][i2]) * (invec[i2] - this.epat[j][i2]);
            }
            if (!(sum2 < min)) continue;
            min = sum2;
            res = j;
        }
        int sum = 0;
        for (int i3 = 0; i3 < this.height; ++i3) {
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i32 = 0; i32 < 3; ++i32) {
                    sum += this.input[i3][i2][i32] * pat[res][i3][i2][i32];
                }
            }
        }
        max = (double)sum / patpow[res] / this.datapow;
        this.dir = res;
        this.cf = max;
    }
}

