/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.NyARColorPatt_O3;
import jp.nyatla.nyartoolkit.core.NyARDetectSquare;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARSquareList;
import jp.nyatla.nyartoolkit.core.NyARTransMat;
import jp.nyatla.nyartoolkit.core.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.NyARTransMat_O2;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;

public class NyARSingleDetectMarker {
    private static final int AR_SQUARE_MAX = 100;
    private boolean is_continue = false;
    private NyARMatchPatt_Color_WITHOUT_PCA match_patt;
    private NyARDetectSquare square;
    private final NyARSquareList square_list = new NyARSquareList(100);
    private NyARCode code;
    protected NyARTransMat transmat;
    private double marker_width;
    private int detected_direction;
    private double detected_confidence;
    private NyARSquare detected_square;
    private NyARColorPatt patt;

    public NyARSingleDetectMarker(NyARParam i_param, NyARCode i_code, double i_marker_width) throws NyARException {
        this.square = new NyARDetectSquare(i_param);
        this.transmat = new NyARTransMat_O2(i_param);
        this.code = i_code;
        this.marker_width = i_marker_width;
        this.patt = new NyARColorPatt_O3(this.code.getWidth(), this.code.getHeight());
        this.match_patt = new NyARMatchPatt_Color_WITHOUT_PCA();
    }

    public boolean detectMarkerLite(NyARRaster i_image, int i_thresh) throws NyARException {
        this.detected_square = null;
        NyARSquareList l_square_list = this.square_list;
        this.square.detectSquare(i_image, i_thresh, l_square_list);
        int number_of_square = l_square_list.getSquareNum();
        if (number_of_square < 1) {
            return false;
        }
        if (!this.patt.pickFromRaster(i_image, l_square_list.getSquare(0))) {
            return false;
        }
        if (!this.match_patt.setPatt(this.patt)) {
            throw new NyARException();
        }
        this.match_patt.evaluate(this.code);
        int square_index = 0;
        int direction = this.match_patt.getDirection();
        double confidence = this.match_patt.getConfidence();
        for (int i = 1; i < number_of_square; ++i) {
            this.patt.pickFromRaster(i_image, l_square_list.getSquare(i));
            this.match_patt.setPatt(this.patt);
            this.match_patt.evaluate(this.code);
            double c2 = this.match_patt.getConfidence();
            if (confidence > c2) continue;
            square_index = i;
            direction = this.match_patt.getDirection();
            confidence = c2;
        }
        this.detected_square = l_square_list.getSquare(square_index);
        this.detected_direction = direction;
        this.detected_confidence = confidence;
        return true;
    }

    public void getTransmationMatrix(NyARTransMatResult o_result) throws NyARException {
        if (this.is_continue) {
            this.transmat.transMatContinue(this.detected_square, this.detected_direction, this.marker_width, o_result);
        } else {
            this.transmat.transMat(this.detected_square, this.detected_direction, this.marker_width, o_result);
        }
    }

    public double getConfidence() {
        return this.detected_confidence;
    }

    public int getDirection() {
        return this.detected_direction;
    }

    public void setContinueMode(boolean i_is_continue) {
        this.is_continue = i_is_continue;
    }
}

