/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.squaredetect;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelOverlapChecker;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARLabeling_Rle;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfo;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfoPtrStack;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2SquareVertexIndexes;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public abstract class NyARSquareContourDetector_Rle
extends NyARSquareContourDetector {
    private final int _width;
    private final int _height;
    private final Labeling _labeling;
    private final NyARLabelOverlapChecker<NyARRleLabelFragmentInfo> _overlap_checker = new NyARLabelOverlapChecker<NyARRleLabelFragmentInfo>(32, NyARRleLabelFragmentInfo.class);
    private final NyARContourPickup _cpickup = new NyARContourPickup();
    private final NyARCoord2SquareVertexIndexes _coord2vertex = new NyARCoord2SquareVertexIndexes();
    private final NyARIntCoordinates _coord;
    private final int[] __detectMarker_mkvertex = new int[4];

    public NyARSquareContourDetector_Rle(NyARIntSize i_size) throws NyARException {
        this._width = i_size.w;
        this._height = i_size.h;
        this._labeling = new Labeling(this._width, this._height);
        int number_of_coord = (this._width + this._height) * 2;
        this._coord = new NyARIntCoordinates(number_of_coord);
    }

    public void detectMarker(NyARGrayscaleRaster i_raster, NyARIntRect i_area, int i_th) throws NyARException {
        assert (i_area.w * i_area.h > 0);
        NyARRleLabelFragmentInfoPtrStack flagment = this._labeling.label_stack;
        NyARLabelOverlapChecker<NyARRleLabelFragmentInfo> overlap = this._overlap_checker;
        this._labeling.labeling(i_raster, i_area, i_th);
        int label_num = flagment.getLength();
        if (label_num < 1) {
            return;
        }
        NyARRleLabelFragmentInfo[] labels = (NyARRleLabelFragmentInfo[])flagment.getArray();
        NyARIntCoordinates coord = this._coord;
        int[] mkvertex = this.__detectMarker_mkvertex;
        overlap.setMaxLabels(label_num);
        int i = 0;
        while (i < label_num) {
            int label_area;
            NyARRleLabelFragmentInfo label_pt = labels[i];
            if (overlap.check(label_pt) && this._cpickup.getContour(i_raster, i_area, i_th, label_pt.entry_x, label_pt.clip_t, coord) && this._coord2vertex.getVertexIndexes(coord, label_area = label_pt.area, mkvertex)) {
                this.onSquareDetect(coord, mkvertex);
                overlap.push(label_pt);
            }
            ++i;
        }
    }

    @Override
    public void detectMarker(NyARBinRaster i_raster) throws NyARException {
        NyARRleLabelFragmentInfoPtrStack flagment = this._labeling.label_stack;
        NyARLabelOverlapChecker<NyARRleLabelFragmentInfo> overlap = this._overlap_checker;
        flagment.clear();
        this._labeling.labeling(i_raster);
        int label_num = flagment.getLength();
        if (label_num < 1) {
            return;
        }
        flagment.sortByArea();
        NyARRleLabelFragmentInfo[] labels = (NyARRleLabelFragmentInfo[])flagment.getArray();
        NyARIntCoordinates coord = this._coord;
        int[] mkvertex = this.__detectMarker_mkvertex;
        overlap.setMaxLabels(label_num);
        int i = 0;
        while (i < label_num) {
            NyARRleLabelFragmentInfo label_pt = labels[i];
            int label_area = label_pt.area;
            if (overlap.check(label_pt) && this._cpickup.getContour(i_raster, label_pt.entry_x, label_pt.clip_t, coord) && this._coord2vertex.getVertexIndexes(coord, label_area, mkvertex)) {
                this.onSquareDetect(coord, mkvertex);
                overlap.push(label_pt);
            }
            ++i;
        }
    }

    public Object[] _probe() {
        Object[] ret = new Object[10];
        return ret;
    }

    private class Labeling
    extends NyARLabeling_Rle {
        public NyARRleLabelFragmentInfoPtrStack label_stack;
        int _right;
        int _bottom;

        public Labeling(int i_width, int i_height) throws NyARException {
            super(i_width, i_height);
            this.label_stack = new NyARRleLabelFragmentInfoPtrStack(i_width * i_height * 2048 / 76800 + 32);
            this._bottom = i_height - 1;
            this._right = i_width - 1;
        }

        @Override
        public void labeling(NyARGrayscaleRaster i_raster, NyARIntRect i_area, int i_th) throws NyARException {
            this.label_stack.clear();
            super.labeling(i_raster, i_area, i_th);
            this.label_stack.sortByArea();
        }

        @Override
        public void labeling(NyARBinRaster i_bin_raster) throws NyARException {
            this.label_stack.clear();
            super.labeling(i_bin_raster);
            this.label_stack.sortByArea();
        }

        @Override
        protected void onLabelFound(NyARRleLabelFragmentInfo i_label) {
            if (i_label.clip_l == 0 || i_label.clip_r == this._right) {
                return;
            }
            if (i_label.clip_t == 0 || i_label.clip_b == this._bottom) {
                return;
            }
            this.label_stack.push(i_label);
        }
    }
}

