/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.reality.nyartk;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.INyARDisposable;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.core.utils.NyARManagedObject;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTargetPool;
import jp.nyatla.nyartoolkit.rpf.realitysource.nyartk.NyARRealitySource;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.NyARTarget;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.status.NyARRectTargetStatus;

public class NyARRealityTarget
extends NyARManagedObject {
    public Object tag;
    public static final int INVALID_REALITY_TARGET_ID = -1;
    private static Object _serial_lock = new Object();
    private static long _serial_counter = 0L;
    private NyARRealityTargetPool _ref_pool;
    public long _serial;
    public NyARTransMatResult _transform_matrix = new NyARTransMatResult();
    public static final int RT_UNKNOWN = 0;
    public static final int RT_KNOWN = 2;
    public static final int RT_DEAD = 4;
    public int _target_type;
    public NyARRectOffset _offset = new NyARRectOffset();
    public NyARTarget _ref_tracktarget;
    public NyARSquare _screen_square = new NyARSquare();
    public int _grab_rate;

    public NyARRealityTarget(NyARRealityTargetPool i_pool) {
        super(i_pool._op_interface);
        this._ref_pool = i_pool;
    }

    @Override
    public int releaseObject() {
        int ret = super.releaseObject();
        if (ret == 0) {
            if (this._ref_tracktarget instanceof INyARDisposable) {
                ((INyARDisposable)((Object)this._ref_tracktarget)).dispose();
            }
            this._ref_tracktarget.tag = null;
            this._ref_tracktarget.releaseObject();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createSerialId() {
        Object object = _serial_lock;
        synchronized (object) {
            return _serial_counter++;
        }
    }

    public final NyARTransMatResult refTransformMatrix() {
        assert (this._target_type == 2);
        return this._transform_matrix;
    }

    public int getTargetType() {
        return this._target_type;
    }

    public long getSerialId() {
        return this._serial;
    }

    public int getGrabbRate() {
        return this._grab_rate;
    }

    public final NyARDoublePoint2d[] refTargetVertex() {
        assert (this._target_type == 0 || this._target_type == 2);
        return ((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex;
    }

    public final void getTargetVertex(NyARDoublePoint2d[] o_vertex) {
        assert (this._target_type == 0 || this._target_type == 2);
        NyARDoublePoint2d[] v = ((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex;
        int i = 3;
        while (i >= 0) {
            o_vertex[i].setValue(v[i]);
            --i;
        }
    }

    public final void getTargetCenter(NyARDoublePoint2d o_center) {
        assert (this._target_type == 0 || this._target_type == 2);
        NyARDoublePoint2d.makeCenter(((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex, 4, o_center);
    }

    public final void getTargetCenter(NyARIntPoint2d o_center) {
        assert (this._target_type == 0 || this._target_type == 2);
        NyARDoublePoint2d.makeCenter(((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex, 4, o_center);
    }

    public final boolean isInnerVertexPoint2d(int i_x, int i_y) {
        assert (this._target_type == 0 || this._target_type == 2);
        NyARDoublePoint2d[] vx = ((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex;
        int i = 3;
        while (i >= 0) {
            if (NyARDoublePoint2d.crossProduct3Point(vx[i], vx[(i + 1) % 4], i_x, i_y) < 0.0) {
                return false;
            }
            --i;
        }
        return true;
    }

    public final boolean isInnerRectPoint2d(int i_x, int i_y) {
        assert (this._target_type == 0 || this._target_type == 2);
        NyARIntRect rect = new NyARIntRect();
        NyARDoublePoint2d[] vx = ((NyARRectTargetStatus)this._ref_tracktarget._ref_status).vertex;
        rect.setAreaRect(vx, 4);
        return rect.isInnerPoint(i_x, i_y);
    }

    public final boolean getRgbPatt3d(NyARRealitySource i_src, NyARDoublePoint3d[] i_vertex, NyARDoubleMatrix44 i_matrix, int i_resolution, INyARRgbRaster o_raster) throws NyARException {
        assert (this._target_type == 2);
        NyARDoublePoint2d[] da4 = this._ref_pool._wk_da2_4;
        NyARDoublePoint3d v3d = new NyARDoublePoint3d();
        if (i_matrix != null) {
            int i = 3;
            while (i >= 0) {
                i_matrix.transform3d(i_vertex[i], v3d);
                this._transform_matrix.transform3d(v3d, v3d);
                this._ref_pool._ref_prj_mat.project(v3d, da4[i]);
                --i;
            }
        } else {
            int i = 3;
            while (i >= 0) {
                this._transform_matrix.transform3d(i_vertex[i], v3d);
                this._ref_pool._ref_prj_mat.project(v3d, da4[i]);
                --i;
            }
        }
        return i_src.refPerspectiveRasterReader().read4Point(i_src.refRgbSource(), da4, 0, 0, i_resolution, o_raster);
    }

    public final boolean getRgbRectPatt3d(NyARRealitySource i_src, double i_x, double i_y, double i_w, double i_h, int i_resolution, INyARRgbRaster o_raster) throws NyARException {
        assert (this._target_type == 2);
        NyARDoublePoint3d[] da4 = this._ref_pool._wk_da3_4;
        da4[0].x = i_x;
        da4[0].y = i_y + i_h;
        da4[0].z = 0.0;
        da4[1].x = i_x + i_w;
        da4[1].y = i_y + i_h;
        da4[1].z = 0.0;
        da4[2].x = i_x + i_w;
        da4[2].y = i_y;
        da4[2].z = 0.0;
        da4[3].x = i_x;
        da4[3].y = i_y;
        da4[3].z = 0.0;
        return this.getRgbPatt3d(i_src, da4, null, i_resolution, o_raster);
    }
}

