/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.sampler.lrlabel;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARLabeling_Rle;
import jp.nyatla.nyartoolkit.core.labeling.rlelabeling.NyARRleLabelFragmentInfo;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.rpf.sampler.lrlabel.LowResolutionLabelingSamplerOut;

public class LowResolutionLabelingSampler {
    private Main_Labeling _main_labeling;

    public LowResolutionLabelingSampler(int i_width, int i_height, int i_pix_size) throws NyARException {
        this._main_labeling = new Main_Labeling(i_width / i_pix_size, i_height / i_pix_size, i_pix_size);
    }

    public void sampling(NyARGrayscaleRaster i_in, int i_th, LowResolutionLabelingSamplerOut o_out) throws NyARException {
        Main_Labeling lb = this._main_labeling;
        lb.current_output = o_out;
        lb.current_th = i_th;
        o_out.initializeParams();
        lb.setAreaRange(10000, 3);
        lb.labeling(i_in, i_th);
    }

    private class Main_Labeling
    extends NyARLabeling_Rle {
        private int _pix;
        public int current_th;
        public LowResolutionLabelingSamplerOut current_output;

        public Main_Labeling(int i_width, int i_height, int i_pix_base) throws NyARException {
            super(i_width, i_height);
            this._pix = i_pix_base;
        }

        @Override
        protected void onLabelFound(NyARRleLabelFragmentInfo iRefLabel) throws NyARException {
            int w = iRefLabel.clip_r - iRefLabel.clip_l;
            int h = iRefLabel.clip_b - iRefLabel.clip_t;
            if (w < 10 || h < 10) {
                return;
            }
            LowResolutionLabelingSamplerOut.Item item = this.current_output.prePush();
            if (item == null) {
                return;
            }
            int pix = this._pix;
            item.entry_pos.x = iRefLabel.entry_x;
            item.entry_pos.y = iRefLabel.clip_t;
            item.base_area.x = iRefLabel.clip_l * pix;
            item.base_area.y = iRefLabel.clip_t * pix;
            item.base_area.w = w * pix;
            item.base_area.h = h * pix;
            item.base_area_center.x = item.base_area.x + item.base_area.w / 2;
            item.base_area_center.y = item.base_area.y + item.base_area.h / 2;
            item.base_area_sq_diagonal = (w * w + h * h) * (pix * pix);
            item.lebeling_th = this.current_th;
        }
    }
}

