#pragma once
#include "INyARColorPatt.h"
#include "NyARBufferReader.h"
#include "NyARMat.h"
#include "NyARSquare.h"
#include "NyAR_types.h"
#include "NyARRgbPixelReader_INT1D_X8R8G8B8_32.h"
namespace NyARToolkitCPP
{
	class NyARColorPatt_O3 :public INyARColorPatt
	{
	private:
		int* _patdata;
		NyARBufferReader* _buf_reader;
		TNyARIntSize _size;
		NyARRgbPixelReader_INT1D_X8R8G8B8_32* _pixelreader;
	public:	
		NyARColorPatt_O3(int i_width, int i_height);
		virtual ~NyARColorPatt_O3();
		int getWidth()const;
		int getHeight()const;
		const TNyARIntSize& getSize()const;
		const INyARBufferReader& getBufferReader()const;
		const INyARRgbPixelReader& getRgbPixelReader()const;

	private:
		NyARMat* __get_cpara_a;
		NyARMat* __get_cpara_b;
		NyARMat* __pickFromRaster_cpara;
	private:
		bool get_cpara(const TNyARIntPoint2d i_vertex[], NyARMat& o_para);
		void updateExtpat(const INyARRgbRaster& image, const NyARMat& i_cpara, int i_xdiv2,int i_ydiv2);
	public:
		bool pickFromRaster(const INyARRgbRaster& image, const NyARSquare& i_square);

	private:
		int* __updateExtpat_rgbset;
		int* __updateExtpat_xc;
		int* __updateExtpat_yc;
		double* __updateExtpat_xw;
		double* __updateExtpat_yw;
		int _last_pix_resolution_x;
		int _last_pix_resolution_y;
		void reservWorkBuffers(int i_xdiv,int i_ydiv);

	};

}
