#pragma once
#include "NyARRgbPixelReader_BYTE1D_X8R8G8B8_32.h"


namespace NyARToolkitCPP
{
	NyARRgbPixelReader_BYTE1D_X8R8G8B8_32::NyARRgbPixelReader_BYTE1D_X8R8G8B8_32(const TNyARIntSize* i_size,const NyAR_BYTE_t* i_buf)
	{
		this->_ref_buf = i_buf;
		this->_size = i_size;
	}
	void NyARRgbPixelReader_BYTE1D_X8R8G8B8_32::getPixel(int i_x, int i_y, int* o_rgb)const
	{
		const NyAR_BYTE_t* rgb= this->_ref_buf+i_x + i_y * this->_size->w*4;
		o_rgb[0] = *(rgb+1)&0xff;// R
		o_rgb[1] = *(rgb+2)&0xff;// G
		o_rgb[2] = *(rgb+3)&0xff;// B
		return;
	}

	void NyARRgbPixelReader_BYTE1D_X8R8G8B8_32::getPixelSet(const int* i_x,const int* i_y, int i_num, int* o_rgb)const
	{
		const int width = this->_size->w;
		const NyAR_BYTE_t* ref_buf = this->_ref_buf;
		for (int i = i_num - 1; i >= 0; i--){
			const NyAR_BYTE_t* rgb=ref_buf+(i_x[i] + i_y[i] * width)*4;
			o_rgb[i * 3 + 0] =*(rgb+1)&0xff;// R
			o_rgb[i * 3 + 1] =*(rgb+2)&0xff;// G
			o_rgb[i * 3 + 2] =*(rgb+3)&0xff;// B
		}
		return;
	}
}

