/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#pragma once
#include "NyARParam.h"
#include "NyARMatchPatt_Color_WITHOUT_PCA.h"
#include "INyARSquareDetector.h"
#include "INyARTransMat.h"
#include "NyARTransMat.h"
#include "NyARRasterFilter_ARToolkitThreshold.h"
#include "NyARTransMatResult.h"
#include "NyARColorPatt_Perspective_O2.h"
#include "NyARSquareStack.h"
#include "NyAR_types.h"
#include "NyARSquareDetector_Rle.h"
#include "NyARRasterThresholdAnalyzer_SlidePTile.h"


namespace NyARToolkitCPP
{
	typedef struct TResult_selectARCodeIndex_t
	{
		int direction;
		double confidence;
		int code_index;
	}TResult_selectARCodeIndex;
	/**
	* ̃NX́AɂP̃}[J邱Ƃ̂łAAvP[VvZbTłB
	* }[J̏oEړEłACxgŒʒm邱Ƃł܂B
	* NXɂ͕̃}[Jo^ł܂B̃}[JƁAvZbT͌pē}[J
	* PFA܂ł̊Ԃ͑̃}[JF܂B
	* 
	* CxǵA OnEnterOnUpdate[n]OnLeavȅŔ܂B
	* }[JƂ܂OnEnterPxāAԂ̃}[Jꂽ킩܂B
	* OnUpdateɂA݂̕ϊs񂪘Aēn܂BŌɃ}[JƁAOnLeave
	* Cxg܂B
	* 
	*/
	class SingleARMarkerProcesser:public NyARBaseClass
	{
	public:
		/**I[i[RɎg^OϐłB
		*/
		void* tag;
	private:
		int _lost_delay_count;
		int _lost_delay;
		INyARSquareDetector* _square_detect;
	protected:
		NyARTransMat* _transmat;

	private:
		double _marker_width;
		NyArray<NyARMatchPatt_Color_WITHOUT_PCA*>* _match_patt;
		NyARSquareStack* _square_list;

		INyARColorPatt* _patt;

		double _cf_threshold_new ;
		double _cf_threshold_exist;
		int _threshold;
	private:
		NyARBinRaster* _bin_raster;
		NyARRasterFilter_ARToolkitThreshold* _tobin_filter;
		bool _initialized;

	protected:
		int _current_arcode_index;
	private:
		NyARMatchPattDeviationColorData* _deviation_data;
		NyARRasterThresholdAnalyzer_SlidePTile* _threshold_detect;

	protected:
		SingleARMarkerProcesser();
		virtual ~SingleARMarkerProcesser();
		void initInstance(const NyARParam* i_param,int i_raster_type);
	private:
		void freeARCodeTable();
	public:
		void setARCodeTable(NyARCode* const i_ref_code_table[],int i_number_of_code, int i_code_resolution, double i_marker_width);
		void reset(bool i_is_force);
		void detectMarker(const INyARRgbRaster& i_raster);
	private:
		/**ARCodẽXgAłvR[hԍ܂B
		*/
		bool selectARCodeIndexFromList(const INyARRgbRaster& i_raster,const NyARSquare& i_square, TResult_selectARCodeIndex& o_result);
		/**VK}[J ݔF̃}[JȂ̂ƂāAłF₷}[JPF܂B
		*/
		void detectNewMarker(const INyARRgbRaster& i_raster,NyARSquareStack& i_stack);
		/**}[J̌pF ݔF̃}[JD悵ĔF܂B 
		* ij̋@\͂Ԃ񍡌ア낢딭W邩NewƍȂƁB
		*/
		void detectExistMarker(const INyARRgbRaster& i_raster,const NyARSquareStack& i_stack, int i_current_id);
	private:
		NyARTransMatResult __NyARSquare_result;

		/**	IuWFNg̃Xe[^XXVAKvɉănh֐쓮܂B
		* 	߂ĺAuۂɃ}[J𔭌鎖łvłBNX̏ԂƂ͈قȂ܂B
		*/
		bool updateStatus(const NyARSquare& i_square, int i_code_index, double i_cf, int i_dir);
	protected:
		virtual void onEnterHandler(int i_code)=0;
		virtual void onLeaveHandler()=0;
		virtual void onUpdateHandler(const NyARSquare& i_square, const NyARTransMatResult& result)=0;
	};
}
