/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCPP is C++ version NyARToolkit class library.
* Copyright (C)2008-2009 Ryo Iizuka
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
* 
*/
#include "NyARRaster.h"
#include "nyarcore.h"
namespace NyARToolkitCPP
{
	/**̃NX́AP@\NyARRasterłB
	* ^Cṽobt@bvAINyARBufferReaderC^tFCX񋟂܂B
	*
	*/
	const INyARBufferReader& NyARRaster::getBufferReader()const
	{
		return *(this->_reader);
	}
	NyARRaster::NyARRaster(const TNyARIntSize& i_size,const void* i_ref_buf,int i_buf_type):NyARRaster_BasicClass(i_size)
	{
		this->_reader=new NyARBufferReader(i_ref_buf,i_buf_type);
		return;
	}
	NyARRaster::~NyARRaster()
	{
		NyAR_SAFE_DELETE(this->_reader);
		return;
	}
}
