#!/usr/bin/env ruby
# encoding: utf-8
require 'FileUtils'


def change_configure(data)
	data.sub!(/AC_ARG_ENABLE\(\[excmd\][^\(]*\([^\(]*\([^\)]*\)[^\)]*\)[^\)]*\)/,"")
	data.sub!(/AM_CONDITIONAL\(EXCMD,[^\)]*\)/,"AM_CONDITIONAL(EXCMD,false)")
	return data
end

def change_limit(data)
	data.gsub!(/\/\/if\(kgmod->oRecNo\(\)>LIMIT_OUT\)\{WriteMsg\(LIMIT_MSG,getTime\(\)\);\}/,"if(kgmod->oRecNo()>LIMIT_OUT){WriteMsg(LIMIT_MSG,getTime());}")
	return data
end

SFG_repo = "https://scm.sourceforge.jp/gitroot/nysol/mcmd.git"



First_MSG="\
==================== OSI UPLOAD TOOL ====================\n\
# このプログラムはlocal にある backlog git ソースを  \n\
# Source forgeにアップロードするプログラムである \n\
# 後々ややこしくなることをさけるためにlocalのソースを\n\
# 最新しておくことをおすすめする。\n\
# 実際にはbacklog git MCMDに登録されている、\n\
# このファイルとlib/exmodとexcmd以下を除くすべてのソースがアップされる\n\
# configure.in、lib/kgMessage.cppがオープソース用に修正され、\n\
# revison_hash(backlog git MCMDのバージョン情報)というファイルが追加される\n\
==================== OSI UPLOAD TOOL ====================\n"
print First_MSG
print "実行場所は？  "
workdic = gets.chomp
curent = ENV['PWD']
if workdic =="" then
	workdic = "#{ENV['HOME']}/workupload"
end
if File.exist?("#{workdic}/gitdata") then
	FileUtils.rm_rf("#{workdic}/gitdata")
end
FileUtils.mkdir_p("#{workdic}/gitdata")
print "commitメッセージは？  \n"
cmmsg = gets.chomp


#sourceforgeの現状のデータを取得
system("git clone #{SFG_repo} #{workdic}/gitdata")
system("git config user.email nain0606@gmail.com")
# それぞれのファイル一覧取得
system("git ls-files > /tmp/uposi_xxx0")

FileUtils.cd("#{workdic}/gitdata")
system("git ls-files > /tmp/uposi_xxx1")

FileUtils.cd("#{curent}")


#ファイルコピー
File.open("/tmp/uposi_xxx0"){|fpr|
	while line = fpr.gets() do
		fn = line.chomp
		next if fn =~ /^excmd\//
		next if fn =~ /^lib\/exmod\//
		next if fn =~ /^lib\/exhelp\//
		destfn = "#{workdic}/gitdata/#{fn}"
		dfn = File.dirname(destfn)
		unless File.exist?(dfn) then
			FileUtils.mkdir_p(dfn)
		end
		if fn == "configure.in" then
			dc=""
			File.open(fn){|fprx|
				dc = fprx.read
				dc = change_configure(dc)
			}
			File.open(destfn,"w"){|fpwx|
				fpwx.write(dc)	
			}
		elsif fn == "lib/kgMessage.cpp" then
			dc=""
			File.open(fn){|fprx|
				dc = fprx.read
				dc = change_limit(dc)
			}
			File.open(destfn,"w"){|fpwx|
				fpwx.write(dc)	
			}
		else
			system("cp #{fn} #{workdic}/gitdata/#{fn}")
		end
	end
}

#バージョン情報セット
system("git log | grep commit | head -n 1 >/tmp/uposi_xxxv")
system("cp /tmp/uposi_xxxv #{workdic}/gitdata/revison_hash")


# add delete ファイル決定
# souceforge にだけ有る物は削除(ただしrevison_hashは除く)
system("msortf -nfn f=0 i=/tmp/uposi_xxx0 o=/tmp/uposi_xxx2")
system("msortf -nfn f=0 i=/tmp/uposi_xxx1 o=/tmp/uposi_xxx3")
system("mcommon -nfn k=0 i=/tmp/uposi_xxx3 m=/tmp/uposi_xxx2 u=/tmp/uposi_xxx5 o=/tmp/uposi_xxx4")

FileUtils.cd("#{workdic}/gitdata")

# git rm
File.open("/tmp/uposi_xxx5"){|fpr|
	while line = fpr.gets() do
		fn = line.chomp
		next if fn == "revison_hash"
		system("git rm #{fn}")
	end
}

# git add
File.open("/tmp/uposi_xxx2"){|fpr|
	while line = fpr.gets() do
		fn = line.chomp
		next if fn =~ /^excmd\//
		next if fn =~ /^lib\/exmod\//
		next if fn =~ /^lib\/exhelp\//
		system("git add #{fn}")
	end
}

system("git add revison_hash")
system("git commit -m \"#{cmmsg}\"")

# make実行して確認
#system("aclocal ; autoreconf -i ; automake --add-missing")
#system("./configure")
#system("make")



Final_MSG="\n\
------------------------------------------------------------\n\
make等でエラーが出ていないことを確認してください\n\
'y'を押すとgit pushしてしまいます。ほんとうにいいですか？\n\
------------------------------------------------------------\n"
print Final_MSG
pullgo = gets.chomp
if pullgo !='y' then
	print "git pushせずに終了します\n"
	exit()
end
system("git push")





