#!/usr/bin/env ruby

require "rubygems"
require "mcmd"

require "enumLcmEp.rb"
require "enumLcmIs.rb"

module TAKE

#=CAEPクラス(基底クラス: Cmodel)
# 顕在パターン(Emerging Patterns)を利用した分類モデル
#
class Caep
	attr_reader :dir
	attr_reader :ev
	attr_reader :t_ev
	attr_reader :t_tid_score
	attr_reader :t_tid_pats

	#=== Caepクラスの初期化
	#
	#====引数
	# ep: EP オブジェクト
	#
	#====機能
	#* 列挙されたepに基づいて、分類モデル(caep)を構築する。
	#
	#====機能
	#* epに基づいてモデルを構築する。
	#* 構築されたモデルを評価する(Cmodelのメソッド全て利用可能)。
	def initialize(db,cls,eArgs)
		@temp=MCMD::Mtemp.new

		@db    = db
		@cls   = cls
		@eArgs = eArgs

		pat=nil
		if @cls then
  		pat=TAKE::LcmEp.new(@db,@cls);
  		pat.enumerate(eArgs["type"],eArgs["minSup"],eArgs["minCnt"],eArgs["minGR"],eArgs["minProb"],eArgs["uniform"],eArgs["minLen"],eArgs["maxLen"],eArgs["top"])
		else
  		pat=TAKE::LcmIs.new(@db);
  		pat.enumerate(eArgs["type"],eArgs["minSup"],eArgs["minLen"],eArgs["maxLen"],eArgs["top"],eArgs["minCnt"])
		end

		# クラス指定がない場合もしくは-nomodelが指定された場合はパターン列挙のみ
		if not @cls or eArgs["nomodel"] then
			@pat=pat
			return
		end
	end

  def output(outpath)
		# クラス指定なしの場合
		if @pat!=nil then
			@pat.output(outpath)
		end
		return
	end
end

end #module

