/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol.v11;

import com.funambol.framework.core.Alert;
import com.funambol.framework.core.AlertCode;
import com.funambol.framework.core.Get;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.Replace;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.v11.BasicRequirements;
import com.funambol.framework.protocol.v11.Errors;
import java.util.ArrayList;

public class InitializationRequirements
extends BasicRequirements
implements Errors {
    public static void checkAlertCommand(Alert alert, boolean checkAnchor) throws ProtocolException {
        try {
            BasicRequirements.checkAlertCommand(alert);
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new ProtocolException("Invalid alert command ({0})", args);
        }
        if (!AlertCode.isInitializationCode(alert.getData())) {
            Object[] args = new String[]{String.valueOf(alert.getData())};
            throw new ProtocolException("The alert code {0} is not an initialization code", args);
        }
        if (!checkAnchor) {
            return;
        }
        Item[] items = alert.getItems().toArray(new Item[0]);
        if (items == null || items.length == 0) {
            throw new ProtocolException("The item element is missing");
        }
        try {
            InitializationRequirements.checkSource(items[0].getSource());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{"source"};
            throw new ProtocolException("Invalid alert command ({0})", args);
        }
        try {
            InitializationRequirements.checkTarget(items[0].getTarget());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{"target"};
            throw new ProtocolException("Invalid alert command ({0})", args);
        }
        Meta meta = items[0].getMeta();
        if (meta == null || meta.getAnchor() == null) {
            throw new ProtocolException("The sync anchor element is missing");
        }
    }

    public static void checkCapabilitiesRequest(Get cmd) throws ProtocolException {
        try {
            InitializationRequirements.checkCommandId(cmd.getCmdID());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        Item[] items = cmd.getItems().toArray(new Item[0]);
        if (items == null || items.length == 0) {
            Object[] args = new String[]{"The item element is missing"};
            throw new ProtocolException("Invalid capabilities request ({1})", args);
        }
        try {
            InitializationRequirements.checkTarget(items[0].getTarget());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{"missing target"};
            throw new ProtocolException("Invalid capabilities request ({1})", args);
        }
    }

    public static void checkDeviceInfo(Replace cmd) throws ProtocolException {
        InitializationRequirements.checkCommandId(cmd.getCmdID());
        ArrayList<Item> nodes = cmd.getItems();
        if (nodes.isEmpty()) {
            throw new ProtocolException("No node specified for device info");
        }
    }
}

