/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Frame;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import javax.swing.JButton;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class Chat
implements MouseListener,
WindowListener,
MessageListener,
MembershipListener {
    static Chat selfRef;
    Channel channel;
    PullPushAdapter ad;
    Thread mainThread;
    String group_name = "ChatGroup";
    String props = null;
    Frame mainFrame;
    TextArea ta;
    TextField tf;
    Label csLabel;
    JButton ltjButton;
    JButton castButton;
    JButton sendButton;
    JButton rnvButton;

    public Chat(String props) {
        this.props = props;
    }

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-props")) {
                Chat.help();
                return;
            }
            props = args[++i];
        }
        Trace.init();
        selfRef = new Chat(props);
        selfRef.go();
    }

    static void help() {
        System.out.println("Chat [-help] [-props <properties>]");
    }

    public void go() {
        this.mainFrame = new Frame();
        this.mainFrame.setLayout(null);
        this.mainFrame.setSize(600, 507);
        this.mainFrame.addWindowListener(this);
        this.ta = new TextArea();
        this.ta.setBounds(12, 36, 550, 348);
        this.ta.setEditable(false);
        this.mainFrame.add(this.ta);
        this.tf = new TextField();
        this.tf.setBounds(100, 392, 400, 30);
        this.mainFrame.add(this.tf);
        this.csLabel = new Label("Cast/Send:");
        this.csLabel.setBounds(12, 392, 85, 30);
        this.mainFrame.add(this.csLabel);
        this.ltjButton = new JButton("LeaveThenJoin");
        this.ltjButton.setBounds(12, 428, 150, 30);
        this.ltjButton.addMouseListener(this);
        this.mainFrame.add(this.ltjButton);
        this.castButton = new JButton("Cast");
        this.castButton.setBounds(182, 428, 150, 30);
        this.castButton.addMouseListener(this);
        this.mainFrame.add(this.castButton);
        this.sendButton = new JButton("Send");
        this.sendButton.setBounds(355, 428, 86, 30);
        this.sendButton.addMouseListener(this);
        this.sendButton.setEnabled(false);
        this.mainFrame.add(this.sendButton);
        try {
            this.channel = new JChannel(this.props);
            this.channel.setOpt(5, new Boolean(true));
            System.out.println("Connecting to " + this.group_name);
            this.channel.connect(this.group_name);
            this.ad = new PullPushAdapter(this.channel, this, this);
        }
        catch (Exception e) {
            this.ta.append(e.toString());
        }
        this.mainFrame.pack();
        this.mainFrame.show();
    }

    public void receive(Message msg) {
        try {
            Object o = Util.objectFromByteBuffer(msg.getBuffer());
            this.ta.append(o.toString() + " [" + msg.getSrc() + "]\n");
        }
        catch (Exception e) {
            this.ta.append("Chat.receive(): " + e);
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        this.ta.append("Received view " + new_view + "\n");
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    private synchronized void handleLTJ() {
        try {
            System.out.print("Stopping PullPushAdapter");
            this.ad.stop();
            System.out.println(" -- done");
            System.out.print("Disconnecting the channel");
            this.channel.disconnect();
            System.out.println(" -- done");
            System.out.print("Closing the channel");
            this.channel.close();
            System.out.println(" -- done");
            System.out.print("Reopening the channel");
            this.channel.open();
            System.out.println(" -- done");
            System.out.print("Connecting to " + this.group_name);
            this.channel.connect(this.group_name);
            System.out.println(" -- done");
            System.out.print("Starting PullPushAdapter");
            this.ad.start();
            System.out.println(" -- done");
            this.ta.append("successfully rejoined the group\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ta.append("Failed rejoined the group: " + e.toString() + "\n");
        }
    }

    private void handleCast() {
        Message msg = new Message(null, null, (Serializable)((Object)this.tf.getText()));
        try {
            this.channel.send(msg);
        }
        catch (Exception e) {
            this.ta.append("Failed casting: " + e.toString() + "\n");
        }
    }

    private void handleSend() {
    }

    public void mouseClicked(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.ltjButton) {
            this.handleLTJ();
        } else if (obj == this.castButton) {
            this.handleCast();
        } else if (obj == this.sendButton) {
            this.handleSend();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

