/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FRAG
extends Protocol {
    private int frag_size = 8192;
    private FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private Address local_addr = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(this.frag_size);
    private Vector members = new Vector();

    public String getName() {
        return "FRAG";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("frag_size");
        if (str != null) {
            this.frag_size = new Integer(str);
            props.remove("frag_size");
        }
        if (props.size() > 0) {
            System.err.println("FRAG.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void reset() {
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size = msg.size();
                if (size <= (long)this.frag_size) break;
                if (Trace.trace) {
                    Trace.info("FRAG.down()", "message size is " + size + ", will fragment " + "(frag_size == " + this.frag_size + ")");
                }
                this.fragment(msg);
                return;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector new_mbrs = view.getMembers();
                Vector left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
                this.members.clear();
                this.members.addAll(new_mbrs);
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    Address mbr = (Address)left_mbrs.elementAt(i);
                    this.fragment_list.remove(mbr);
                    if (!Trace.trace) continue;
                    Trace.info("FRAG.down()", "[VIEW_CHANGE] removed " + mbr + " from fragmentation table");
                }
                break;
            }
            case 56: {
                this.passDown(evt);
                if (Trace.trace) {
                    Trace.info("FRAG.down()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof FragHeader)) break;
                this.unfragment(msg);
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (Trace.trace) {
                    Trace.info("FRAG.up()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    private void fragment(Message msg) {
        Message frag_msg = null;
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        long id = this.curr_id++;
        int num_frags = 0;
        try {
            this.bos.reset();
            ObjectOutputStream oos = new ObjectOutputStream(this.bos);
            msg.writeExternal(oos);
            oos.flush();
            byte[] buffer = this.bos.toByteArray();
            byte[][] fragments = Util.fragmentBuffer(buffer, this.frag_size);
            num_frags = fragments.length;
            if (Trace.trace) {
                Trace.info("FRAG.fragment()", "fragmenting packet to " + (dest != null ? dest.toString() : "<all members>") + " (size=" + buffer.length + ") into " + num_frags + " fragment(s) [frag_size=" + this.frag_size + "]");
            }
            for (int i = 0; i < num_frags; ++i) {
                frag_msg = new Message(dest, src, fragments[i]);
                FragHeader hdr = new FragHeader(id, i, num_frags);
                if (Trace.trace) {
                    Trace.debug("FRAG.fragment()", "fragment's header is " + hdr);
                }
                frag_msg.putHeader(this.getName(), hdr);
                Event evt = new Event(1, frag_msg);
                this.passDown(evt);
            }
        }
        catch (Exception e) {
            Trace.error("FRAG.fragment()", "exception is " + e);
        }
    }

    private void unfragment(Message msg) {
        byte[] m;
        FragmentationTable frag_table = null;
        Address sender = msg.getSrc();
        FragHeader hdr = (FragHeader)msg.removeHeader(this.getName());
        if (Trace.trace) {
            Trace.debug("FRAG.unfragment()", "[" + this.local_addr + "] received msg, hdr is " + hdr);
        }
        if ((frag_table = this.fragment_list.get(sender)) == null) {
            frag_table = new FragmentationTable(sender);
            try {
                this.fragment_list.add(sender, frag_table);
            }
            catch (IllegalArgumentException x) {
                frag_table = this.fragment_list.get(sender);
            }
        }
        if ((m = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg.getBuffer())) != null) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(m);
                ObjectInputStream ois = new ObjectInputStream(bis);
                Message assembled_msg = new Message();
                assembled_msg.readExternal(ois);
                if (Trace.trace) {
                    Trace.info("FRAG.unfragment()", "assembled_msg is " + assembled_msg);
                }
                assembled_msg.setSrc(sender);
                this.passUp(new Event(1, assembled_msg));
            }
            catch (Exception e) {
                Trace.error("FRAG.unfragment()", "exception is " + e);
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
        }
    }

    class FragmentationTable {
        private Address sender;
        private Hashtable h = new Hashtable(11);

        public FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized byte[] add(long id, int frag_id, int tot_frags, byte[] fragment) {
            byte[] retval = null;
            Entry e = (Entry)this.h.get(new Long(id));
            if (e == null) {
                e = new Entry(id, tot_frags);
                this.h.put(new Long(id), e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleBuffer();
                this.h.remove(new Long(id));
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                int count = 0;
                for (int i = 0; i < entry.fragments.length; ++i) {
                    if (entry.fragments[i] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        class Entry {
            int tot_frags = 0;
            byte[][] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            Entry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new byte[tot_frags][];
                for (int i = 0; i < tot_frags; ++i) {
                    this.fragments[i] = null;
                }
            }

            public void set(int frag_id, byte[] frag) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i = 0; i < this.fragments.length; ++i) {
                    if (this.fragments[i] != null) continue;
                    return false;
                }
                return true;
            }

            public byte[] assembleBuffer() {
                return Util.defragmentBuffer(this.fragments);
            }

            public String toString() {
                StringBuffer ret = new StringBuffer();
                ret.append("[tot_frags=" + this.tot_frags + ", number_of_frags_recvd=" + this.number_of_frags_recvd + "]");
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    class FragmentationList {
        private Hashtable frag_tables = new Hashtable(11);

        FragmentationList() {
        }

        public synchronized void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            FragmentationTable healthCheck = (FragmentationTable)this.frag_tables.get(sender);
            if (healthCheck != null) {
                throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list.");
            }
            this.frag_tables.put(sender, table);
        }

        public FragmentationTable get(Address sender) {
            return (FragmentationTable)this.frag_tables.get(sender);
        }

        public boolean containsSender(Address sender) {
            return this.frag_tables.containsKey(sender);
        }

        public synchronized boolean remove(Address sender) {
            boolean result = this.containsSender(sender);
            this.frag_tables.remove(sender);
            return result;
        }

        public synchronized Address[] getSenders() {
            Address[] result = new Address[this.frag_tables.size()];
            Enumeration enumeration = this.frag_tables.keys();
            int index = 0;
            while (enumeration.hasMoreElements()) {
                result[index++] = (Address)enumeration.nextElement();
            }
            return result;
        }

        public String toString() {
            Enumeration e = this.frag_tables.elements();
            StringBuffer buf = new StringBuffer("Fragmentation list contains ").append(this.frag_tables.size()).append(" tables\n");
            while (e.hasMoreElements()) {
                buf.append(e.nextElement());
            }
            return buf.toString();
        }
    }

    public static class FragHeader
    extends Header {
        public long id = 0L;
        public int frag_id = 0;
        public int num_frags = 0;

        public FragHeader() {
        }

        public FragHeader(long id, int frag_id, int num_frags) {
            this.id = id;
            this.frag_id = frag_id;
            this.num_frags = num_frags;
        }

        public String toString() {
            return "[FRAG: id=" + this.id + ", frag_id=" + this.frag_id + ", num_frags=" + this.num_frags + "]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.id);
            out.writeInt(this.frag_id);
            out.writeInt(this.num_frags);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readLong();
            this.frag_id = in.readInt();
            this.num_frags = in.readInt();
        }
    }
}

