/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.ring.RingNodeFlowControl;
import org.jgroups.protocols.ring.RingToken;
import org.jgroups.protocols.ring.TokenLostException;
import org.jgroups.protocols.ring.UdpRingNode;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RpcProtocol;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class TOTAL_TOKEN
extends RpcProtocol {
    private static int OPERATIONAL_STATE = 0;
    private static int RECOVERY_STATE = 1;
    UdpRingNode node;
    RingNodeFlowControl flowControl;
    Address localAddress;
    TokenTransmitter tokenRetransmitter = new TokenTransmitter();
    List newMessagesQueue;
    SortedSet liveMembersInRecovery;
    SortedSet suspects;
    Object mutex = new Object();
    TreeMap receivedMessagesQueue;
    long myAru = 0L;
    Object threadCoordinationMutex = new Object();
    boolean tokenInStack = false;
    boolean threadDeliveringMessage = false;
    boolean tokenSeen = false;
    volatile boolean isRecoveryLeader = false;
    volatile int state;
    volatile int sleepTime = 10;
    long highestSeenSeq = 0L;
    long lastRoundTokensAru = 0L;
    int lastRoundTransmitCount;
    int lastRoundRebroadcastCount = 0;
    int blockSendingBacklogThreshold = Integer.MAX_VALUE;
    int unblockSendingBacklogThreshold = Integer.MIN_VALUE;
    boolean tokenCirculating = false;
    boolean senderBlocked = false;
    public static final String prot_name = "TOTAL_TOKEN";
    static /* synthetic */ Class class$java$util$Vector;

    public String getName() {
        return prot_name;
    }

    private String getState() {
        if (this.state == OPERATIONAL_STATE) {
            return "OPERATIONAL";
        }
        return "RECOVERY";
    }

    public void start() throws Exception {
        super.start();
        this.newMessagesQueue = Collections.synchronizedList(new ArrayList());
        this.receivedMessagesQueue = new TreeMap();
        this.tokenRetransmitter.start();
    }

    public void stop() {
        super.stop();
        this.tokenRetransmitter.shutDown();
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("block_sending");
        if (str != null) {
            this.blockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("block_sending");
        }
        if ((str = props.getProperty("unblock_sending")) != null) {
            this.unblockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("unblock_sending");
        }
        if (props.size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public IpAddress getTokenReceiverAddress() {
        return this.node != null ? this.node.getTokenReceiverAddress() : null;
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        return retval;
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.node = new UdpRingNode(this, this.localAddress);
                this.flowControl = new RingNodeFlowControl();
                break;
            }
            case 9: {
                Address suspect = (Address)evt.getArg();
                this.onSuspectMessage(suspect);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header h = msg.getHeader(this.getName());
                if (h instanceof TotalTokenHeader) {
                    this.messageArrived(msg);
                    return false;
                }
                if (!(h instanceof RingTokenHeader)) break;
                if (this.node != null) {
                    this.node.tokenArrived(msg.getObject());
                }
                return false;
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 39: 
            case 42: {
                Digest d = new Digest(this.members.size());
                Address sender = null;
                for (int j = 0; j < this.members.size(); ++j) {
                    sender = (Address)this.members.elementAt(j);
                    d.add(sender, this.highestSeenSeq, this.highestSeenSeq);
                }
                this.passUp(new Event(40, d));
                return false;
            }
            case 41: {
                Digest receivedDigest = (Digest)evt.getArg();
                this.myAru = receivedDigest.highSeqnoAt(0);
                return false;
            }
            case 6: {
                this.onViewChange();
                return true;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) {
                    return false;
                }
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.newMessagesQueue.add(msg);
                return false;
            }
        }
        return true;
    }

    private void onViewChange() {
        this.isRecoveryLeader = false;
        if (this.suspects != null) {
            this.suspects.clear();
            this.suspects = null;
        }
        if (this.liveMembersInRecovery != null) {
            this.liveMembersInRecovery.clear();
            this.liveMembersInRecovery = null;
        }
    }

    private void onSuspectMessage(Address suspect) {
        this.state = RECOVERY_STATE;
        if (this.suspects == null || this.suspects.size() == 0) {
            this.suspects = Collections.synchronizedSortedSet(new TreeSet());
            this.liveMembersInRecovery = Collections.synchronizedSortedSet(new TreeSet(this.members));
        }
        this.suspects.add(suspect);
        this.liveMembersInRecovery.removeAll(this.suspects);
        this.isRecoveryLeader = this.isRecoveryLeader(this.liveMembersInRecovery);
    }

    private boolean isRecoveryLeader(SortedSet liveMembers) {
        boolean recoveryLeader = false;
        if (liveMembers.size() > 0) {
            recoveryLeader = this.localAddress.equals(liveMembers.first());
        }
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.electRecoveryLeader()", "live memebers are " + liveMembers);
            Trace.info("TOTAL_TOKEN.electRecoveryLeader()", "I am recovery leader?" + recoveryLeader);
        }
        return recoveryLeader;
    }

    public long getAllReceivedUpTo() {
        return this.myAru;
    }

    public void installTransitionalView(Vector members) {
        if (this.node != null) {
            this.node.reconfigure(members);
        }
    }

    private void recover() {
        if (this.isRecoveryLeader && this.state == RECOVERY_STATE) {
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.recover()", "I am starting recovery now");
            }
            Vector m = new Vector(this.liveMembersInRecovery);
            RspList list = this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
            Vector myAllReceivedUpTos = list.getResults();
            this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
            Vector myAllReceivedUpTosConfirm = list.getResults();
            while (!myAllReceivedUpTos.equals(myAllReceivedUpTosConfirm)) {
                myAllReceivedUpTos = myAllReceivedUpTosConfirm;
                this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
                myAllReceivedUpTosConfirm = list.getResults();
                if (!Trace.trace) continue;
                Trace.info("TOTAL_TOKEN.recover()", "myAllReceivedUpto values are" + myAllReceivedUpTos);
                Trace.info("TOTAL_TOKEN.recover()", "myAllReceivedUpto confirm values are " + myAllReceivedUpTosConfirm);
            }
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.recover()", "myAllReceivedUpto stabilized values are" + myAllReceivedUpTos);
                Trace.info("TOTAL_TOKEN.recover()", "installing transitional view to repair the ring...");
            }
            this.callRemoteMethods(m, "installTransitionalView", new Object[]{m}, new String[]{(class$java$util$Vector == null ? (class$java$util$Vector = TOTAL_TOKEN.class$("java.util.Vector")) : class$java$util$Vector).getName()}, 2, 0L);
            Vector xmits = this.prepareRecoveryRetransmissionList(myAllReceivedUpTos);
            RingToken injectToken = null;
            if (xmits.size() > 1) {
                if (Trace.trace) {
                    Trace.info("TOTAL_TOKEN.recover()", "VS not satisfied, injecting recovery token...");
                }
                long aru = (Long)xmits.firstElement();
                long highest = (Long)xmits.lastElement();
                injectToken = new RingToken(RingToken.RECOVERY);
                injectToken.setHighestSequence(highest);
                injectToken.setAllReceivedUpto(aru);
                Collection rtr = injectToken.getRetransmissionRequests();
                rtr.addAll(xmits);
            } else {
                if (Trace.trace) {
                    Trace.info("TOTAL_TOKEN.recover()", "VS satisfied, injecting operational token...");
                }
                injectToken = new RingToken();
                long sequence = (Long)xmits.firstElement();
                injectToken.setHighestSequence(sequence);
                injectToken.setAllReceivedUpto(sequence);
            }
            if (this.node != null) {
                this.node.passToken(injectToken);
            }
            this.tokenRetransmitter.resetTimeout();
        }
    }

    private Vector prepareRecoveryRetransmissionList(Vector sequences) {
        Collections.sort(sequences);
        Long first = (Long)sequences.firstElement();
        Long last = (Long)sequences.lastElement();
        Vector<Long> retransmissions = new Vector<Long>();
        if (first.equals(last)) {
            retransmissions.add(new Long(first));
        } else {
            for (long j = first + 1L; j <= last; ++j) {
                retransmissions.add(new Long(j));
            }
        }
        return retransmissions;
    }

    protected void updateView(View newMembers) {
        super.updateView(newMembers);
        Vector newViewMembers = newMembers.getMembers();
        this.flowControl.viewChanged(newViewMembers.size());
        if (this.node != null) {
            this.node.reconfigure(newViewMembers);
        }
        boolean isCoordinator = this.localAddress.equals(newViewMembers.firstElement());
        int memberSize = newViewMembers.size();
        if (memberSize == 1 && isCoordinator && !this.tokenCirculating) {
            this.tokenCirculating = true;
            RingToken token = new RingToken();
            if (this.node != null) {
                this.node.passToken(token);
            }
            this.tokenRetransmitter.resetTimeout();
        }
        this.sleepTime = 20 / memberSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageArrived(Message m) {
        TotalTokenHeader h = (TotalTokenHeader)m.getHeader(this.getName());
        long seq = h.getSeq();
        Object object = this.mutex;
        synchronized (object) {
            if (this.myAru + 1L <= seq) {
                if (seq > this.highestSeenSeq) {
                    this.highestSeenSeq = seq;
                }
                this.receivedMessagesQueue.put(new Long(seq), m);
                if (this.myAru + 1L == seq) {
                    this.myAru = seq;
                    this.passUp(new Event(1, m));
                }
                if (this.isReceiveQueueHolePlugged()) {
                    this.myAru = this.deliverMissingMessages();
                }
            }
        }
    }

    private boolean isReceiveQueueHolePlugged() {
        return this.myAru < this.highestSeenSeq && this.receivedMessagesQueue.containsKey(new Long(this.myAru + 1L));
    }

    private long deliverMissingMessages() {
        Map.Entry entry = null;
        boolean inOrder = true;
        long lastDelivered = this.myAru;
        Set deliverySet = this.receivedMessagesQueue.tailMap(new Long(this.myAru + 1L)).entrySet();
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.messageArrived()", "hole getting plugged, prior muAru " + this.myAru);
        }
        Iterator iterator = deliverySet.iterator();
        while (inOrder && iterator.hasNext()) {
            entry = iterator.next();
            long nextInQueue = entry.getKey();
            if (lastDelivered + 1L == nextInQueue) {
                Message m = (Message)entry.getValue();
                this.passUp(new Event(1, m));
                ++lastDelivered;
                continue;
            }
            inOrder = false;
        }
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.messageArrived()", "hole getting plugged, post muAru " + lastDelivered);
        }
        return lastDelivered;
    }

    private void updateTokenRtR(RingToken token) {
        long holeLowerBound = 0L;
        long holeUpperBound = 0L;
        Long missingSequence = null;
        Collection retransmissionList = null;
        if (this.myAru < token.getHighestSequence()) {
            retransmissionList = token.getRetransmissionRequests();
            Set<Long> received = this.receivedMessagesQueue.tailMap(new Long(this.myAru + 1L)).keySet();
            Iterator<Long> nonMissing = received.iterator();
            holeLowerBound = this.myAru;
            if (Trace.trace) {
                Trace.debug("TOTAL_TOKEN.updateTokenRtR()", "retransmission request prior" + retransmissionList);
            }
            while (nonMissing.hasNext()) {
                Long seq = nonMissing.next();
                holeUpperBound = seq;
                while (holeLowerBound < holeUpperBound) {
                    missingSequence = new Long(++holeLowerBound);
                    retransmissionList.add(missingSequence);
                }
                holeLowerBound = holeUpperBound;
            }
            holeUpperBound = token.getHighestSequence();
            while (holeLowerBound < holeUpperBound) {
                missingSequence = new Long(++holeLowerBound);
                retransmissionList.add(missingSequence);
            }
            if (Trace.trace) {
                Trace.debug("TOTAL_TOKEN.updateTokenRtR()", "retransmission request after" + retransmissionList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int broadcastMessages(int allowedCount, RingToken token) {
        ArrayList sendList = null;
        List list = this.newMessagesQueue;
        synchronized (list) {
            int queueSize = this.newMessagesQueue.size();
            if (queueSize <= 0) {
                return 0;
            }
            if (queueSize > allowedCount) {
                sendList = new ArrayList(this.newMessagesQueue.subList(0, allowedCount));
                this.newMessagesQueue.removeAll(sendList);
            } else {
                sendList = new ArrayList();
                sendList.addAll(this.newMessagesQueue);
                this.newMessagesQueue.clear();
            }
        }
        long tokenSeq = token.getHighestSequence();
        Iterator iterator = sendList.iterator();
        while (iterator.hasNext()) {
            Message m = (Message)iterator.next();
            m.setSrc(this.localAddress);
            m.setDest(null);
            m.putHeader(this.getName(), new TotalTokenHeader(++tokenSeq));
            this.receivedMessagesQueue.put(new Long(tokenSeq), m);
            this.passDown(new Event(1, m));
        }
        if (token.getHighestSequence() == token.getAllReceivedUpto()) {
            token.setAllReceivedUpto(tokenSeq);
        }
        token.setHighestSequence(tokenSeq);
        return sendList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tokenReceived(RingToken token) {
        if (Trace.trace) {
            Trace.info("TOTAL_TOKEN.tokenReceived()", token.toString());
            Trace.debug("TOTAL_TOKEN.tokenReceived()", this.getState());
        }
        this.flowControl.setBacklog(this.newMessagesQueue.size());
        this.flowControl.updateWindow(token);
        this.blockSenderIfRequired();
        this.unBlockSenderIfAcceptable();
        long tokensAru = 0L;
        int broadcastCount = 0;
        int rebroadcastCount = 0;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.tokenSeen) {
                long lastRoundAru = token.getHighestSequence() - (long)token.getLastRoundBroadcastCount();
                if (this.myAru < token.getAllReceivedUpto()) {
                    this.myAru = lastRoundAru;
                }
                this.tokenSeen = true;
            }
            if (token.getType() == RingToken.RECOVERY) {
                this.highestSeenSeq = token.getHighestSequence();
                if (this.highestSeenSeq == this.myAru) {
                    if (Trace.trace) {
                        Trace.info("TOTAL_TOKEN.tokenReceived()", "member node recovered");
                    }
                    token.addRecoveredMember(this.localAddress);
                }
            }
            this.updateTokenRtR(token);
            int allowedToBroadcast = this.flowControl.getAllowedToBroadcast(token);
            rebroadcastCount = this.rebroadcastMessages(token);
            allowedToBroadcast -= rebroadcastCount;
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.tokenReceived()", "myAllReceivedUpto" + this.myAru);
                Trace.info("TOTAL_TOKEN.tokenReceived()", "allowedToBroadcast" + allowedToBroadcast);
                Trace.info("TOTAL_TOKEN.tokenReceived()", "newMessagesQueue.size()" + this.newMessagesQueue.size());
            }
            if (this.myAru < (tokensAru = token.getAllReceivedUpto()) || this.localAddress.equals(token.getAruId()) || token.getAruId() == null) {
                token.setAllReceivedUpto(this.myAru);
                if (token.getAllReceivedUpto() == token.getHighestSequence()) {
                    token.setAruId(null);
                } else {
                    token.setAruId(this.localAddress);
                }
            }
            if (allowedToBroadcast > 0 && token.getType() == RingToken.OPERATIONAL) {
                broadcastCount = this.broadcastMessages(allowedToBroadcast, token);
            }
            if (tokensAru > this.lastRoundTokensAru) {
                this.removeStableMessages(this.receivedMessagesQueue, this.lastRoundTokensAru);
            }
        }
        Util.sleep(this.sleepTime);
        token.incrementTokenSequence();
        token.addLastRoundBroadcastCount(broadcastCount - this.lastRoundTransmitCount);
        token.addBacklog(this.flowControl.getBacklogDifference());
        this.flowControl.setPreviousBacklog();
        this.lastRoundTransmitCount = broadcastCount;
        this.lastRoundRebroadcastCount = rebroadcastCount;
        this.lastRoundTokensAru = tokensAru;
    }

    private int rebroadcastMessages(RingToken token) {
        Collection rbl;
        int rebroadCastCount = 0;
        Collection rexmitRequests = token.getRetransmissionRequests();
        if (rexmitRequests.size() > 0 && (rebroadCastCount = (rbl = this.getRebroadcastList(rexmitRequests)).size()) > 0) {
            if (Trace.trace) {
                Trace.info("TOTAL_TOKEN.tokenReceived()", "rebroadcasting " + rbl);
            }
            Long s = null;
            Iterator iterator = rbl.iterator();
            while (iterator.hasNext()) {
                s = (Long)iterator.next();
                Message m = (Message)this.receivedMessagesQueue.get(s);
                this.passDown(new Event(1, m));
            }
        }
        return rebroadCastCount;
    }

    private void invalidateOnTokenloss() {
        this.lastRoundTransmitCount = 0;
        this.flowControl.invalidate();
    }

    private void blockSenderIfRequired() {
        if (!this.senderBlocked && this.flowControl.getBacklog() > this.blockSendingBacklogThreshold) {
            this.passUp(new Event(54));
            this.senderBlocked = true;
        }
    }

    private void unBlockSenderIfAcceptable() {
        if (this.senderBlocked && this.flowControl.getBacklog() < this.unblockSendingBacklogThreshold) {
            this.passUp(new Event(55));
            this.senderBlocked = false;
        }
    }

    private void removeStableMessages(TreeMap m, long upToSeq) {
        if (m.size() > 0) {
            long first = (Long)m.firstKey();
            if (first > upToSeq) {
                upToSeq = first;
            }
            if (Trace.trace) {
                Trace.debug("TOTAL_TOKEN.tokenReceived()", "cutting queue first key " + m.firstKey() + " cut at " + upToSeq + " last key " + m.lastKey());
            }
            SortedMap stable = m.headMap(new Long(upToSeq));
            stable.clear();
        }
    }

    private Collection getRebroadcastList(Collection rtr) {
        ArrayList rebroadcastList = new ArrayList(rtr);
        rebroadcastList.retainAll(this.receivedMessagesQueue.keySet());
        rtr.removeAll(rebroadcastList);
        Collections.sort(rebroadcastList);
        return rebroadcastList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TokenTransmitter
    extends Thread {
        long rtt = 0L;
        long timer;
        double srtt = 1000.0;
        double a = 0.09;
        int timeoutFactor = 10;
        volatile boolean running = false;

        private TokenTransmitter() {
            super("TokenTransmitter");
            this.resetTimeout();
            this.running = true;
        }

        private void shutDown() {
            this.running = false;
        }

        private void recalculateTimeout() {
            long now = System.currentTimeMillis();
            if (this.timer > 0L) {
                this.rtt = now - this.timer;
                this.srtt = (1.0 - this.a) * this.srtt + this.a * (double)this.rtt;
            }
        }

        private double getTimeout() {
            return this.srtt * (double)this.timeoutFactor;
        }

        private void resetTimeout() {
            this.timer = System.currentTimeMillis();
        }

        private boolean isRecoveryCompleted(RingToken token) {
            return TOTAL_TOKEN.this.liveMembersInRecovery.equals(token.getRecoveredMembers());
        }

        public void run() {
            while (this.running) {
                RingToken token = null;
                int timeout = 0;
                if (TOTAL_TOKEN.this.node == null) {
                    Util.sleep(500L);
                    continue;
                }
                try {
                    timeout = (int)this.getTimeout();
                    if (Trace.trace) {
                        Trace.info("TOTAL_TOKEN.receiveToken()", "timeout(ms)=" + timeout);
                    }
                    if ((token = (RingToken)TOTAL_TOKEN.this.node.receiveToken(timeout)).getType() == RingToken.OPERATIONAL && TOTAL_TOKEN.this.state == RECOVERY_STATE) {
                        TOTAL_TOKEN.this.state = OPERATIONAL_STATE;
                    }
                    TOTAL_TOKEN.this.tokenReceived(token);
                    this.recalculateTimeout();
                    if (token.getType() == RingToken.RECOVERY && this.isRecoveryCompleted(token)) {
                        if (Trace.trace) {
                            Trace.info("TOTAL_TOKEN.receiveToken()", "all members recovered, injecting operational token");
                        }
                        token.setType(RingToken.OPERATIONAL);
                    }
                    TOTAL_TOKEN.this.node.passToken(token);
                    this.resetTimeout();
                }
                catch (TokenLostException tle) {
                    TOTAL_TOKEN.this.invalidateOnTokenloss();
                    TOTAL_TOKEN.this.state = RECOVERY_STATE;
                    TOTAL_TOKEN.this.recover();
                }
            }
        }
    }

    public static class RingTokenHeader
    extends Header {
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public long size() {
            return 110L;
        }
    }

    public static class TotalTokenHeader
    extends Header {
        private long seq;

        public TotalTokenHeader() {
        }

        public TotalTokenHeader(long seq) {
            this.seq = seq;
        }

        public TotalTokenHeader(Long seq) {
            this.seq = seq;
        }

        public long getSeq() {
            return this.seq;
        }

        public long size() {
            return 121L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.seq);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.seq = in.readLong();
        }

        public String toString() {
            return "[TotalTokenHeader=" + this.seq + "]";
        }
    }
}

