/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    Vector initial_mbrs = new Vector();
    Object view_installation_mutex = new Object();
    Promise join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        this.gms = g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Address mbr) {
        Address coord = null;
        JoinRsp rsp = null;
        Digest tmp_digest = null;
        this.join_promise.reset();
        while (true) {
            this.findInitialMembers();
            if (Trace.trace) {
                Trace.debug("ClientGmsImpl.join()", "initial_mbrs are " + this.initial_mbrs);
            }
            if (this.initial_mbrs.size() == 0) {
                if (this.gms.disable_initial_coord) {
                    if (!Trace.trace) continue;
                    Trace.info("ClientGmsImpl.join()", "received an initial membership of 0, but cannot become coordinator (disable_initial_coord=" + this.gms.disable_initial_coord + "), will retry fetching the initial membership");
                    continue;
                }
                if (Trace.trace) {
                    Trace.info("ClientGmsImpl.join()", "no initial members discovered: creating group as first member");
                }
                this.becomeSingletonMember(mbr);
                return;
            }
            coord = this.determineCoord(this.initial_mbrs);
            if (coord == null) {
                Trace.error("ClientGmsImpl.join()", "could not determine coordinator from responses " + this.initial_mbrs);
                continue;
            }
            try {
                if (Trace.trace) {
                    Trace.info("ClientGmsImpl.join()", "sending handleJoin(" + mbr + ") to " + coord);
                }
                this.sendJoinMessage(coord, mbr);
                Promise promise = this.join_promise;
                synchronized (promise) {
                    rsp = (JoinRsp)this.join_promise.getResult(this.gms.join_timeout);
                }
                if (rsp == null) {
                    if (Trace.trace) {
                        Trace.warn("ClientGmsImpl.join()", "handleJoin(" + mbr + ") failed, retrying");
                    }
                } else {
                    tmp_digest = rsp.getDigest();
                    if (tmp_digest != null) {
                        tmp_digest.incrementHighSeqno(coord);
                        if (Trace.trace) {
                            Trace.info("ClientGmsImpl.join()", "digest is " + tmp_digest);
                        }
                        this.gms.setDigest(tmp_digest);
                    } else {
                        Trace.error("ClientGmsImpl.join()", "digest of JOIN response is null");
                    }
                    if (Trace.trace) {
                        Trace.debug("ClientGmsImpl.join()", "[" + this.gms.local_addr + "]: JoinRsp=" + rsp.getView() + " [size=" + rsp.getView().size() + "]\n\n");
                    }
                    if (rsp.getView() != null) {
                        if (!this.installView(rsp.getView())) {
                            if (!Trace.trace) continue;
                            Trace.error("ClientGmsImpl.join()", "view installation failed, retrying to join group");
                            continue;
                        }
                        this.gms.passUp(new Event(16));
                        this.gms.passDown(new Event(16));
                        return;
                    }
                    Trace.error("ClientGmsImpl.join()", "view of JOIN response is null");
                }
            }
            catch (Exception e) {
                Trace.info("ClientGmsImpl.join()", "exception=" + e.toString() + ", retrying");
            }
            Util.sleep(this.gms.join_retry_timeout);
        }
    }

    public void leave(Address mbr) {
        this.wrongMethod("leave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJoinResponse(JoinRsp join_rsp) {
        Promise promise = this.join_promise;
        synchronized (promise) {
            this.join_promise.setResult(join_rsp);
        }
    }

    public void handleLeaveResponse() {
        this.wrongMethod("handleLeaveResponse");
    }

    public void suspect(Address mbr) {
        this.wrongMethod("suspect");
    }

    public void unsuspect(Address mbr) {
        this.wrongMethod("unsuspect");
    }

    public JoinRsp handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return null;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    public synchronized void handleViewChange(View new_view, Digest digest) {
        if (Trace.trace) {
            Trace.debug("ClientGmsImpl.handleViewChange()", "view " + new_view.getMembers() + " is discarded as we are not a participant");
        }
    }

    private boolean installView(View new_view) {
        Vector mems = new_view.getMembers();
        if (Trace.trace) {
            Trace.info("ClientGmsImpl.installView()", "new_view=" + new_view);
        }
        if (this.gms.local_addr == null || mems == null || !mems.contains(this.gms.local_addr)) {
            Trace.error("ClientGmsImpl.installView()", "I (" + this.gms.local_addr + ") am not member of " + mems + ", will not install view");
            return false;
        }
        this.gms.installView(new_view);
        this.gms.becomeParticipant();
        this.gms.passUp(new Event(16));
        this.gms.passDown(new Event(16));
        return true;
    }

    public void handleSuspect(Address mbr) {
        this.wrongMethod("handleSuspect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 13: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (tmp != null && tmp.size() > 0) {
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.initial_mbrs.addElement(tmp.elementAt(i));
                        }
                    }
                    this.initial_mbrs.notify();
                }
                return false;
            }
        }
        return true;
    }

    void sendJoinMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(1, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.removeAllElements();
            this.gms.passDown(new Event(12));
            try {
                this.initial_mbrs.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                PingRsp ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr == null || this.gms.local_addr == null || !ping_rsp.own_addr.equals(this.gms.local_addr)) continue;
                this.initial_mbrs.removeElementAt(i);
                break;
            }
        }
    }

    Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>();
        for (int i = 0; i < mbrs.size(); ++i) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (mbr.coord_addr == null) continue;
            if (!votes.containsKey(mbr.coord_addr)) {
                votes.put(mbr.coord_addr, new Integer(1));
                continue;
            }
            count = (Integer)votes.get(mbr.coord_addr);
            votes.put(mbr.coord_addr, new Integer(count + 1));
        }
        if (Trace.trace) {
            if (votes.size() > 1) {
                Trace.warn("ClientGmsImpl.determineCoord()", "there was more than 1 candidate for coordinator: " + votes);
            } else {
                Trace.info("ClientGmsImpl.determineCoord()", "election results: " + votes);
            }
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        ViewId view_id = null;
        Vector<Address> mbrs = new Vector<Address>();
        Digest initial_digest = new Digest(1);
        initial_digest.add(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        view_id = new ViewId(mbr);
        mbrs.addElement(mbr);
        this.gms.installView(new View(view_id, mbrs));
        this.gms.becomeCoordinator();
        this.gms.passUp(new Event(16));
        this.gms.passDown(new Event(16));
        if (Trace.trace) {
            Trace.info("ClientGmsImpl.becomeSingletonMember()", "created group (first member). My view is " + this.gms.view_id + ", impl is " + this.gms.getImpl().getClass().getName());
        }
    }
}

