/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class IpAddressTest
extends TestCase {
    IpAddress a;
    IpAddress b;
    IpAddress c;
    IpAddress d;
    IpAddress e;
    IpAddress f;
    IpAddress g;
    IpAddress h;
    IpAddress i;
    IpAddress j;
    IpAddress k;
    static /* synthetic */ Class class$org$jgroups$tests$IpAddressTest;

    public IpAddressTest(String name) {
        super(name);
    }

    public void setUp() {
        this.a = new IpAddress("localhost", 5555);
        this.c = this.b = new IpAddress("localhost", 5555);
        this.d = new IpAddress("localhost", 5556);
        this.e = new IpAddress("127.0.0.1", 5555);
        this.f = new IpAddress("www.ibm.com", 80);
        this.g = new IpAddress("www.ibm.com", 8080);
        this.h = new IpAddress("224.0.0.1", 5555);
    }

    public void tearDown() {
    }

    public void testEquality() throws Exception {
        IpAddressTest.assertTrue((boolean)this.a.equals(this.b));
        IpAddressTest.assertTrue((boolean)this.c.equals(this.b));
        IpAddressTest.assertTrue((boolean)this.a.equals(this.e));
        IpAddressTest.assertTrue((boolean)this.c.equals(this.e));
    }

    public void testInequality() throws Exception {
        IpAddressTest.assertTrue((!this.a.equals(this.d) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.c.equals(this.d) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.a.equals(this.f) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.e.equals(this.f) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.f.equals(this.g) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.a.equals(null) ? 1 : 0) != 0);
    }

    public void testSameHost() throws Exception {
        IpAddressTest.assertTrue((boolean)Util.sameHost(this.a, this.b));
        IpAddressTest.assertTrue((boolean)Util.sameHost(this.a, this.c));
        IpAddressTest.assertTrue((boolean)Util.sameHost(this.a, this.d));
        IpAddressTest.assertTrue((boolean)Util.sameHost(this.a, this.e));
        IpAddressTest.assertTrue((boolean)Util.sameHost(this.f, this.g));
    }

    public void testNotSameHost() throws Exception {
        IpAddressTest.assertTrue((!Util.sameHost(this.a, this.f) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!Util.sameHost(this.e, this.f) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!Util.sameHost(this.e, null) ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!Util.sameHost(null, null) ? 1 : 0) != 0);
    }

    public void testMcast() {
        IpAddressTest.assertTrue((boolean)this.h.isMulticastAddress());
        IpAddressTest.assertTrue((!this.a.isMulticastAddress() ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.e.isMulticastAddress() ? 1 : 0) != 0);
        IpAddressTest.assertTrue((!this.g.isMulticastAddress() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        IpAddressTest.assertTrue((this.a.compareTo(this.b) == 0 ? 1 : 0) != 0);
        IpAddressTest.assertTrue((this.a.compareTo(this.d) < 0 ? 1 : 0) != 0);
        IpAddressTest.assertTrue((this.d.compareTo(this.a) > 0 ? 1 : 0) != 0);
    }

    public void testExternalization() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        this.a.setAdditionalData(null);
        this.b.setAdditionalData("Bela Ban".getBytes());
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        IpAddress a2 = (IpAddress)ois.readObject();
        IpAddress b2 = (IpAddress)ois.readObject();
        IpAddressTest.assertTrue((boolean)this.a.equals(a2));
        IpAddressTest.assertTrue((boolean)this.b.equals(b2));
        IpAddressTest.assertTrue((a2.getAdditionalData() == null ? 1 : 0) != 0);
        IpAddressTest.assertTrue((boolean)new String(b2.getAdditionalData()).equals("Bela Ban"));
    }

    public void testExternalizationAdditionalData() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        oos.writeObject(this.c);
        oos.writeObject(this.d);
        oos.writeObject(this.e);
        oos.writeObject(this.f);
        oos.writeObject(this.g);
        oos.writeObject(this.h);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        IpAddress a2 = (IpAddress)ois.readObject();
        IpAddress b2 = (IpAddress)ois.readObject();
        IpAddress c2 = (IpAddress)ois.readObject();
        IpAddress d2 = (IpAddress)ois.readObject();
        IpAddress e2 = (IpAddress)ois.readObject();
        IpAddress f2 = (IpAddress)ois.readObject();
        IpAddress g2 = (IpAddress)ois.readObject();
        IpAddress h2 = (IpAddress)ois.readObject();
        IpAddressTest.assertTrue((boolean)b2.equals(c2));
        IpAddressTest.assertTrue((boolean)this.a.equals(a2));
        IpAddressTest.assertTrue((boolean)this.b.equals(b2));
        IpAddressTest.assertTrue((boolean)this.c.equals(c2));
        IpAddressTest.assertTrue((boolean)this.d.equals(d2));
        IpAddressTest.assertTrue((boolean)this.e.equals(e2));
        IpAddressTest.assertTrue((boolean)this.f.equals(f2));
        IpAddressTest.assertTrue((boolean)this.g.equals(g2));
        IpAddressTest.assertTrue((boolean)this.h.equals(h2));
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$IpAddressTest == null ? (class$org$jgroups$tests$IpAddressTest = IpAddressTest.class$("org.jgroups.tests.IpAddressTest")) : class$org$jgroups$tests$IpAddressTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)IpAddressTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

