/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class McastReceiverTest {
    public static void main(String[] args) {
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        byte[] buf = null;
        int port = 5555;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if (tmp.equals("-help")) {
                    McastReceiverTest.help();
                    return;
                }
                if (tmp.equals("-bind_addr")) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if (tmp.equals("-mcast_addr")) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if (tmp.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                McastReceiverTest.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock = new MulticastSocket(port);
            if (bind_addr != null) {
                sock.setInterface(bind_addr);
            }
            sock.joinGroup(mcast_addr);
            System.out.println("Socket=" + sock.getLocalAddress() + ":" + sock.getLocalPort() + ", bind interface=" + sock.getInterface());
            while (true) {
                buf = new byte[256];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                sock.receive(packet);
                byte[] recv_buf = packet.getData();
                System.out.println(new String(recv_buf) + " [sender=" + packet.getAddress().getHostAddress() + ":" + packet.getPort() + "]");
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <port for multicast socket>]");
    }
}

