/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RspCollector;
import org.jgroups.debug.Debugger;
import org.jgroups.log.Trace;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcherTestAsync
implements RequestHandler {
    Channel channel;
    MessageDispatcher disp;
    RspList rsp_list;
    MyCollector coll = new MyCollector();
    Debugger debugger = null;
    boolean debug = false;
    boolean cummulative = false;
    boolean done_submitted = true;
    static final int NUM = 10;
    String props = "UDP(loopback=true;mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=10000;max_interval=20000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";

    public MessageDispatcherTestAsync(boolean debug, boolean cummulative) {
        this.debug = debug;
        this.cummulative = cummulative;
    }

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        if (this.debug) {
            this.debugger = new Debugger((JChannel)this.channel, this.cummulative);
            this.debugger.start();
        }
        this.disp = new MessageDispatcher(this.channel, null, null, this);
        this.channel.connect("MessageDispatcherTestAsyncGroup");
    }

    public void mcast(int num) {
        if (!this.done_submitted) {
            System.err.println("Must submit 'done' (press 'd') before mcasting new message");
            return;
        }
        for (int i = 0; i < num; ++i) {
            Util.sleep(100L);
            System.out.println("Casting message #" + i);
            this.disp.castMessage(null, i, new Message(null, null, (Serializable)((Object)("Number #" + i))), this.coll);
        }
        this.done_submitted = false;
    }

    public void disconnect() {
        System.out.println("** Disconnecting channel");
        this.channel.disconnect();
        System.out.println("** Disconnecting channel -- done");
        System.out.println("** Closing channel");
        this.channel.close();
        System.out.println("** Closing channel -- done");
        System.out.println("** disp.stop()");
        this.disp.stop();
        System.out.println("** disp.stop() -- done");
    }

    public void done() {
        for (int i = 0; i < 10; ++i) {
            this.disp.done(i);
        }
        this.done_submitted = true;
    }

    public Object handle(Message msg) {
        System.out.println("** handle(" + msg.getObject() + ")");
        return new String(msg.getObject() + ": success");
    }

    public static void main(String[] args) {
        MessageDispatcherTestAsync test = null;
        boolean debug = false;
        boolean cummulative = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                MessageDispatcherTestAsync.help();
                return;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (!args[i].equals("-cummulative")) continue;
            cummulative = true;
        }
        Trace.init();
        try {
            test = new MessageDispatcherTestAsync(debug, cummulative);
            test.start();
            block8: while (true) {
                System.out.println("[m=mcast 10 msgs x=exit]");
                int c = System.in.read();
                switch (c) {
                    case 120: {
                        test.disconnect();
                        System.exit(0);
                        return;
                    }
                    case 109: {
                        test.mcast(10);
                        continue block8;
                    }
                    case 100: {
                        test.done();
                        continue block8;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void help() {
        System.out.println("MessageDispatcherTestAsync [-debug] [-cummulative]");
    }

    class MyCollector
    implements RspCollector {
        MyCollector() {
        }

        public void receiveResponse(Message msg) {
            System.out.println("** received response " + msg.getObject() + " [sender=" + msg.getSrc() + "]");
        }

        public void suspect(Address mbr) {
            System.out.println("** suspected member " + mbr);
        }

        public void viewChange(View new_view) {
            System.out.println("** received new view " + new_view);
        }
    }
}

