/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class QueueTest
extends TestCase {
    private Queue queue = null;
    static /* synthetic */ Class class$org$jgroups$tests$QueueTest;

    public QueueTest(String Name_) {
        super(Name_);
    }

    public void setUp() {
        this.queue = new Queue();
    }

    public void tearDown() {
        if (this.queue != null) {
            this.queue.reset();
            this.queue = null;
        }
    }

    public void testQueue() {
        try {
            this.queue.add("Q1");
            this.queue.add("Q2");
            this.queue.add("Q3");
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.remove());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.remove());
            this.queue.addAtHead("Q4");
            this.queue.add("Q5");
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.remove());
            this.queue.close(true);
            try {
                this.queue.add("Q6");
                QueueTest.assertTrue((boolean)false);
            }
            catch (QueueClosedException qc) {
                QueueTest.assertTrue((boolean)true);
            }
            int size = this.queue.size();
            this.queue.removeElement("Q5");
            QueueTest.assertTrue((size - 1 == this.queue.size() ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.remove());
            QueueTest.assertTrue((boolean)this.queue.closed());
            System.out.println("Everything is ok");
        }
        catch (Exception x) {
            System.out.println(x);
            QueueTest.assertTrue((boolean)false);
        }
    }

    public void testLargeInsertion() {
        String element = "MyElement";
        try {
            System.out.println("Inserting 100000 elements");
            long start = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                this.queue.add(element);
            }
            long stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
            System.out.println("Removing 100000 elements");
            start = System.currentTimeMillis();
            while (this.queue.size() > 0) {
                this.queue.remove();
            }
            stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
        }
        catch (Exception ex) {
            System.err.println(ex);
            QueueTest.assertTrue((boolean)false);
        }
    }

    public void testEmptyQueue() {
        QueueTest.assertNull((Object)this.queue.getFirst());
        QueueTest.assertNull((Object)this.queue.getLast());
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
    }

    public void testInsertionAndRemoval() throws Exception {
        String s1 = "Q1";
        String s2 = "Q2";
        this.queue.add(s1);
        QueueTest.assertTrue((this.queue.getFirst() != null ? 1 : 0) != 0);
        QueueTest.assertTrue((this.queue.getLast() != null ? 1 : 0) != 0);
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.add(s2);
        QueueTest.assertTrue((this.queue.getFirst() != this.queue.getLast() ? 1 : 0) != 0);
        Object o1 = this.queue.peek();
        Object o2 = this.queue.getFirst();
        System.out.println("o1=" + o1 + ", o2=" + o2 + ", o1 == o2=" + o1 == o2 + ", o1.equals(o2)=" + o1.equals(o2));
        QueueTest.assertEquals((Object)this.queue.peek(), (Object)this.queue.getFirst());
        this.queue.remove();
        QueueTest.assertTrue((this.queue.size() == 1 ? 1 : 0) != 0);
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.remove();
        QueueTest.assertTrue((this.queue.size() == 0 ? 1 : 0) != 0);
        QueueTest.assertTrue((this.queue.getFirst() == null ? 1 : 0) != 0);
        QueueTest.assertTrue((this.queue.getLast() == null ? 1 : 0) != 0);
    }

    public void testRemoveElementNoElement() {
        String s1 = "Q1";
        try {
            this.queue.removeElement(s1);
            QueueTest.assertTrue((!this.queue.closed() ? 1 : 0) != 0);
            QueueTest.assertTrue((this.queue.size() == 0 ? 1 : 0) != 0);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementOneElement() {
        String s1 = "Q1";
        try {
            this.queue.add(s1);
            this.queue.removeElement(s1);
            QueueTest.assertTrue((this.queue.size() == 0 ? 1 : 0) != 0);
            QueueTest.assertTrue((this.queue.getFirst() == null ? 1 : 0) != 0);
            QueueTest.assertTrue((this.queue.getLast() == null ? 1 : 0) != 0);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s1);
            QueueTest.assertTrue((this.queue.size() == 1 ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s2);
            QueueTest.assertTrue((this.queue.size() == 1 ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s1);
            QueueTest.assertTrue((this.queue.size() == 2 ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s2);
            QueueTest.assertTrue((this.queue.size() == 2 ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsThirdFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s3);
            QueueTest.assertTrue((this.queue.size() == 2 ? 1 : 0) != 0);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveAndClose() {
        try {
            new Thread(){

                public void run() {
                    Util.sleep(1000L);
                    QueueTest.this.queue.close(true);
                }
            }.start();
            this.queue.remove();
            QueueTest.fail((String)"we should not be able to remove an object from a closed queue");
        }
        catch (QueueClosedException ex) {
            QueueTest.assertTrue((boolean)(ex instanceof QueueClosedException));
        }
    }

    public void testBarrier() {
        RemoveOneItem[] removers = new RemoveOneItem[10];
        int num_dead = 0;
        for (int i = 0; i < removers.length; ++i) {
            removers[i] = new RemoveOneItem(i);
            removers[i].start();
        }
        Util.sleep(1000L);
        System.out.println("-- adding element 99");
        try {
            this.queue.add(new Long(99L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(5000L);
        System.out.println("-- adding element 100");
        try {
            this.queue.add(new Long(100L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(1000L);
        for (int i = 0; i < removers.length; ++i) {
            System.out.println("remover #" + i + " is " + (removers[i].isAlive() ? "alive" : "terminated"));
            if (removers[i].isAlive()) continue;
            ++num_dead;
        }
        QueueTest.assertEquals((int)num_dead, (int)2);
    }

    public void testConcurrentAccess() {
        int i;
        int NUM_THREADS = 10;
        int INTERVAL = 20000;
        Writer[] writers = new Writer[10];
        Reader[] readers = new Reader[10];
        int[] writes = new int[10];
        int[] reads = new int[10];
        long total_reads = 0L;
        long total_writes = 0L;
        for (i = 0; i < writers.length; ++i) {
            readers[i] = new Reader(i, reads);
            readers[i].start();
            writers[i] = new Writer(i, writes);
            writers[i].start();
        }
        Util.sleep(20000L);
        System.out.println("current queue size=" + this.queue.size());
        for (i = 0; i < writers.length; ++i) {
            writers[i].stopThread();
        }
        for (i = 0; i < readers.length; ++i) {
            readers[i].stopThread();
        }
        this.queue.close(false);
        System.out.println("current queue size=" + this.queue.size());
        for (i = 0; i < writers.length; ++i) {
            try {
                writers[i].join(300L);
                readers[i].join(300L);
                continue;
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        for (i = 0; i < writes.length; ++i) {
            System.out.println("Thread #" + i + ": " + writes[i] + " writes, " + reads[i] + " reads");
            total_writes += (long)writes[i];
            total_reads += (long)reads[i];
        }
        System.out.println("total writes=" + total_writes + ", total_reads=" + total_reads + ", diff=" + Math.abs(total_writes - total_reads));
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$jgroups$tests$QueueTest == null ? (class$org$jgroups$tests$QueueTest = QueueTest.class$("org.jgroups.tests.QueueTest")) : class$org$jgroups$tests$QueueTest).getName()};
        TestRunner.main((String[])testCaseName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Reader
    extends Thread {
        int rank;
        int num_reads = 0;
        int[] reads = null;
        boolean running = true;

        Reader(int i, int[] reads) {
            super("ReaderThread");
            this.rank = i;
            this.reads = reads;
            this.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                try {
                    Long el = (Long)QueueTest.this.queue.remove();
                    if (el == null) {
                        System.out.println("QueueTest.Reader.run(): peek() returned null element. queue.size()=" + QueueTest.this.queue.size() + ", queue.closed()=" + QueueTest.this.queue.closed());
                    }
                    Assert.assertNotNull((Object)el);
                    ++this.num_reads;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Reader.run(): exception=" + t);
                }
            }
            this.reads[this.rank] = this.num_reads;
        }

        void stopThread() {
            this.running = false;
        }
    }

    class Writer
    extends Thread {
        int rank = 0;
        int num_writes = 0;
        boolean running = true;
        int[] writes = null;

        Writer(int i, int[] writes) {
            super("WriterThread");
            this.rank = i;
            this.writes = writes;
            this.setDaemon(true);
        }

        public void run() {
            while (this.running) {
                try {
                    QueueTest.this.queue.add(new Long(System.currentTimeMillis()));
                    ++this.num_writes;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Writer.run(): exception=" + t);
                }
            }
            this.writes[this.rank] = this.num_writes;
        }

        void stopThread() {
            this.running = false;
        }
    }

    class RemoveOneItem
    extends Thread {
        Long retval = null;
        int rank = 0;

        RemoveOneItem(int rank) {
            super("RemoveOneItem thread #" + rank);
            this.rank = rank;
            this.setDaemon(true);
        }

        public void run() {
            try {
                this.retval = (Long)QueueTest.this.queue.remove();
                System.out.println("Thread #" + this.rank + " removed element (" + this.retval + ")");
            }
            catch (QueueClosedException closed) {
                System.err.println("Thread #" + this.rank + ": queue was closed");
            }
        }

        Long getRetval() {
            return this.retval;
        }
    }
}

