/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue;
import java.util.LinkedList;

public class QueueTest2 {
    MyWaitFreeQueue q = new MyWaitFreeQueue();
    long start;
    long stop;
    long NUM = 1000000L;

    void start() throws Exception {
        this.start = System.currentTimeMillis();
        Adder adder = new Adder();
        Remover remover = new Remover();
        remover.start();
        adder.start();
        adder.join();
        remover.join();
        System.out.println("== total time for " + this.NUM + " elements: " + (this.stop - this.start) + " msecs");
    }

    public static void main(String[] args) {
        try {
            new QueueTest2().start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class MyWaitFreeQueue
    extends WaitFreeQueue {
        public void add(Object o) {
            try {
                super.put(o);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public Object remove() {
            try {
                return super.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class MyLinkedQueue
    extends LinkedQueue {
        public void add(Object o) {
            try {
                super.put(o);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public Object remove() {
            try {
                return super.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class MyQueue
    extends LinkedList {
        Object mutex = new Object();
        boolean waiting = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                boolean retval = super.add(o);
                if (this.waiting) {
                    this.mutex.notifyAll();
                }
                return retval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove() {
            Object object = this.mutex;
            synchronized (object) {
                Object e;
                if (this.size() > 0) {
                    return this.removeFirst();
                }
                this.waiting = true;
                try {
                    this.mutex.wait();
                    e = this.removeFirst();
                    this.waiting = false;
                }
                catch (InterruptedException e2) {
                    Object var3_4;
                    try {
                        e2.printStackTrace();
                        var3_4 = null;
                        this.waiting = false;
                    }
                    catch (Throwable throwable) {
                        this.waiting = false;
                        throw throwable;
                    }
                    return var3_4;
                }
                return e;
            }
        }
    }

    class Remover
    extends Thread {
        int i = 0;

        Remover() {
        }

        public void run() {
            do {
                try {
                    QueueTest2.this.q.remove();
                    ++this.i;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while ((long)this.i < QueueTest2.this.NUM);
            QueueTest2.this.stop = System.currentTimeMillis();
            System.out.println("-- Remover: done");
        }
    }

    class Adder
    extends Thread {
        Adder() {
        }

        public void run() {
            int i = 0;
            while ((long)i < QueueTest2.this.NUM) {
                try {
                    QueueTest2.this.q.add(new Integer(i));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            System.out.println("-- Adder: done");
        }
    }
}

