/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.log.Trace;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherBlocking
implements MembershipListener {
    RpcDispatcher disp;
    Channel channel;
    long timeout = 30000L;
    String props = null;
    int i = 0;

    public RpcDispatcherBlocking(String props, long timeout) {
        this.props = props;
        this.timeout = timeout;
    }

    public void print(int i) throws Exception {
        System.out.println("<-- " + i + " [sleeping for " + this.timeout + " msecs");
        Util.sleep(this.timeout);
    }

    public void viewAccepted(View new_view) {
        System.out.println("new view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
        System.out.println(suspected_mbr + " is suspected");
    }

    public void block() {
    }

    public void start() throws Exception {
        this.channel = new JChannel(null);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
        this.channel.connect("rpc-test");
        while (true) {
            System.out.println("[x]: exit [s]: send sync group RPC");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case 120: {
                    this.channel.close();
                    this.disp.stop();
                    return;
                }
                case 115: {
                    RspList rsps = this.sendGroupRpc();
                    System.out.println("responses:\n" + rsps);
                }
            }
            System.in.skip(System.in.available());
        }
    }

    RspList sendGroupRpc() throws Exception {
        return this.disp.callRemoteMethods(null, "print", new Integer(this.i++), 2, 0L);
    }

    public static void main(String[] args) {
        long timeout = 30000L;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            RpcDispatcherBlocking.help();
            return;
        }
        Trace.init();
        try {
            new RpcDispatcherBlocking(props, timeout).start();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherBlocking [-help] [-props <properties>] [-timeout <timeout>]");
    }
}

