/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.IpAddress;

public class UnicastChannelTest {
    boolean server = false;
    String host = "localhost";
    int port = 0;
    String props = null;
    JChannel ch;

    public void start(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if (tmp.equals("-server")) {
                this.server = true;
                continue;
            }
            if (tmp.equals("-props")) {
                this.props = args[++i];
                continue;
            }
            if (tmp.equals("-host")) {
                this.host = args[++i];
                continue;
            }
            if (tmp.equals("-port")) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            this.help();
            return;
        }
        Trace.init();
        if (this.server) {
            this.runServer();
        } else {
            this.runClient();
        }
    }

    void runClient() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.connect(null);
        IpAddress addr = new IpAddress(this.host, this.port);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            System.out.print("> ");
            String line = reader.readLine();
            if (line.startsWith("quit") || line.startsWith("exit")) {
                this.ch.close();
                return;
            }
            Message msg = new Message((Address)addr, null, (Serializable)((Object)line));
            this.ch.send(msg);
            while (true) {
                Object obj;
                if ((obj = this.ch.peek(1000L)) == null || (obj = this.ch.receive(1000L)) == null) continue block0;
                if (!(obj instanceof Message)) {
                    System.out.println("<-- " + obj);
                    continue;
                }
                System.out.println("<-- " + ((Message)obj).getObject());
            }
            break;
        }
    }

    void runServer() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.connect(null);
        System.out.println("server started at " + new Date() + ", listening on " + this.ch.getLocalAddress());
        while (true) {
            Object obj;
            if (!((obj = this.ch.receive(0L)) instanceof Message)) {
                System.out.println(obj);
                continue;
            }
            Message msg = (Message)obj;
            System.out.println("-- " + msg.getObject());
            Message rsp = new Message(msg.getSrc(), null, (Serializable)((Object)("ack for " + msg.getObject())));
            this.ch.send(rsp);
        }
    }

    void help() {
        System.out.println("UnicastChannelTest [-help] [-server] [-props <props>][-host <host>] [-port <port>]");
    }

    public static void main(String[] args) {
        try {
            new UnicastChannelTest().start(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

