/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.log.Trace;
import org.jgroups.util.ReusableThread;

public class ThreadPool {
    int MAX_NUM = 255;
    int current_index = 0;
    ReusableThread[] pool = null;
    boolean[] available_threads = null;

    public ThreadPool(int max_num) {
        this.MAX_NUM = max_num;
        this.pool = new ReusableThread[this.MAX_NUM];
        this.available_threads = new boolean[this.MAX_NUM];
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = null;
            this.available_threads[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReusableThread getThread() {
        ReusableThread retval = null;
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            for (int i = 0; i < this.current_index; ++i) {
                ReusableThread tmp = this.pool[i];
                if (!tmp.available()) continue;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return tmp;
            }
            if (this.current_index >= this.MAX_NUM) {
                Trace.error("ThreadPool.getThread()", "could not create new thread because pool's max size reached (" + this.MAX_NUM + ") !");
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return null;
            }
            retval = new ReusableThread();
            this.pool[this.current_index++] = retval;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return retval;
        }
    }

    public void destroy() {
        this.deletePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            ret.append("ThreadPool: capacity=" + this.pool.length + ", index=" + this.current_index + "\n");
            ret.append("Threads are:\n");
            for (int i = 0; i < this.current_index; ++i) {
                ret.append("[" + i + ": " + this.pool[i] + "]\n");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deletePool() {
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (this.pool) {
            for (int i = 0; i < this.MAX_NUM; ++i) {
                ReusableThread t = this.pool[i];
                if (t == null) continue;
                t.stop();
                this.pool[i] = null;
            }
            this.current_index = 0;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }
}

