/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine;

import com.funambol.framework.core.Add;
import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.ContentTypeInfo;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.DataStore;
import com.funambol.framework.core.Delete;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.ModificationCommand;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.SyncCap;
import com.funambol.framework.core.SyncType;
import com.funambol.framework.engine.SyncConflict;
import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemImpl;
import com.funambol.framework.engine.SyncItemKey;
import com.funambol.framework.engine.SyncItemMapping;
import com.funambol.framework.engine.SyncOperation;
import com.funambol.framework.engine.SyncOperationStatus;
import com.funambol.framework.engine.SyncProperty;
import com.funambol.framework.engine.source.ContentType;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.engine.source.SyncSourceException;
import com.funambol.framework.engine.source.SyncSourceInfo;
import com.funambol.framework.server.ClientMapping;
import com.funambol.framework.server.error.MappingException;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.server.engine.StatusKey;
import com.funambol.server.engine.Sync4jOperationStatus;
import com.funambol.server.engine.SyncItemHelper;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class EngineHelper {
    public static Logger log = Logger.getLogger((String)EngineHelper.class.getName());

    public static Status[] generateStatusCommands(SyncOperationStatus[] operationStatus, String msgId, CommandIdGenerator idGenerator) {
        HashMap statusMap = new HashMap();
        ArrayList itemList = null;
        StatusKey key2 = null;
        ModificationCommand cmd = null;
        for (int i = 0; i < operationStatus.length; ++i) {
            cmd = ((Sync4jOperationStatus)operationStatus[i]).getCmd();
            if (cmd == null || cmd.isNoResp()) continue;
            key2 = new StatusKey(cmd, operationStatus[i].getStatusCode());
            itemList = (ArrayList)statusMap.get(key2);
            if (itemList == null) {
                itemList = new ArrayList();
                statusMap.put(key2, itemList);
            }
            SyncItemKey keyA = operationStatus[i].getOperation().getSyncItemA().getKey();
            SyncItemKey mapKeyA = operationStatus[i].getOperation().getSyncItemA().getMappedKey();
            itemList.add(mapKeyA == null ? keyA : mapKeyA);
        }
        ArrayList<Status> ret = new ArrayList<Status>();
        Item[] items = null;
        for (StatusKey key2 : statusMap.keySet()) {
            itemList = (ArrayList)statusMap.get(key2);
            items = new Item[itemList.size()];
            for (int j = 0; j < items.length; ++j) {
                items[j] = new Item(null, new Source(((SyncItemKey)itemList.get(j)).getKeyAsString()), null, null, false);
            }
            ret.add(new Status(idGenerator.next(), msgId, key2.cmd.getCmdID().getCmdID(), key2.cmd.getName(), null, items.length == 1 ? new SourceRef(items[0].getSource()) : null, null, null, new Data((long)key2.statusCode), items.length > 1 ? items : new Item[]{}));
        }
        return ret.toArray(new Status[ret.size()]);
    }

    public static ItemizedCommand[] operationsToCommands(ClientMapping clientMapping, SyncOperation[] operations, String sourceName, CommandIdGenerator idGenerator) {
        ArrayList<ItemizedCommand> commands = new ArrayList<ItemizedCommand>();
        SyncItem item = null;
        for (int i = 0; operations != null && i < operations.length; ++i) {
            char op;
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("Converting the operation\n" + operations[i] + "\nfor the source " + sourceName));
            }
            item = operations[i].getSyncItemB();
            if (!operations[i].isAOperation() || item == null || (op = operations[i].getOperation()) == '-') continue;
            commands.add(EngineHelper.operationToCommand(clientMapping, operations[i], idGenerator));
        }
        return commands.toArray(new ItemizedCommand[0]);
    }

    public static ItemizedCommand operationToCommand(ClientMapping clientMapping, SyncOperation operation, CommandIdGenerator idGenerator) {
        Delete cmd = null;
        if (idGenerator == null) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)"idGenerator is null. Cannot continue");
            }
            throw new NullPointerException("idGenerator cannot be null!");
        }
        char op = operation.getOperation();
        String itemKey = operation.getSyncItemB().getKey().getKeyAsString();
        if (op != 'N' && op != 'O') {
            itemKey = clientMapping.getMappedValueForGuid(itemKey);
        }
        assert (itemKey != null);
        Meta m = null;
        if (op == 'N') {
            m = new Meta();
            m.setType(operation.getSyncItemB().getSyncSource().getType());
            cmd = new Add(idGenerator.next(), false, null, m, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), false, true, true)});
        } else if (op == 'D') {
            cmd = new Delete(idGenerator.next(), false, false, false, null, null, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), true, false, false)});
        } else if (op == 'U') {
            m = new Meta();
            m.setType(operation.getSyncItemB().getSyncSource().getType());
            cmd = new Replace(idGenerator.next(), false, null, m, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), true, false, true)});
        } else if (op == 'O') {
            if (operation.getSyncItemB().getSyncSource() != null) {
                m = new Meta();
                m.setType(operation.getSyncItemB().getSyncSource().getType());
            }
            if (operation.getSyncItemB().getState() == 'X') {
                itemKey = operation.getSyncItemA().getKey().getKeyAsString();
            }
            char s = operation.getSyncItemB().getState();
            switch (s) {
                case 'S': 
                case 'U': {
                    cmd = new Replace(idGenerator.next(), false, null, m, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), true, false, true)});
                    break;
                }
                case 'D': 
                case 'X': {
                    cmd = new Delete(idGenerator.next(), false, false, false, null, null, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), true, false, false)});
                    break;
                }
                case 'N': {
                    cmd = new Add(idGenerator.next(), false, null, m, new Item[]{SyncItemHelper.toItem(itemKey, operation.getSyncItemA(), false, true, true)});
                }
            }
        }
        return cmd;
    }

    public static SyncItem[] itemsToSyncItems(ClientMapping clientMapping, SyncSource syncSource, ModificationCommand cmd, char state, long timestamp) {
        Item[] items = cmd.getItems().toArray(new Item[0]);
        if (items == null || items.length == 0) {
            return new SyncItem[0];
        }
        SyncItem[] syncItems = new SyncItem[items.length];
        ComplexData d = null;
        String content = null;
        String key = null;
        String mappedKey = null;
        for (int i = 0; i < items.length; ++i) {
            d = items[i].getData();
            content = d != null ? d.getData() : "";
            key = items[i].getSource().getLocURI();
            mappedKey = clientMapping.getMappedValueForLuid(key);
            if (mappedKey != null) {
                String k = mappedKey;
                mappedKey = key;
                key = k;
            }
            syncItems[i] = new SyncItemImpl(syncSource, (Object)key, (Object)mappedKey, state);
            syncItems[i].setProperty(new SyncProperty("SYNCML_COMMAND", (Object)cmd));
            syncItems[i].setProperty(new SyncProperty("BINARY_CONTENT", (Object)content.getBytes()));
            syncItems[i].setProperty(new SyncProperty("TIMESTAMP", (Object)new Timestamp(timestamp)));
        }
        return syncItems;
    }

    public static List<Object> intersect(List<Object> a, List<Object> b) {
        int n = 0;
        Object var3_3 = null;
        ArrayList<Object> ret = new ArrayList<Object>();
        SyncItemMapping mapping = null;
        for (SyncItem syncItem : a) {
            n = b.indexOf(syncItem);
            if (n < 0) continue;
            mapping = new SyncItemMapping((Object)syncItem.getKey());
            mapping.setMapping(syncItem, (SyncItem)b.get(n));
            ret.add(mapping);
        }
        return ret;
    }

    public static List<Object> buildAmBBm(List<Object> items, SyncSource source, Principal principal) {
        SyncItemMapping mapping = null;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (SyncItem syncItem : items) {
            try {
                SyncItem itemB = source.getSyncItemFromId(principal, syncItem.getKey());
                if (itemB == null) continue;
                itemB.setState('S');
                mapping = new SyncItemMapping((Object)syncItem.getKey());
                mapping.setMapping(syncItem, itemB);
                ret.add(mapping);
            }
            catch (SyncSourceException e) {
                String msg = "Error retrieving an item by its key " + syncItem.getKey() + " from source " + source + ": " + e.getMessage();
                if (log.isEnabled(Logger.Level.FATAL)) {
                    log.fatal((Object)msg);
                }
                log.debug((Object)"buildAmBBm", (Throwable)e);
            }
        }
        return ret;
    }

    public static List<Object> buildAAmBm(List<Object> items, SyncSource source, Principal principal) {
        SyncItemMapping mapping = null;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (SyncItem syncItem : items) {
            try {
                SyncItem itemA = source.getSyncItemFromId(principal, syncItem.getKey());
                if (itemA == null) continue;
                itemA.setState('S');
                mapping = new SyncItemMapping((Object)syncItem.getKey());
                mapping.setMapping(itemA, syncItem);
                ret.add(mapping);
            }
            catch (SyncSourceException e) {
                String msg = "Error retrieving an item by its key " + syncItem.getKey() + " from source " + source + ": " + e.getMessage();
                if (log.isEnabled(Logger.Level.FATAL)) {
                    log.fatal((Object)msg);
                }
                log.debug((Object)"buildAmBBm", (Throwable)e);
            }
        }
        return ret;
    }

    public static void updateClientMappings(Map<String, ClientMapping> clientMappings, SyncOperation[] operations, boolean slowSync) throws MappingException {
        ClientMapping clientMapping = null;
        String guid = null;
        String luid = null;
        SyncSource clientSource = null;
        for (int i = 0; operations != null && i < operations.length; ++i) {
            if (operations[i] instanceof SyncConflict || (clientSource = operations[i].getSyncItemA().getSyncSource()) == null) continue;
            clientMapping = clientMappings.get(clientSource.getSourceURI());
            if (slowSync && operations[i].getOperation() != 'D') {
                if (operations[i].getSyncItemA() == null || operations[i].getSyncItemB() == null) continue;
                guid = operations[i].getSyncItemB().getKey().getKeyAsString();
                SyncItemKey sikA = operations[i].getSyncItemA().getMappedKey();
                luid = sikA != null ? sikA.getKeyAsString() : operations[i].getSyncItemA().getKey().getKeyAsString();
                clientMapping.updateMapping(luid, guid);
                continue;
            }
            if (operations[i].getOperation() == 'D') {
                guid = operations[i].getSyncItemB().getKey().getKeyAsString();
                clientMapping.removeMappedValuesForGuid(guid);
                continue;
            }
            if (operations[i].getSyncItemA().getState() != 'D' || operations[i].getSyncItemB().getState() != 'D') continue;
            guid = operations[i].getSyncItemB().getKey().getKeyAsString();
            clientMapping.removeMappedValuesForGuid(guid);
        }
    }

    public static void updateServerMappings(Map<String, ClientMapping> clientMappings, SyncOperationStatus[] status, boolean slowSync) throws MappingException {
        ClientMapping clientMapping = null;
        String luid = null;
        String guid = null;
        SyncSource serverSource = null;
        for (int i = 0; status != null && i < status.length; ++i) {
            SyncOperation operation = status[i].getOperation();
            char op = operation.getOperation();
            if (operation instanceof SyncConflict || (serverSource = status[i].getSyncSource()) == null) continue;
            clientMapping = clientMappings.get(serverSource.getSourceURI());
            if (slowSync && operation.getOperation() != 'D' && operation.getOperation() != 'N') {
                if (operation.getSyncItemA() == null || operation.getSyncItemB() == null) continue;
                guid = operation.getSyncItemB().getKey().getKeyAsString();
                SyncItemKey sikA = operation.getSyncItemA().getMappedKey();
                luid = sikA != null ? sikA.getKeyAsString() : operation.getSyncItemA().getKey().getKeyAsString();
                clientMapping.updateMapping(luid, guid);
                continue;
            }
            if (op == 'D') {
                guid = operation.getSyncItemB().getKey().getKeyAsString();
                clientMapping.removeMappedValuesForGuid(guid);
                continue;
            }
            if (op == 'N') {
                if (!operation.isBOperation()) continue;
                luid = operation.getSyncItemA().getKey().getKeyAsString();
                guid = operation.getSyncItemB().getKey().getKeyAsString();
                clientMapping.updateMapping(luid, guid);
                continue;
            }
            if (operation.getSyncItemA().getState() != 'D' || operation.getSyncItemB().getState() != 'D') continue;
            guid = operation.getSyncItemB().getKey().getKeyAsString();
            clientMapping.removeMappedValuesForGuid(guid);
        }
    }

    public static DataStore toDataStore(String uri, SyncSourceInfo info) {
        ContentTypeInfo[] supportedContents = null;
        ContentTypeInfo preferredContent = null;
        if (info != null) {
            ContentType[] supportedTypes = info.getSupportedTypes();
            ContentType preferredType = info.getPreferredType();
            supportedContents = new ContentTypeInfo[supportedTypes.length];
            for (int i = 0; i < supportedTypes.length; ++i) {
                supportedContents[i] = new ContentTypeInfo(supportedTypes[i].type, supportedTypes[i].version);
            }
            preferredContent = new ContentTypeInfo(preferredType.type, preferredType.version);
        }
        return new DataStore(new SourceRef(uri), null, 32L, preferredContent, supportedContents, preferredContent, supportedContents, null, new SyncCap(SyncType.ALL_SYNC_TYPES));
    }

    public static void resetState(Collection<SyncItem> items) {
        if (items == null) {
            return;
        }
        for (SyncItem obj : items) {
            if (obj == null) continue;
            obj.setState('S');
        }
    }
}

