/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine.dm;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.core.dm.bootstrap.BasicAccountInfo;
import com.funambol.framework.core.dm.bootstrap.BootStrap;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.security.Officer;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.SyncUser;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.LogicalClause;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.server.store.WhereClause;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.MD5;
import com.funambol.framework.tools.SecurityTools;
import com.funambol.server.admin.DBUserManager;
import com.funambol.server.engine.Sync4jEngine;
import com.funambol.server.notification.NotificationEngineImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;

public class ManagementEngine
extends Sync4jEngine {
    private static final int DEFAULT_ADDRESS_TYPE = 1;
    private static final int DEFAULT_PORT_NUMBER = 80;
    public static final String SYNCML_DM_BOOTSTRAP_MESSAGE = "com/funambol/server/engine/dm/SyncMLDMbootstrapMessage.xml";
    private static final String NS_MSSID = "mssid";
    private static final String OPERATION_AFTER_BOOTSTRAP = "GetDeviceDetails";
    private Configuration config = null;
    private static final Logger log = Logger.getLogger((String)ManagementEngine.class.getName());
    private DBUserManager dbUserManager = null;
    private Officer officer = null;

    private ManagementEngine() {
    }

    public ManagementEngine(Configuration config) {
        super(config);
        this.config = config;
        this.dbUserManager = (DBUserManager)config.getBeanInstance("user.manager");
        this.officer = (Officer)config.getBeanInstance("security.officer");
    }

    public void bootstrap(BootStrap bootstrap) throws NotificationException {
        this.bootstrap(new BootStrap[]{bootstrap});
    }

    public void bootstrap(BootStrap[] bootstraps) throws NotificationException {
        if (bootstraps == null) {
            throw new NotificationException("Unable to start the bootstrap process. The given BootStrap[] is null");
        }
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Starting bootstrap process in ManagementEngine for " + bootstraps.length + " devices"));
        }
        int numBootStraps = bootstraps.length;
        for (int i = 0; i < numBootStraps; ++i) {
            if (bootstraps[i] == null) {
                throw new NotificationException("Error checking the given boostrap objects. The bootstrap n. " + i + " is null");
            }
            try {
                this.verifyBootStrap(bootstraps[i]);
                continue;
            }
            catch (Exception e) {
                throw new NotificationException("Error checking the boostrap n. " + i + " (" + e.getMessage() + ")", (Throwable)e);
            }
        }
        BasicAccountInfo[] basicAccountsInfo = new BasicAccountInfo[numBootStraps];
        for (int i = 0; i < numBootStraps; ++i) {
            if (log.isEnabled(Logger.Level.INFO)) {
                log.info((Object)("Start bootstrap process in ManagementEngine with: " + bootstraps[i]));
            }
            basicAccountsInfo[i] = this.preBootstrapOperation(bootstraps[i]);
        }
        NotificationEngineImpl notificationEngine = new NotificationEngineImpl(this.config);
        notificationEngine.bootstrap(basicAccountsInfo, bootstraps);
    }

    public void sendNotification(int messageType, int transportType, String phoneNumber, String operation, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Executing sendNotification with: \n\tmessageType: " + messageType + "\n\ttransportType: " + transportType + "\n\tphoneNumber: " + phoneNumber + "\n\toperation: " + operation + "\n\tinfo: " + info));
        }
        int sessionId = this.getNextNotificationSessionIds(1)[0];
        String serverId = this.config.getStringValue("server.id");
        Sync4jDevice device = this.getSync4jDevice(phoneNumber);
        if (device == null) {
            throw new NotificationException("Device with phone number '" + phoneNumber + "' not found");
        }
        String serverPassword = device.getServerPassword();
        byte[] serverNonce = device.getServerNonce();
        NotificationEngineImpl notificationEngine = new NotificationEngineImpl(this.config);
        notificationEngine.sendNotificationMessage(messageType, transportType, sessionId, phoneNumber, info, serverId, serverPassword, serverNonce);
        DeviceDMState dms = new DeviceDMState();
        dms.mssid = String.valueOf(sessionId);
        dms.state = (byte)78;
        dms.start = new Date(System.currentTimeMillis());
        dms.operation = operation;
        dms.info = info;
        dms.deviceId = device.getDeviceId();
        this.storeDeviceDMState(dms);
    }

    public void sendNotification(int messageType, int transportType, String[] phoneNumbers, String operation, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Executing sendNotification to " + phoneNumbers.length + " devices with: " + "\n\tmessageType: " + messageType + "\n\ttransportType: " + transportType + "\n\toperation: " + operation + "\n\tinfo: " + info));
        }
        int numDevices = phoneNumbers.length;
        int[] sessionIds = this.getNextNotificationSessionIds(numDevices);
        String serverId = this.config.getStringValue("server.id");
        Sync4jDevice device = null;
        DeviceDMState dms = null;
        String[] serverPasswords = new String[numDevices];
        byte[][] serverNonces = new byte[numDevices][];
        for (int i = 0; i < numDevices; ++i) {
            device = this.getSync4jDevice(phoneNumbers[i]);
            if (device == null) {
                throw new NotificationException("Device with phone number '" + phoneNumbers[i] + "' not found");
            }
            serverPasswords[i] = device.getServerPassword();
            serverNonces[i] = device.getServerNonce();
            dms = new DeviceDMState();
            dms.mssid = String.valueOf(sessionIds[i]);
            dms.state = (byte)78;
            dms.start = new Date(System.currentTimeMillis());
            dms.operation = operation;
            dms.info = info + ":" + phoneNumbers[i];
            dms.deviceId = device.getDeviceId();
            this.storeDeviceDMState(dms);
        }
        NotificationEngineImpl notificationEngine = new NotificationEngineImpl(this.config);
        notificationEngine.sendNotificationMessages(messageType, transportType, sessionIds, phoneNumbers, info, serverId, serverPasswords, serverNonces);
    }

    public void storeDeviceDMState(DeviceDMState d) {
        try {
            this.getStore().store((Object)d);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error storing the device DM state " + d.toString() + ": " + e.getMessage()));
            }
            log.debug((Object)"storeDeviceDMState", (Throwable)e);
        }
    }

    public void readDeviceDMState(DeviceDMState d) throws NotFoundException {
        WhereClause where = new WhereClause("device", new String[]{d.deviceId}, "EQ", true);
        try {
            DeviceDMState[] rows = (DeviceDMState[])this.getStore().read((Object)d, (Clause)where);
            if (rows.length == 0) {
                throw new NotFoundException("No device DM state found with deviceId " + d.deviceId);
            }
            d.copyFrom(rows[0]);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error reading the device DM state " + d.toString() + ": " + e.getMessage()));
            }
            log.debug((Object)"readDeviceDMState", (Throwable)e);
        }
    }

    public void deleteDeviceDMState(DeviceDMState d) {
        try {
            this.getStore().delete((Object)d);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error deleting the device DM state " + d.toString() + ": " + e.getMessage()));
            }
            log.debug((Object)"deleteDeviceDMState", (Throwable)e);
        }
    }

    public boolean resolveDMState(DeviceDMState dms, Sync4jDevice deviceConnected) {
        DeviceDMState[] rows;
        WhereClause wc1 = new WhereClause("state", new String[]{String.valueOf('N')}, "EQ", true);
        WhereClause wc2 = new WhereClause(NS_MSSID, new String[]{dms.mssid}, "EQ", true);
        LogicalClause select = new LogicalClause("AND", new Clause[]{wc1, wc2});
        dms.state = (byte)78;
        try {
            rows = (DeviceDMState[])this.getStore().read((Object)dms, (Clause)select);
            if (rows.length > 0) {
                String deviceConnectedId = dms.deviceId;
                dms.copyFrom(rows[0]);
                if (!dms.deviceId.equalsIgnoreCase(deviceConnectedId)) {
                    Sync4jDevice deviceNotified = new Sync4jDevice(dms.deviceId);
                    this.store.read((Object)deviceNotified);
                    this.store.read((Object)deviceConnected);
                    String descriptionDeviceNotified = deviceNotified.getDescription();
                    String descriptionDeviceConnected = deviceConnected.getDescription();
                    deviceNotified.setDescription(descriptionDeviceConnected);
                    deviceConnected.setDescription(descriptionDeviceNotified);
                    this.store.store((Object)deviceNotified);
                    this.store.store((Object)deviceConnected);
                }
                dms.deviceId = deviceConnectedId;
                return true;
            }
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error reading the device DM state " + dms.toString() + ": " + e.getMessage()));
            }
            log.debug((Object)"resolveDMState", (Throwable)e);
            return false;
        }
        wc1 = new WhereClause("state", new String[]{String.valueOf('P')}, "EQ", true);
        wc2 = new WhereClause("device", new String[]{dms.deviceId}, "EQ", true);
        select = new LogicalClause("AND", new Clause[]{wc1, wc2});
        try {
            rows = (DeviceDMState[])this.getStore().read((Object)dms, (Clause)select);
            if (rows.length > 0) {
                dms.copyFrom(rows[0]);
                return true;
            }
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error reading the device DM state " + dms.toString() + ": " + e.getMessage()));
            }
            log.debug((Object)"resolveDMState", (Throwable)e);
        }
        return false;
    }

    private Sync4jDevice createSync4jUserDevicePrincipal(String deviceId, String username, String password, String phoneNumber) throws PersistentStoreException {
        String userDigest = this.calculateDigest(username, password);
        Sync4jDevice device = new Sync4jDevice(deviceId);
        boolean deviceFound = false;
        try {
            this.readDevice(device);
            deviceFound = true;
        }
        catch (NotFoundException ex) {
            deviceFound = false;
        }
        if (!deviceFound) {
            Sync4jDevice[] devices = this.getSync4jDevices(phoneNumber);
            if (devices.length > 0) {
                for (int i = 0; i < devices.length; ++i) {
                    this.getStore().read((Object)devices[i]);
                    devices[i].setDescription("");
                    this.getStore().store((Object)devices[i]);
                }
            }
            SyncUser user = new SyncUser();
            user.setUsername(userDigest);
            user.setPassword(" ");
            user.setFirstname("");
            user.setLastname(phoneNumber);
            String[] role = new String[]{"sync_user"};
            user.setRoles(role);
            this.dbUserManager.insertUser(user);
            device = new Sync4jDevice();
            device.setDeviceId(deviceId);
            device.setType("phone");
            device.setDescription(phoneNumber);
            device.setDigest(userDigest);
            byte[] serverNonce = MD5.getNextNonce();
            byte[] clientNonce = MD5.getNextNonce();
            device.setServerNonce(serverNonce);
            device.setClientNonce(clientNonce);
            String serverPassword = SecurityTools.getRandomPassword();
            device.setServerPassword(serverPassword);
            this.storeDevice(device);
            Sync4jPrincipal principal = new Sync4jPrincipal(userDigest, deviceId);
            this.getStore().store((Object)principal);
            return device;
        }
        Sync4jDevice[] devices = this.getSync4jDevices(phoneNumber);
        if (devices.length == 1) {
            Sync4jDevice deviceA = null;
            Sync4jDevice deviceB = device;
            this.getStore().read((Object)devices[0]);
            deviceA = devices[0];
            deviceA.setDescription(deviceB.getDescription());
            this.getStore().store((Object)deviceA);
        } else if (devices.length > 1) {
            throw new IllegalStateException("There are more devices with phone number '" + phoneNumber + "' then the swap of this is not possible");
        }
        byte[] serverNonce = MD5.getNextNonce();
        byte[] clientNonce = MD5.getNextNonce();
        device.setServerNonce(serverNonce);
        device.setClientNonce(clientNonce);
        String serverPassword = SecurityTools.getRandomPassword();
        device.setServerPassword(serverPassword);
        device.setDescription(phoneNumber);
        this.storeDevice(device);
        String deviceDigest = device.getDigest();
        if (StringUtils.equals((String)deviceDigest, (String)userDigest)) {
            return device;
        }
        device.setDigest(userDigest);
        this.storeDevice(device);
        SyncUser user = new SyncUser();
        user.setUsername(userDigest);
        user.setPassword(" ");
        user.setFirstname("");
        user.setLastname(phoneNumber);
        String[] role = new String[]{"sync_user"};
        user.setRoles(role);
        this.dbUserManager.insertUser(user);
        Sync4jPrincipal principal = new Sync4jPrincipal(userDigest, deviceId);
        this.getStore().store((Object)principal);
        Sync4jPrincipal previousPrincipal = new Sync4jPrincipal(deviceDigest, deviceId);
        this.getStore().read((Object)previousPrincipal);
        this.getStore().delete((Object)previousPrincipal);
        WhereClause wc1 = new WhereClause("username", new String[]{deviceDigest}, "EQ", true);
        Sync4jPrincipal[] principals = (Sync4jPrincipal[])this.getStore().read((Object)principal, (Clause)wc1);
        if (principals.length == 0) {
            SyncUser previousUser = new SyncUser();
            previousUser.setUsername(deviceDigest);
            this.dbUserManager.deleteUser(previousUser);
        }
        return device;
    }

    private String calculateDigest(String username, String password) {
        String cred = username + ":" + password;
        byte[] md5 = null;
        md5 = MD5.digest((byte[])cred.getBytes());
        byte[] digest = Base64.encode((byte[])md5);
        return new String(digest);
    }

    private Sync4jDevice getSync4jDevice(String phoneNumber) throws NotificationException {
        WhereClause clause = new WhereClause("description", new String[]{phoneNumber}, "EQ", true);
        Sync4jDevice[] devices = null;
        try {
            devices = (Sync4jDevice[])this.getStore().read((Object)new Sync4jDevice(), (Clause)clause);
        }
        catch (PersistentStoreException e) {
            throw new NotificationException("Unable to get device information", (Throwable)e);
        }
        if (devices == null) {
            return null;
        }
        if (devices.length == 0) {
            throw new NotificationException("Device with phone number '" + phoneNumber + "' not found");
        }
        if (devices.length > 1) {
            throw new NotificationException("There are more devices with the same phone number [" + phoneNumber + "]");
        }
        try {
            this.readDevice(devices[0]);
        }
        catch (PersistentStoreException e) {
            throw new NotificationException("Unable to get device information", (Throwable)e);
        }
        return devices[0];
    }

    private Sync4jDevice[] getSync4jDevices(String phoneNumber) throws PersistentStoreException {
        WhereClause clause = new WhereClause("description", new String[]{phoneNumber}, "EQ", true);
        Sync4jDevice[] devices = null;
        devices = (Sync4jDevice[])this.getStore().read((Object)new Sync4jDevice(), (Clause)clause);
        return devices;
    }

    private BasicAccountInfo preBootstrapOperation(BootStrap bootstrap) throws NotificationException {
        Sync4jDevice device = null;
        try {
            device = this.createSync4jUserDevicePrincipal(bootstrap.getDeviceId(), bootstrap.getUsername(), bootstrap.getPassword(), bootstrap.getMsisdn());
        }
        catch (PersistentStoreException e) {
            log.debug((Object)"preBootstrapOperation", (Throwable)e);
            throw new NotificationException("Error creating the user/device/principal", (Throwable)e);
        }
        try {
            this.createDMStateToExecuteAfterBootstrap(bootstrap.getDeviceId(), bootstrap.getOperation(), bootstrap.getInfo());
        }
        catch (ManagementException e) {
            log.debug((Object)"preBootstrapOperation", (Throwable)e);
            throw new NotificationException("Error creating the dmstate", (Throwable)e);
        }
        byte[] serverNonce = device.getServerNonce();
        byte[] clientNonce = device.getClientNonce();
        String serverUri = this.config.getStringValue("server.uri");
        StringBuffer serverAddress = new StringBuffer();
        int serverPort = -1;
        URI uri = null;
        try {
            uri = new URI(serverUri);
            serverPort = uri.getPort();
            serverAddress.append(uri.getScheme()).append("://");
            serverAddress.append(uri.getHost()).append(uri.getPath());
            if (uri.getQuery() != null && uri.getQuery().length() != 0) {
                serverAddress.append('?').append(uri.getQuery());
            }
        }
        catch (URISyntaxException e) {
            throw new NotificationException("The server uri isn't a valid uri", (Throwable)e);
        }
        String serverId = this.config.getStringValue("server.id");
        String serverPassword = device.getServerPassword();
        BasicAccountInfo basicAccountInfo = new BasicAccountInfo(bootstrap.getDeviceId(), bootstrap.getAccountName(), serverAddress.toString(), serverPort, serverId, serverPassword, serverNonce, bootstrap.getUsername(), bootstrap.getPassword(), clientNonce, this.officer.getAuthType(), 1);
        return basicAccountInfo;
    }

    private synchronized int[] getNextNotificationSessionIds(int numOfSessionsId) throws NotificationException {
        int counter = 0;
        try {
            counter = this.getStore().readCounter(NS_MSSID, numOfSessionsId);
        }
        catch (PersistentStoreException ex) {
            throw new NotificationException("Error reading session ids");
        }
        int[] sessionIds = new int[numOfSessionsId];
        for (int i = 0; i < numOfSessionsId; ++i) {
            sessionIds[i] = counter + i & 0xFFFF;
        }
        return sessionIds;
    }

    private void verifyBootStrap(BootStrap bootstrap) throws NotificationException {
        if (bootstrap == null) {
            throw new NotificationException("Unable to send the bootstrap (is null)");
        }
        String imsi = bootstrap.getImsi();
        String userPin = bootstrap.getUserPin();
        int authMethod = bootstrap.getAuthMethod();
        String digest = bootstrap.getDigest();
        if (StringUtils.isNotEmpty((String)digest)) {
            return;
        }
        if (authMethod == 0) {
            if (StringUtils.isEmpty((String)imsi)) {
                throw new NotificationException("Imsi can't be null using NETWPIN authentication method");
            }
        } else if (authMethod == 1) {
            if (StringUtils.isEmpty((String)userPin) && StringUtils.isEmpty((String)imsi)) {
                throw new NotificationException("Userpin or imsi must be not null using USERPIN authentication method");
            }
        } else if (authMethod == 2) {
            if (StringUtils.isEmpty((String)imsi)) {
                throw new NotificationException("Imsi can't be null using USERNETWPIN authentication method");
            }
            if (StringUtils.isEmpty((String)userPin)) {
                throw new NotificationException("Userpin can't be null using USERNETWPIN authentication method");
            }
        }
    }

    private void createDMStateToExecuteAfterBootstrap(String deviceId, String operation, String info) throws ManagementException {
        this.deleteAllPendingSessions(deviceId);
        DeviceDMState dmState = new DeviceDMState();
        dmState.deviceId = deviceId;
        dmState.state = (byte)80;
        dmState.operation = StringUtils.isNotEmpty((String)operation) ? operation : OPERATION_AFTER_BOOTSTRAP;
        dmState.info = info;
        try {
            this.store.store((Object)dmState);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error storing the dm state to execute after the bootstrap: " + e.getMessage()));
            }
            log.debug((Object)"createDMStateToExecuteAfterBootstrap", (Throwable)e);
            throw new ManagementException("Error storing the dm state to execute after the bootstrap", (Throwable)e);
        }
    }

    private void deleteAllPendingSessions(String deviceId) throws ManagementException {
        WhereClause wc1 = new WhereClause("state", new String[]{String.valueOf('P')}, "EQ", true);
        WhereClause wc2 = new WhereClause("device", new String[]{deviceId}, "EQ", true);
        LogicalClause select = new LogicalClause("AND", new Clause[]{wc1, wc2});
        try {
            DeviceDMState[] rows = (DeviceDMState[])this.getStore().read((Object)new DeviceDMState(), (Clause)select);
            for (int i = 0; i < rows.length; ++i) {
                this.deleteDeviceDMState(rows[i]);
            }
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)("Error deleting the pending session for '" + deviceId + "': " + e.getMessage()));
            }
            log.debug((Object)"deleteAllPendingSessions", (Throwable)e);
            throw new ManagementException("Error deleting pending sessions", (Throwable)e);
        }
    }
}

