/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;
import org.vmguys.vmtools.utils.XPath;

public class ContentModifyOperation
extends AbstractOperation {
    private Object oldContent;
    private Object newContent;

    public ContentModifyOperation(DiffElement node, Object oldContent, Object newContent) {
        this(node, oldContent, newContent, null);
    }

    public ContentModifyOperation(DiffElement node, Object oldContent, Object newContent, String comment) {
        this.node = node;
        this.oldContent = oldContent;
        this.newContent = newContent;
        this.comment = comment;
    }

    public int cost() {
        return 1;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Content", namespace);
        el.setAttribute("Operation", "modify");
        el.setAttribute("Child", this.childNumber(this.oldContent));
        if (this.newContent instanceof String) {
            el.addContent((String)this.newContent);
        } else if (this.newContent instanceof Comment) {
            el.addContent((Comment)this.newContent);
        } else if (this.newContent instanceof EntityRef) {
            el.addContent((EntityRef)this.newContent);
        } else if (this.newContent instanceof ProcessingInstruction) {
            el.addContent((ProcessingInstruction)this.newContent);
        } else if (this.newContent instanceof CDATA) {
            el.addContent((CDATA)this.newContent);
        } else if (this.newContent instanceof Element) {
            el.addContent((Element)((Element)this.newContent).clone());
        } else {
            el.addContent(this.newContent.toString());
        }
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    private String childNumber(Object child) {
        int n = -1;
        Object[] c = this.node.getContentAsArray();
        int i = 0;
        while (n < 0 && i < c.length) {
            if (c[i] == child) {
                n = i + 1;
            }
            ++i;
        }
        return Integer.toString(n);
    }

    public String toString() {
        return "modify content " + this.oldContent + " to " + this.newContent + " in " + (Object)((Object)this.node);
    }

    public String getOperationXpath() throws JDOMException {
        return XPath.getXPath(this.node.getRoot(), this.node, this.oldContent);
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

