/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jibx.runtime.impl.XMLWriterBase;

public abstract class StreamWriterBase
extends XMLWriterBase {
    protected static final byte[] QUOT_ENTITY = new byte[]{38, 113, 117, 111, 116, 59};
    protected static final byte[] AMP_ENTITY = new byte[]{38, 97, 109, 112, 59};
    protected static final byte[] GT_ENTITY = new byte[]{38, 103, 116, 59};
    protected static final byte[] LT_ENTITY = new byte[]{38, 108, 116, 59};
    protected static final byte[] LT_CDATASTART = new byte[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    protected static final byte[] LT_CDATAEND = new byte[]{93, 93, 62};
    private static final int INITIAL_BUFFER_SIZE = 2048;
    private final String m_encodingName;
    private OutputStream m_stream;
    protected byte[] m_buffer;
    protected int m_fillOffset;
    protected byte[][] m_prefixBytes;
    protected byte[][][] m_extensionBytes;
    private boolean m_indent;
    private int m_indentBase;
    private int m_indentPerLevel;
    private byte[] m_indentSequence;

    public StreamWriterBase(String enc, String[] uris) {
        super(uris);
        this.m_encodingName = enc;
        this.m_prefixBytes = new byte[uris.length][];
        this.m_buffer = new byte[2048];
    }

    public void setOutput(OutputStream outs) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_stream = outs;
        this.reset();
    }

    public void setIndentSpaces(int count, String newline, char indent) {
        if (count >= 0) {
            try {
                if (newline == null) {
                    newline = "\n";
                }
                this.m_indent = true;
                byte[] base = newline.getBytes(this.m_encodingName);
                this.m_indentBase = base.length;
                byte[] per = new String(new char[]{indent}).getBytes(this.m_encodingName);
                this.m_indentPerLevel = count * per.length;
                int length = this.m_indentBase + this.m_indentPerLevel * 10;
                this.m_indentSequence = new byte[length];
                for (int i = 0; i < length; ++i) {
                    if (i < newline.length()) {
                        this.m_indentSequence[i] = base[i];
                        continue;
                    }
                    int index = (i - this.m_indentBase) % per.length;
                    this.m_indentSequence[i] = per[index];
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding " + this.m_encodingName + " not recognized by JVM");
            }
        } else {
            this.m_indent = false;
        }
    }

    protected void makeSpace(int length) throws IOException {
        if (this.m_fillOffset + length > this.m_buffer.length) {
            this.m_stream.write(this.m_buffer, 0, this.m_fillOffset);
            this.m_fillOffset = 0;
            if (length > this.m_buffer.length) {
                this.m_buffer = new byte[Math.max(length, this.m_buffer.length * 2)];
            }
        }
    }

    protected void undefineNamespace(int index) {
        if (index < this.m_prefixBytes.length) {
            this.m_prefixBytes[index] = null;
        } else if (this.m_extensionBytes != null) {
            index -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                int length = this.m_extensionBytes[i].length;
                if (index < length) {
                    this.m_extensionBytes[i][index] = null;
                    break;
                }
                index -= length;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writePrefix(int index) throws IOException {
        try {
            byte[] bytes = null;
            if (index < this.m_prefixBytes.length) {
                bytes = this.m_prefixBytes[index];
            } else if (this.m_extensionBytes != null) {
                index -= this.m_prefixes.length;
                for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                    int length = this.m_extensionBytes[i].length;
                    if (index < length) {
                        bytes = this.m_extensionBytes[i][index];
                        break;
                    }
                    index -= length;
                }
            }
            this.makeSpace(bytes.length);
            System.arraycopy(bytes, 0, this.m_buffer, this.m_fillOffset, bytes.length);
            this.m_fillOffset += bytes.length;
        }
        catch (NullPointerException ex) {
            throw new IOException("Namespace URI has not been declared.");
        }
    }

    protected int writeEntity(byte[] bytes, int offset) {
        System.arraycopy(bytes, 0, this.m_buffer, offset, bytes.length);
        return offset + bytes.length;
    }

    public void pushExtensionNamespaces(String[] uris) {
        super.pushExtensionNamespaces(uris);
        byte[][] items = new byte[uris.length][];
        if (this.m_extensionBytes == null) {
            this.m_extensionBytes = new byte[][][]{items};
        } else {
            int length = this.m_extensionBytes.length;
            byte[][][] grow = new byte[length + 1][][];
            System.arraycopy(this.m_extensionBytes, 0, grow, 0, length);
            grow[length] = items;
            this.m_extensionBytes = grow;
        }
    }

    public void popExtensionNamespaces() {
        super.popExtensionNamespaces();
        int length = this.m_extensionBytes.length;
        if (length == 1) {
            this.m_extensionBytes = null;
        } else {
            byte[][][] shrink = new byte[length - 1][][];
            System.arraycopy(this.m_extensionBytes, 0, shrink, 0, length - 1);
            this.m_extensionBytes = shrink;
        }
    }

    public void indent() throws IOException {
        if (this.m_indent) {
            int length = this.m_indentBase + this.m_nestingDepth * this.m_indentPerLevel;
            if (length > this.m_indentSequence.length) {
                int use = Math.max(length, this.m_indentSequence.length * 2 - this.m_indentBase);
                byte[] grow = new byte[use];
                System.arraycopy(this.m_indentSequence, 0, grow, 0, this.m_indentSequence.length);
                for (int i = this.m_indentSequence.length; i < use; ++i) {
                    grow[i] = grow[this.m_indentBase];
                }
                this.m_indentSequence = grow;
            }
            this.makeSpace(length);
            System.arraycopy(this.m_indentSequence, 0, this.m_buffer, this.m_fillOffset, length);
            this.m_fillOffset += length;
        }
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            this.indent();
            this.m_stream.write(this.m_buffer, 0, this.m_fillOffset);
            this.m_fillOffset = 0;
            this.m_stream.flush();
            this.m_stream.close();
            this.m_stream = null;
        }
    }

    public void reset() {
        super.reset();
        this.m_fillOffset = 0;
    }
}

