/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.logging;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class JDBCHandler
extends Handler {
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_LOGGER = "logger";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_METHOD = "method";
    public static final String PROPERTY_JDBC_DRIVER = "com.funambol.commons.logging.JDBCHandler.driver";
    public static final String PROPERTY_JDBC_URL = "com.funambol.commons.logging.JDBCHandler.url";
    public static final String PROPERTY_JDBC_USER = "com.funambol.commons.logging.JDBCHandler.user";
    public static final String PROPERTY_JDBC_PASSWORD = "com.funambol.commons.logging.JDBCHandler.password";
    public static final String PROPERTY_TABLE = "com.funambol.commons.logging.JDBCHandler.table";
    public static final String PROPERTY_FIELDS = "com.funambol.commons.logging.JDBCHandler.fields";
    private String driverString;
    private String connectionString;
    private String user;
    private String password;
    private String tableName;
    private String fields;
    private boolean logLevel = false;
    private boolean logLogger = false;
    private boolean logSourceClass = false;
    private boolean logSourceMethod = false;
    private Connection connection;
    private PreparedStatement prepInsert;
    private PreparedStatement prepClear;

    public JDBCHandler() {
        this.validateParameters();
        try {
            Class.forName(this.driverString);
            this.connection = DriverManager.getConnection(this.connectionString, this.user, this.password);
            this.prepInsert = this.connection.prepareStatement(this.getInsertSQL());
            this.prepClear = this.connection.prepareStatement(this.getClearSQL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publish(LogRecord record) {
        if (this.getFilter() != null && !this.getFilter().isLoggable(record)) {
            return;
        }
        try {
            int i = 1;
            this.prepInsert.setLong(i++, record.getSequenceNumber());
            this.prepInsert.setTimestamp(i++, new Timestamp(record.getMillis()));
            this.prepInsert.setInt(i++, record.getThreadID());
            if (this.logLevel) {
                this.prepInsert.setInt(i++, record.getLevel().intValue());
            }
            if (this.logLogger) {
                this.prepInsert.setString(i++, record.getLoggerName());
            }
            if (this.logSourceClass) {
                this.prepInsert.setString(i++, record.getSourceClassName());
            }
            if (this.logSourceMethod) {
                this.prepInsert.setString(i++, record.getSourceMethodName());
            }
            String[] values = this.parseMessage(record.getMessage());
            for (int j = 0; j < values.length; ++j) {
                this.prepInsert.setString(i++, values[j]);
            }
            this.prepInsert.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error on publishing: " + e);
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        try {
            this.prepClear.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
    }

    private String getInsertSQL() {
        StringBuffer s = new StringBuffer();
        s.append("insert into ").append(this.tableName).append(" (seq_number,ts,tid,").append(this.fields).append(") values(?,?,?");
        int n = new StringTokenizer(this.fields, ",").countTokens();
        for (int i = 0; i < n; ++i) {
            s.append(",?");
        }
        s.append(")");
        return s.toString();
    }

    private String getClearSQL() {
        return "delete from " + this.tableName;
    }

    private String[] parseMessage(String msg) {
        if (msg == null) {
            return new String[0];
        }
        return msg.split("\\t");
    }

    private void validateParameters() throws IllegalArgumentException {
        LogManager lm = LogManager.getLogManager();
        this.driverString = lm.getProperty(PROPERTY_JDBC_DRIVER);
        this.connectionString = lm.getProperty(PROPERTY_JDBC_URL);
        this.user = lm.getProperty(PROPERTY_JDBC_USER);
        this.password = lm.getProperty(PROPERTY_JDBC_PASSWORD);
        this.tableName = lm.getProperty(PROPERTY_TABLE);
        this.fields = lm.getProperty(PROPERTY_FIELDS);
        if (this.driverString == null || this.driverString.length() == 0) {
            throw new IllegalArgumentException("driverString cannot be empty");
        }
        if (this.connectionString == null || this.connectionString.length() == 0) {
            throw new IllegalArgumentException("connectionString cannot be empty");
        }
        if (this.tableName == null || this.tableName.length() == 0) {
            throw new IllegalArgumentException("tableName cannot be empty");
        }
        if (this.fields == null) {
            this.fields = "";
        }
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.logLevel = this.fields.indexOf(FIELD_LEVEL) >= 0;
        this.logLogger = this.fields.indexOf(FIELD_LOGGER) >= 0;
        this.logSourceClass = this.fields.indexOf(FIELD_SOURCE) >= 0;
        this.logSourceClass = this.fields.indexOf(FIELD_METHOD) >= 0;
    }
}

