/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.OperationNodeNumberComparator;

public class CostOps {
    private int cost;
    private List ops = new ArrayList();

    public CostOps() {
        this.cost = 0;
    }

    public CostOps(int cost) {
        this.cost = cost;
    }

    public CostOps(AbstractOperation op) {
        this.cost = op.cost();
        this.ops.add(op);
    }

    public CostOps(List ops) {
        this.ops = ops;
        this.cost = 0;
        Iterator it = ops.iterator();
        while (it.hasNext()) {
            AbstractOperation op = (AbstractOperation)it.next();
            this.cost += op.cost();
        }
    }

    public void add(CostOps other) {
        if (other != null) {
            this.cost += other.cost;
            this.ops.addAll(other.ops);
        }
    }

    public void add(AbstractOperation op) {
        if (op != null) {
            this.ops.add(op);
            this.cost += op.cost();
        }
    }

    public void add(int n) {
        this.cost += n;
    }

    public CostOps combine(CostOps other) {
        CostOps rslt = new CostOps();
        rslt.add(this);
        rslt.add(other);
        return rslt;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public List getOps() {
        return this.ops;
    }

    public String toString() {
        StringBuffer rslt = new StringBuffer("[");
        rslt.append(this.cost);
        Iterator it = this.ops.iterator();
        while (it.hasNext()) {
            AbstractOperation op = (AbstractOperation)it.next();
            rslt.append("; ").append(op.toString());
        }
        rslt.append("]");
        return rslt.toString();
    }

    public void sortOperations() {
        Collections.sort(this.ops, new OperationNodeNumberComparator());
    }
}

