/*
 * Funambol is a mobile platform developed by Funambol, Inc.
 * Copyright (C) 2011 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT  OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

package com.funambol.framework.core;

import java.util.ArrayList;
import java.util.Arrays;


/**
 * This class represents the &lt;Map&gt; tag as defined by the SyncML r
 * epresentation specifications.
 *
 *
 *
 * @version $Id: Map.java,v 1.3 2006/11/15 14:21:53 nichele Exp $
 *
 */
public final class Map
extends AbstractCommand
implements java.io.Serializable {

    // --------------------------------------------------------------- Constants

    public static String COMMAND_NAME = "Map";

    // ------------------------------------------------------------ Private data

    private Target    target;
    private Source    source;
    private ArrayList<MapItem> mapItems = new ArrayList<MapItem>();

    // ------------------------------------------------------------ Constructors

    /**
     * For serialization purposes
     */
    protected Map() {}

    /**
     * Creates a new Map commands from its constituent information.
     *
     * @param cmdID command identifier - NOT NULL
     * @param target the target - NOT NULL
     * @param source the source - NOT NULL
     * @param credential authentication credential - NULL ALLOWED
     * @param meta the associated meta data - NULL ALLOWED
     * @param mapItems the mapping items - NOT NULL
     *
     */
    public Map(final CmdID cmdID,
               final Target target,
               final Source source,
               final Cred credential,
               final Meta meta,
               final MapItem[] mapItems) {

        super(cmdID);
        setMeta(meta);
        setCred(credential);

        setTarget  (target  );
        setSource  (source  );
        setMapItems(mapItems);
    }

    // ---------------------------------------------------------- Public methods

    /**
     * Returns the target property
     * @return the target property
     *
     */
    public Target getTarget() {
        return target;
    }

    /**
     * Sets the target property
     *
     * @param target the target - NOT NULL
     *
     * @throws IllegalArgumentException if target is null
     */
    public void setTarget(Target target) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }

        this.target = target;
    }

    /**
     * Returns the source property
     * @return the source property
     *
     */
    public Source getSource() {
        return source;
    }

    /**
     * Sets the source property
     *
     * @param source the source - NOT NULL
     *
     * @throws IllegalArgumentException if source is null
     */
    public void setSource(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        this.source = source;
    }

    /**
     * Returns the map items
     *
     * @return the map items
     *
     */
    public ArrayList<MapItem> getMapItems() {
        return mapItems;
    }

    /**
     * Sets the mapItems property
     *
     * @param mapItems the map items - NOT NULL
     *
     * @throws IllegalArgumentException if mapItems is null
     */
    public void setMapItems(MapItem[] mapItems) {
        if (mapItems == null) {
            throw new IllegalArgumentException("mapItems cannot be null");
        }
        this.mapItems.clear();
        this.mapItems.addAll(Arrays.asList(mapItems));
    }

    /**
     * Returns the command name
     *
     * @return the command name
     */
    public String getName() {
        return Map.COMMAND_NAME;
    }
}
