/*
 * Funambol is a mobile platform developed by Funambol, Inc.
 * Copyright (C) 2011 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT  OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

package com.funambol.framework.core;


import java.util.ArrayList;
import java.util.Arrays;


/**
 * Thic class corresponds to the &lt;Sync&gt; command in the SyncML represent DTD
 *
 *
 *
 * @version $Id: Sync.java,v 1.2 2006/08/07 21:05:28 nichele Exp $
 */
public final class Sync
extends AbstractCommand
implements java.io.Serializable {

    // --------------------------------------------------------------- Constants
    public static String COMMAND_NAME = "Sync";

    // ------------------------------------------------------------ Private data
    private Target target;
    private Source source;
    private Meta meta;
    private ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
    private int numberOfChanges;

    // ------------------------------------------------------------ Constructors

    /** For serialization purposes */
    protected Sync(){}

    /**
     * Creates a new Sync object
     *
     * @param cmdID the command identifier - NOT NULL
     * @param noResp is <b>true</b> if no response is required
     * @param cred the authentication credential
     * @param target the target object
     * @param source the source object
     * @param meta the meta object
     * @param numberOfChanges the number of changes
     * @param commands an array of elements that must be of one of the
     *                 following types: {@link Add}, {@link Atomic},
     *                 {@link Copy}, {@link Delete}, {@link Replace},
     *                 {@link Sequence}
     *
     * @throws java.lang.IllegalArgumentException
     *
     */
    public Sync(final CmdID cmdID,
                final boolean noResp,
                final Cred cred,
                final Target target,
                final Source source,
                final Meta meta,
                final int numberOfChanges,
                final AbstractCommand[] commands) {
        super(cmdID);

        setCommands(commands);
        setCred(cred);
        setMeta(meta);

        this.noResp  = (noResp) ? Boolean.valueOf(noResp) : null;
        this.target = target;
        this.source = source;
        this.numberOfChanges  = numberOfChanges;
    }

    // ---------------------------------------------------------- Public methods

    /**
     * Gets the Target object property
     *
     * @return target the Target object property
     */
    public Target getTarget() {
        return target;
    }

    /**
     * Sets the Target object property
     *
     * @param target the Target object property
     *
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /**
     * Gets the Source object property
     *
     * @return source the Source object property
     */
    public Source getSource() {
        return source;
    }

    /**
     * Gets the Source object property
     *
     * @param source the Source object property
     */
    public void setSource(Source source) {
        this.source = source;
    }

    /**
     *
     * @return The return value is guaranteed to be non-null.
     *          The array elements are guaranteed to be non-null.
     *
     */
    public ArrayList<AbstractCommand> getCommands() {
        return this.commands;
    }

    /**
     * Sets the sequenced commands. The given commands must be of the allowed
     * types.
     *
     * @param commands the commands - NOT NULL and o the allawed types
     *
     * @throws IllegalArgumentException if the constraints are not met
     */
    public void setCommands(AbstractCommand[] commands) {
        if (commands == null) {
            throw new IllegalArgumentException("commands cannot be null");
        }

        for (int i = 0; i < commands.length; i++) {
            if (commands[i] == null) {
                throw new IllegalArgumentException("commands[" + i +"] cannot be null");
            } else if ((!(commands[i] instanceof Add))
                       && (!(commands[i] instanceof Replace))
                       && (!(commands[i] instanceof Delete))
                       && (!(commands[i] instanceof Copy))
                       && (!(commands[i] instanceof Atomic))
                       && (!(commands[i] instanceof Map))
                       && (!(commands[i] instanceof Sync))) {
                throw new IllegalArgumentException(
                    "commands[" + i + "] cannot be a " + commands[i].getName()
                );
            }
        }
        this.commands.clear();
        this.commands.addAll(Arrays.asList(commands));
    }

    /**
     * Gets the total number of changes
     *
     * @return the total number of changes
     */
    public int getNumberOfChanges() {
        return numberOfChanges;
    }

    /**
     * Sets the numberOfChanges property
     *
     * @param numberOfChanges the total number of changes
     */
    public void setNumberOfChanges(int numberOfChanges) {
        this.numberOfChanges = numberOfChanges;
    }

    public String getName() {
        return Sync.COMMAND_NAME;
    }
}
