/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class ObjectStringConversion
extends StringConversion {
    private static final String TOSTRING_METHOD = "toString";
    private static final String TOSTRING_SIGNATURE = "()Ljava/lang/String;";
    private static final String FROMSTRING_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String NAME_METHOD = "name";
    private static final String NAME_SIGNATURE = "()Ljava/lang/String;";
    private boolean m_needDeserialize;
    private ClassItem m_initFromString;
    private boolean m_needSerialize;
    private ClassItem m_instToString;

    ObjectStringConversion(String type, ObjectStringConversion inherit) throws JiBXException {
        super(type, inherit);
        if (type.equals(inherit.m_typeName)) {
            this.m_needDeserialize = inherit.m_needDeserialize;
            this.m_initFromString = inherit.m_initFromString;
            this.m_needSerialize = inherit.m_needSerialize;
            this.m_instToString = inherit.m_instToString;
        } else {
            this.initMethods(true);
        }
    }

    ObjectStringConversion(Object dflt, String ser, String deser, String type) {
        super(dflt, ser, null, deser, type);
        try {
            this.initMethods(false);
        }
        catch (JiBXException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private void initMethods(boolean require) throws JiBXException {
        if (!"java.lang.String".equals(this.m_typeName)) {
            ClassFile cf;
            ClassFile classFile = cf = require ? ClassCache.requireClassFile(this.m_typeName) : ClassCache.getClassFile(this.m_typeName);
            if (cf == null) {
                this.m_needSerialize = true;
                this.m_needDeserialize = true;
            } else {
                if (!"java.lang.Object".equals(this.m_typeName)) {
                    boolean needdeser = true;
                    ClassFile sclas = cf;
                    while ((sclas = sclas.getSuperFile()) != null) {
                        if (!sclas.getName().equals("java.lang.Enum")) continue;
                        this.setDeserializer(this.m_typeName + '.' + "valueOf");
                        needdeser = false;
                        if (this.m_instToString != null) break;
                        this.m_instToString = cf.getMethod(NAME_METHOD, "()Ljava/lang/String;");
                        break;
                    }
                    this.m_needDeserialize = needdeser;
                }
                this.m_needSerialize = true;
                this.m_initFromString = cf.getInitializerMethod(FROMSTRING_SIGNATURE);
                if (this.m_instToString == null) {
                    this.m_instToString = cf.getMethod(TOSTRING_METHOD, "()Ljava/lang/String;");
                }
            }
        }
    }

    public void genFromText(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_converter != null) {
            mb.appendCall(this.m_converter);
        }
        if (this.m_deserializer != null || this.m_initFromString != null || this.m_needDeserialize) {
            mb.appendDUP();
            BranchWrapper ifnnull = mb.appendIFNONNULL(this);
            mb.appendPOP();
            mb.appendACONST_NULL();
            BranchWrapper toend = mb.appendUnconditionalBranch(this);
            mb.targetNext(ifnnull);
            if (this.m_deserializer != null) {
                mb.addMethodExceptions(this.m_deserializer);
                if (this.m_deserializer.getArgumentCount() > 1) {
                    mb.loadContext();
                }
                mb.appendCall(this.m_deserializer);
            } else if (this.m_initFromString != null) {
                mb.appendCreateNew(this.m_typeName);
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit(this.m_typeName, FROMSTRING_SIGNATURE);
            } else if (this.m_needDeserialize) {
                throw new JiBXException("No deserializer for " + this.m_typeName + "; define deserializer or constructor from java.lang.String");
            }
            mb.targetNext(toend);
        }
    }

    public void genParseOptional(boolean attr, ContextMethodBuilder mb) throws JiBXException {
        mb.appendLoadConstant((String)this.m_default);
        String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genFromText(mb);
    }

    public void genParseRequired(boolean attr, ContextMethodBuilder mb) throws JiBXException {
        String name = attr ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        mb.appendCallVirtual(name, "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genFromText(mb);
    }

    public void genToText(String type, ContextMethodBuilder mb) throws JiBXException {
        if (this.m_serializer == null && this.m_needSerialize) {
            if (this.m_instToString == null) {
                throw new JiBXException("No serializer for " + this.m_typeName + "; define serializer or toString() method");
            }
            mb.addMethodExceptions(this.m_instToString);
            mb.appendCall(this.m_instToString);
        } else {
            super.genToText(type, mb);
        }
    }

    protected BranchWrapper genToOptionalText(String type, ContextMethodBuilder mb, int extra) throws JiBXException {
        if (this.m_default == null) {
            this.genToText(type, mb);
            return null;
        }
        this.genToText(type, mb);
        mb.appendDUP();
        mb.appendLoadConstant((String)this.m_default);
        mb.appendCallStatic("org.jibx.runtime.Utility.isEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
        BranchWrapper iffalse = mb.appendIFEQ(this);
        this.genPopValues(extra + 1, mb);
        BranchWrapper toend = mb.appendUnconditionalBranch(this);
        mb.targetNext(iffalse);
        return toend;
    }

    public boolean isPrimitive() {
        return false;
    }

    protected Object convertDefault(String text) throws JiBXException {
        return text;
    }

    public StringConversion derive(String type, String ser, String conv, String dser, String dflt) throws JiBXException {
        if (type == null) {
            type = this.m_typeName;
        }
        ObjectStringConversion inst = new ObjectStringConversion(type, this);
        if (ser != null) {
            inst.setSerializer(ser, true);
        }
        if (conv != null) {
            inst.setWhitespaceConverter(conv);
        }
        if (dser != null) {
            inst.setDeserializer(dser);
        }
        if (dflt != null) {
            inst.m_default = ((StringConversion)inst).convertDefault(dflt);
        }
        return inst;
    }
}

