/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Message;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.util.Util;

public class AckSenderWindowTest
extends TestCase {
    AckSenderWindow win = null;
    final int NUM_MSGS = 100;
    long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    double PERCENTAGE_OFF = 1.3;
    HashMap msgs = new HashMap();
    static /* synthetic */ Class class$org$jgroups$tests$AckSenderWindowTest;

    public AckSenderWindowTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testRetransmits() {
        long i;
        int num_non_correct_entries = 0;
        this.win = new AckSenderWindow(new MyRetransmitCommand(), this.xmit_timeouts);
        System.out.println("-- sending 100 messages:");
        for (i = 0L; i < 100L; ++i) {
            this.msgs.put(new Long(i), new Entry());
            this.win.add(i, new Message());
        }
        System.out.println("-- done");
        System.out.println("-- waiting for 20 secs for all retransmits");
        Util.sleep(20000L);
        for (i = 0L; i < 100L; ++i) {
            Entry entry = (Entry)this.msgs.get(new Long(i));
            if (entry.isCorrect(i)) continue;
            ++num_non_correct_entries;
        }
        if (num_non_correct_entries > 0) {
            System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
        }
        AckSenderWindowTest.assertTrue((num_non_correct_entries == 0 ? 1 : 0) != 0);
        this.win.reset();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$org$jgroups$tests$AckSenderWindowTest == null ? (class$org$jgroups$tests$AckSenderWindowTest = AckSenderWindowTest.class$("org.jgroups.tests.AckSenderWindowTest")) : class$org$jgroups$tests$AckSenderWindowTest);
        return suite;
    }

    public static void main(String[] args) {
        String[] name = new String[]{(class$org$jgroups$tests$AckSenderWindowTest == null ? (class$org$jgroups$tests$AckSenderWindowTest = AckSenderWindowTest.class$("org.jgroups.tests.AckSenderWindowTest")) : class$org$jgroups$tests$AckSenderWindowTest).getName()};
        TestRunner.main((String[])name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyRetransmitCommand
    implements AckSenderWindow.RetransmitCommand {
        MyRetransmitCommand() {
        }

        public void retransmit(long seqno, Message msg) {
            Entry entry = (Entry)AckSenderWindowTest.this.msgs.get(new Long(seqno));
            if (entry != null) {
                if (entry.first_xmit == 0L) {
                    entry.first_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.second_xmit == 0L) {
                    entry.second_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.third_xmit == 0L) {
                    entry.third_xmit = System.currentTimeMillis();
                    return;
                }
                if (entry.fourth_xmit == 0L) {
                    entry.fourth_xmit = System.currentTimeMillis();
                    return;
                }
            }
        }
    }

    class Entry {
        long start_time = System.currentTimeMillis();
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;

        Entry() {
        }

        boolean isCorrect(long seqno) {
            long delta;
            boolean off = false;
            long expected = AckSenderWindowTest.this.xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff >= (delta = (long)((double)expected * AckSenderWindowTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = AckSenderWindowTest.this.xmit_timeouts[1]) - (t = this.second_xmit - this.first_xmit))) >= (delta = (long)((double)expected * AckSenderWindowTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = AckSenderWindowTest.this.xmit_timeouts[2]) - (t = this.third_xmit - this.second_xmit))) >= (delta = (long)((double)expected * AckSenderWindowTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = AckSenderWindowTest.this.xmit_timeouts[3]) - (t = this.fourth_xmit - this.third_xmit))) >= (delta = (long)((double)expected * AckSenderWindowTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if (off) {
                System.err.println("#" + seqno + ": " + this + ": (" + "entry is more than " + AckSenderWindowTest.this.PERCENTAGE_OFF + " percentage off ");
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }
}

