/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.JdomDifferenceFinder;
import org.vmguys.vmtools.utils.XPath;

public class VMJdomDiff {
    public static final String tagname = "VMXMLDiff";
    public static final String xmlns = "http://www.vmguys.org/VMXMLDiff";
    public static final String schemaLocation = "http://www.vmguys.org/VMXMLDiff/xxxx";

    public Element generateDiffs(Element original, Element modified) throws JDOMException {
        String modName;
        Element rslt = null;
        String origName = original.getName();
        if (!origName.equals(modName = modified.getName())) {
            throw new JDOMException("original and modified elements are not the same type: \"" + origName + "\" vs. \"" + modName + "\"");
        }
        rslt = this.generateUpdate(original, modified);
        return rslt;
    }

    public Element applyDiffs(Element original, Element differences) throws JDOMException {
        Element rslt = (Element)original.clone();
        if (tagname.equals(differences.getName())) {
            List children1 = differences.getChildren();
            int i = 0;
            while (i < children1.size()) {
                Element child = (Element)children1.get(i);
                if (!child.getName().equals("Position")) {
                    throw new JDOMException("expecting \"Position\"; found \"" + child.getName() + "\"");
                }
                rslt = this.processPosition(rslt, child);
                ++i;
            }
        } else {
            throw new JDOMException("expecting VMXMLDiff; found \"" + differences.getName() + "\"");
        }
        return rslt;
    }

    /*
     * Unable to fully structure code
     */
    private Element processPosition(Element tree, Element position) throws JDOMException {
        rslt = null;
        xpath = position.getAttributeValue("XPath");
        if (xpath == null) {
            throw new JDOMException("Position element has no XPath attribute");
        }
        x = XPath.getElement(tree, xpath);
        if (x == null) {
            throw new JDOMException("there is no element for xpath \"" + xpath + "\"");
        }
        if (!(x instanceof Element)) {
            throw new JDOMException("Can't handle " + x.getClass().getName() + " in VMJdomDiff");
        }
        currElement = (Element)x;
        opOrder = new String[]{"Subtree", "Attribute", "Element"};
        curOp = 0;
        operands = position.getChildren();
        i = 0;
        while (i < operands.size()) {
            block11: {
                operand = (Element)operands.get(i);
                if (i != 0 || operands.size() != 1 || !operand.getName().equals("Root")) ** GOTO lbl21
                rslt = this.processRoot(tree, currElement, operand);
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++curOp;
lbl21:
                    // 2 sources

                    ** while (curOp < opOrder.length - 1 && !operand.getName().equals((Object)opOrder[curOp]))
                }
lbl22:
                // 1 sources

                if (!operand.getName().equals(opOrder[curOp])) {
                    throw new JDOMException("expecting operand type \"" + opOrder[curOp] + "\"; found \"" + operand.getName() + "\"");
                }
                switch (curOp) {
                    case 0: {
                        rslt = this.processSubtree(tree, currElement, operand);
                        break;
                    }
                    case 1: {
                        rslt = this.processAttribute(tree, currElement, operand);
                        break;
                    }
                    case 2: {
                        rslt = this.processElement(tree, currElement, operand);
                        break;
                    }
                    default: {
                        throw new Error("internal error in processPosition; curOp=" + curOp);
                    }
                }
            }
            ++i;
        }
        return rslt;
    }

    private Element processRoot(Element tree, Element currElement, Element rootRequest) throws JDOMException {
        Element rslt = null;
        String operation = rootRequest.getAttributeValue("Operation");
        if (operation.equals("replace")) {
            String elementName = currElement.getName();
            Element replacement = (Element)rootRequest.getChild(elementName).clone();
            if (replacement == null) {
                throw new JDOMException("expected replacement element to have name \"" + elementName + "\"");
            }
            Element parent = currElement.getParent();
            if (parent != null) {
                rslt = tree;
                List siblings = parent.getChildren();
                int i = siblings.indexOf(currElement);
                siblings.remove(i);
                siblings.add(i, replacement);
            } else {
                rslt = replacement;
            }
        } else {
            throw new JDOMException("Root operation should be \"replace\"; found \"" + operation + "\"");
        }
        return rslt;
    }

    private Element processAttribute(Element tree, Element currElement, Element attrRequest) throws JDOMException {
        String operation = attrRequest.getAttributeValue("Operation");
        String attrName = attrRequest.getAttributeValue("Name");
        if (attrName == null) {
            throw new JDOMException("Attribute " + operation + " request contains null attribute name");
        }
        if (operation.equals("insert") || operation.equals("modify")) {
            String attrValue = attrRequest.getAttributeValue("Value");
            currElement.setAttribute(attrName, attrValue);
        } else if (operation.equals("delete")) {
            currElement.removeAttribute(attrName);
        } else {
            throw new JDOMException("Attribute operation should be \"insert\", \"modify\" or \"delete\"; found \"" + operation + "\"");
        }
        return tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element processElement(Element tree, Element currElement, Element elementRequest) throws JDOMException {
        String operation = elementRequest.getAttributeValue("Operation");
        if (operation.equals("insert")) {
            int childNum = -1;
            String childNumAttr = elementRequest.getAttributeValue("Child");
            if (childNumAttr != null && (childNum = Integer.parseInt(childNumAttr) - 1) < 0) {
                throw new JDOMException("Element insert request has invalid child number (" + (childNum + 1) + ")");
            }
            Element newElement = (Element)((Element)elementRequest.getChildren().get(0)).clone();
            if (newElement.hasChildren()) {
                throw new JDOMException("Element insert request cannot be used to insert a subtree; element \"" + newElement.getName() + "\" has children");
            }
            List children = currElement.getChildren();
            if (childNum < 0 || childNum >= children.size()) {
                children.add(newElement);
                return tree;
            } else {
                children.add(childNum, newElement);
            }
            return tree;
        } else if (operation.equals("modify")) {
            String elementName = currElement.getName();
            Element newElement = (Element)elementRequest.getChildren().get(0);
            if (!newElement.getName().equals(currElement.getName())) throw new JDOMException("Element modify request must contain element with same name as existing element \"" + currElement.getName() + "\"");
            List content = currElement.getContent();
            int i = content.size() - 1;
            while (i >= 0) {
                Object x = content.get(i);
                if (x instanceof String) {
                    content.remove(i);
                }
                --i;
            }
            content.addAll(newElement.getContent());
            return tree;
        } else {
            if (!operation.equals("delete")) throw new JDOMException("Element operation should be \"insert\", \"modify\" or \"delete\"; found \"" + operation + "\"");
            Element parent = currElement.getParent();
            if (parent == null) throw new JDOMException("Element delete request cannot delete root node of tree (" + currElement.getName() + ")");
            List siblings = parent.getChildren();
            int childNum = siblings.indexOf(currElement);
            List children = currElement.getChildren();
            siblings.remove(childNum);
            siblings.addAll(childNum, children);
        }
        return tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element processSubtree(Element tree, Element currElement, Element subtreeRequest) throws JDOMException {
        String operation = subtreeRequest.getAttributeValue("Operation");
        if (operation.equals("insert")) {
            int childNum = -1;
            String childNumAttr = subtreeRequest.getAttributeValue("Child");
            if (childNumAttr != null && (childNum = Integer.parseInt(childNumAttr) - 1) < 0) {
                throw new JDOMException("Subtree insert request has invalid child number (" + (childNum + 1) + ")");
            }
            Element newSubtree = (Element)((Element)subtreeRequest.getChildren().get(0)).clone();
            List children = currElement.getChildren();
            if (childNum < 0 || childNum >= children.size()) {
                children.add(newSubtree);
                return tree;
            } else {
                children.add(childNum, newSubtree);
            }
            return tree;
        } else {
            if (!operation.equals("delete")) throw new JDOMException("Subtree operation should be \"insert\" or \"delete\"; found \"" + operation + "\"");
            Element parent = currElement.getParent();
            if (parent == null) throw new JDOMException("Subtree delete request cannot delete root element \"" + currElement.getName() + "\"");
            List siblings = parent.getChildren();
            siblings.remove(currElement);
        }
        return tree;
    }

    private Element generateUpdate(Element original, Element modified) throws JDOMException {
        Element update = this.generateMyElement();
        JdomDifferenceFinder diffFinder = new JdomDifferenceFinder(Namespace.getNamespace((String)xmlns));
        diffFinder.findDifferences(original, modified, update);
        return update;
    }

    private Element generateMyElement() {
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3c.org/2001/XMLSchema-instance");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ssz");
        Date currentTime = new Date();
        String timestamp = formatter.format(currentTime);
        Element element = new Element(tagname, xmlns);
        element.addNamespaceDeclaration(xsi);
        element.setAttribute("schemaLocation", schemaLocation, xsi);
        element.setAttribute("ReqRespVersion", "2");
        element.setAttribute("Timestamp", timestamp);
        return element;
    }
}

