/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.kdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kxml.Attribute;
import org.kxml.PrefixMap;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.kdom.Document;
import org.kxml.kdom.Node;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.StartTag;

public class Element
extends Node {
    protected String namespace;
    protected String name;
    protected List attributes;
    protected Node parent;
    protected PrefixMap prefixMap;

    public void init() {
    }

    public void clear() {
        this.setAttributes(new ArrayList());
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.removeChild(i);
        }
    }

    @Override
    public Element createElement(String namespace, String name) {
        return this.parent == null ? super.createElement(namespace, name) : this.parent.createElement(namespace, name);
    }

    public Attribute getAttribute(int index) {
        return (Attribute)this.attributes.get(index);
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute("", name);
    }

    public Attribute getAttribute(String namespace, String name) {
        int len = this.getAttributeCount();
        for (int i = 0; i < len; ++i) {
            Attribute attr = this.getAttribute(i);
            if (!name.equals(attr.getName()) || namespace != null && !namespace.equals(attr.getNamespace())) continue;
            return attr;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Node getParent() {
        return this.parent;
    }

    public Element getParentElement() {
        return this.parent instanceof Element ? (Element)this.parent : null;
    }

    public PrefixMap getPrefixMap() {
        return this.prefixMap;
    }

    public String getValue(String name) {
        Attribute attr = this.getAttribute("", name);
        return attr == null ? null : attr.getValue();
    }

    public String getValueDefault(String name, String dflt) {
        Attribute attr = this.getAttribute("", name);
        return attr == null ? dflt : attr.getValue();
    }

    @Override
    public void parse(AbstractXmlParser parser) throws IOException {
        StartTag startTag = (StartTag)parser.read();
        this.name = startTag.getName();
        this.namespace = startTag.getNamespace();
        this.attributes = startTag.getAttributes();
        this.setPrefixMap(startTag.getPrefixMap());
        this.init();
        super.parse(parser);
        if (startTag != null && !startTag.getDegenerated() && this.getChildCount() == 0) {
            this.addChild(256, "");
        }
        parser.read(16, startTag.getNamespace(), startTag.getName());
    }

    public void removeAttribute(int index) {
        this.attributes.remove(index);
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        } else {
            for (int i = this.attributes.size() - 1; i >= 0; --i) {
                Attribute attr = (Attribute)this.attributes.get(i);
                if (!attr.getName().equals(attribute.getName()) || !attr.getNamespace().equals(attribute.getNamespace())) continue;
                this.attributes.set(i, attribute);
                return;
            }
        }
        this.attributes.add(attribute);
    }

    public void setValue(String name, String value) {
        this.setAttribute(new Attribute(name, value));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : namespace;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public void setPrefixMap(PrefixMap prefixMap) {
        this.prefixMap = prefixMap;
    }

    @Override
    public void write(AbstractXmlWriter writer) throws IOException {
        writer.startTag(this.getPrefixMap(), this.getNamespace(), this.getName());
        int len = this.getAttributeCount();
        for (int i = 0; i < len; ++i) {
            Attribute attr = this.getAttribute(i);
            writer.attribute(attr.getNamespace(), attr.getName(), attr.getValue());
        }
        this.writeChildren(writer);
        writer.endTag();
    }
}

