#ifndef __SFJP_MYU__AGH_ControlBase_H__
#define __SFJP_MYU__AGH_ControlBase_H__

//	m_nTypeFlg
#define AGH_CONTROL_TYPEFLG_DEFAULT		(0x00000000)
#define AGH_CONTROL_TYPEFLG_VISUAL		(0x00000010)


/////////////////////////////////////////////////////////
//	Control Types

#define AGH_CONTROL_TYPE_NULL			(0x00000000)

#define AGH_CONTROL_TYPE_ROOT			(0x00010100)

#define AGH_CONTROL_TYPE_WINDOW			(0x00011001)
#define AGH_CONTROL_TYPE_BUTTON			(0x00011020)
#define AGH_CONTROL_TYPE_LABEL			(0x00011030)
#define AGH_CONTROL_TYPE_COMBO_BOX		(0x00011200)
#define AGH_CONTROL_TYPE_LIST_CTRL		(0x00011220)
#define AGH_CONTROL_TYPE_TREE_CTRL		(0x00011224)

#define AGH_CONTROL_TYPE_IMAGE			(0x00012060)

//	3D
#define AGH_CONTROL_TYPE_3D_START		(0x00013000)

#define AGH_CONTROL_TYPE_3D_CAMERA		(0x00013130)

#define AGH_CONTROL_TYPE_3D_END			(0x00013FFF)

//	End - 3D

#define AGH_CONTROL_TYPE_IMPL_FACTORY	(0x00018100)

#define AGH_CONTROL_TYPE_USER_FIRST		(0x20000000)
//	********** User Defined **********
#define AGH_CONTROL_TYPE_USER_LAST		(0x5FFFFFFF)
// reserved: 0x60000000 - 0xffffffff


/////////////////////////////////////////////////////////
//	Foundation Control Types - {Rg[

#define AGH_FOUNDA_CTRL_NORMAL			(0x00000000)
#define AGH_FOUNDA_CTRL_VISUAL			(0x00000010)


/////////////////////////////////////////////////////////
//	Variable Keys
/*
#define AGH_VALKEY_NOINHERIT			(0x00000000)
#define AGH_VALKEY_NOTINHERIT			(0x00000000)
#define AGH_VALKEY_INHERIT				(0x80000000)
*/
//	2009/05/03  tɂ[v̎i0x80000000breakj
#define AGH_VALKEY_INHERIT				(0x00000000)
#define AGH_VALKEY_NOINHERIT			(0x80000000)
#define AGH_VALKEY_NOTINHERIT			(0x80000000)

//----------

#define AGH_VALKEY_NULL					(0x00000000)

#define AGH_VALKEY_FOUNDA_CONTROL		(AGH_VALKEY_NOINHERIT + 0x00008008)		//	Not Inherit.
#define AGH_VALKEY_FOUNDA_CTRL			(AGH_VALKEY_NOINHERIT + 0x00008008)		//	Not Inherit. (Alias)
#define AGH_VALKEY_CONTROL_TYPE			(AGH_VALKEY_NOINHERIT + 0x00008010)		//	Not Inherit.

#define AGH_VALKEY_ROOT					(AGH_VALKEY_INHERIT +   0x00010100)		//	Inherit to sub control.
#define AGH_VALKEY_PARENT				(AGH_VALKEY_NOINHERIT + 0x00010200)		//	Not Inherit.
#define AGH_VALKEY_CHILD				(AGH_VALKEY_NOINHERIT + 0x00010210)		//	Not Inherit.
#define AGH_VALKEY_CHILD_FIRST			(AGH_VALKEY_NOINHERIT + 0x00010211)		//	Not Inherit.
#define AGH_VALKEY_CHILD_LAST			(AGH_VALKEY_NOINHERIT + 0x00010212)		//	Not Inherit.
#define AGH_VALKEY_IMPL_FACTORY			(AGH_VALKEY_INHERIT +   0x00010504)		//	Inherit to sub control.

#define AGH_VALKEY_CONTROLS_FIRST		(AGH_VALKEY_INHERIT + 0x00040000)		//	Inherit to sub control.
#define AGH_VALKEY_WINDOW				(AGH_VALKEY_CONTROLS_FIRST + 0200)		//	Inherit to sub control.
#define AGH_VALKEY_CONTROLS_LAST		(AGH_VALKEY_INHERIT + 0x000FFFFF)		//	Inherit to sub control.

#define AGH_VALKEY_USER_FIRST			(0x20000000)
//	********** User Defined **********
#define AGH_VALKEY_USER_LAST			(0x5FFFFFFF)
// reserved: 0x60000000 - 0x7fffffff

/*
#define AGH_VALKEY_NOINHERIT			(0x80000000)

#define AGH_VALKEY_NOINHERIT_USER_FIRST	(AGH_VALKEY_NOINHERIT+AGH_VALKEY_USER_FIRST)
#define AGH_VALKEY_NOINHERIT_USER_LAST	(AGH_VALKEY_NOINHERIT+AGH_VALKEY_USER_LAST)
*/

#define AGH_VALKEY_INVALID				(0xFFFFFFFF)

/////////////////////////////////////////////////////////


/*************************************************************************************************/
/*                                                                                               */
/*  CControlBase                                                                                 */
/*                                                                                               */
/*************************************************************************************************/

class CVisualControlBase;

//	Control base class : eRg[NX
class CControlBase : public agh::COtherEventBase
{
//#define _CControlBase_CHILD_ARRAY_TYPE_VECTOR
//	####### ^錾 : Types Definition #######
public:
	//typedef std::vector<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;
	//typedef std::vector<agh::CControlBase*>::iterator CHILD_CTRL_ARY_ITERATOR;
	//typedef _agh_vector<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;
	//typedef _agh_vector<agh::CControlBase*>::iterator CHILD_CTRL_ARY_ITERATOR;
#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
	typedef _AGH_VECTOR(agh::CControlBase*) CHILD_CTRL_ARY_TYPE;
	typedef _AGH_VECTOR(agh::CControlBase*)::iterator CHILD_CTRL_ARY_ITERATOR;
	typedef _AGH_VECTOR(agh::CControlBase*)::iterator CHILD_CTRL_ARY_ITR;
#else
	typedef _AGH_MAP(agh::CControlBase*, agh::CControlBase*) CHILD_CTRL_ARY_TYPE;
	typedef CHILD_CTRL_ARY_TYPE::iterator CHILD_CTRL_ARY_ITERATOR;
	typedef CHILD_CTRL_ARY_TYPE::iterator CHILD_CTRL_ARY_ITR;
#endif
	//typedef std::list<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;

//	$$$$$$$ protectedoϐn $$$$$$$
protected:
	CHILD_CTRL_ARY_TYPE m_ctrlPtrAry;	//	qRg[Qi|C^zj: Child Control List (pointer array)
	agh::CControlBase* m_pParent;		//	eRg[̃|C^ : Parent Control Pointer	//	2009/08/12 iς肠֗j
	_agh_string m_controlId;			//	SRg[ӂɎʉ\ID : Unique ID on All Control

	//std::map<int,int> m_nmap;
	//std::map<std::string,std::string> m_smap;
	//_agh_map<int,int> m_nmap;
	//_agh_map_strstr m_smap;
	//_AGH_MAP(int,int) m_valMapInt;
	typedef std::map<unsigned int,int> VAL_MAP_INT;
	typedef std::map<std::string,std::string> VAL_MAP_STR;
	VAL_MAP_INT m_valMapInt;
	VAL_MAP_STR m_valMapStr;

	_agh_string m_strControlTypeName;	//	Rg[ʖ

	int m_nTypeFlg;				//	Control type flags (AGH_CONTROL_TYPEFLG_... 's OR)
	/*int m_nTypeFlgUser1;		//	User Control type flags. (1)
	int m_nTypeFlgUser2;		//	User Control type flags. (2)
	int m_nTypeFlgUser3;		//	User Control type flags. (3)*/

	_agh_string m_strClassName;			//	NXifobOpj
	_agh_string m_strInstanceName;		//	CX^XifobOpj

	void SetClassName(const char* s){ m_strClassName = s; }
	//void SetInstanceName(const char* s){ m_strInstanceName = s; } -> public

	///////////////////////////////////////////////////////////////////////

	bool FindValMapInt(int nKey, int* pResult){
		VAL_MAP_INT::iterator it = m_valMapInt.find(nKey);
		if ( it == m_valMapInt.end() )
			return false;
		else{
			*pResult = it->second;
			return true;
		}
	}
	int FindValMapInt(int nKey){
		VAL_MAP_INT::iterator it = m_valMapInt.find(nKey);
		if ( it == m_valMapInt.end() )
			return NULL;
		else
			return it->second;
	}
	virtual int StrKeyNameToIntKey(const char* szKey){ return AGH_VALKEY_INVALID; }

//	####### Ce[^n(J) #######
public:
	/*
	typedef CHILD_CTRL_ARY_TYPE::iterator ctrl_iterator;
	typedef CHILD_CTRL_ARY_TYPE::iterator citerator;
	typedef CHILD_CTRL_ARY_TYPE::iterator cIterator;
	typedef CHILD_CTRL_ARY_TYPE::iterator cItr;
	typedef CHILD_CTRL_ARY_TYPE::iterator citr;

	ctrl_iterator cbegin(){ return m_ctrlPtrAry.begin(); }
	ctrl_iterator cend(){ return m_ctrlPtrAry.end(); }
	*/

	class ctrl_iterator2
	{
	private:
		CHILD_CTRL_ARY_ITERATOR m_it;
	public:
		ctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in){ m_it = it_in; }
		void operator ++ (){ m_it++; }
		void operator ++ (int){ m_it++; }
		int operator != (ctrl_iterator2 it_in){ return ( m_it != it_in.m_it ? 1 : 0 ); }
#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
		agh::CControlBase* get(){ return *m_it; }
#else
		agh::CControlBase* get(){ return m_it->first; }
#endif
		agh::CControlBase* operator -> (){ return get(); }
	};
	class vctrl_iterator2
	{
	private:
		CHILD_CTRL_ARY_ITERATOR m_it;
		CHILD_CTRL_ARY_ITERATOR m_it_end;

		void _nv_skip(){
			//for(; m_it != m_it.end(); m_it++)
			for(; m_it != m_it_end; m_it++)
			{
#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
				if ( (*m_it)->IsVisualControl() ){
#else
				if ( m_it->first->IsVisualControl() ){
#endif
					//m_it = m_it_end; // 2009/05/17 VisualłȂꍇɖ[vɊׂ <- Ⴄ 2009/05/18
					break;
					//return m_it;
				}
			}
			//return m_it;	//	 m_ctrlPtrAry.end() B
		}

	public:
		vctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in){ m_it = it_in; }
		vctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in, CHILD_CTRL_ARY_ITERATOR it_end_in){
			m_it = it_in;	//	TODO: oOĂ
			m_it_end = it_end_in;

			_nv_skip();
		}
		void operator ++ (int){ operator ++(); }
		void operator ++ (){
			m_it++;	//	2009/05/18 ꂪ

			_nv_skip();
			/*
			//for(; m_it != m_it.end(); m_it++)
			for(; m_it != m_it_end; m_it++)
			{
				if ( (*m_it)->IsVisualControl() ){
					//m_it = m_it_end; // 2009/05/17 VisualłȂꍇɖ[vɊׂ <- Ⴄ 2009/05/18
					break;
					//return m_it;
				}
			}
			//return m_it;	//	 m_ctrlPtrAry.end() B
			*/
		}
		int operator != (vctrl_iterator2 it_in){ return ( m_it != it_in.m_it ? 1 : 0 ); }
#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
		agh::CVisualControlBase* get(){ return (agh::CVisualControlBase*)*m_it; }
#else
		agh::CVisualControlBase* get(){ return (agh::CVisualControlBase*)m_it->first; }
#endif
		agh::CVisualControlBase* operator -> (){ return get(); }
	};

	typedef ctrl_iterator2 ctrl_iterator;
	typedef ctrl_iterator citerator;
	typedef ctrl_iterator cIterator;
	typedef ctrl_iterator cItr;
	typedef ctrl_iterator citr;

	typedef vctrl_iterator2 vctrl_iterator;
	typedef vctrl_iterator vciterator;
	typedef vctrl_iterator vcIterator;
	typedef vctrl_iterator vcItr;
	typedef vctrl_iterator vcitr;

	ctrl_iterator cbegin(){ return ctrl_iterator2(m_ctrlPtrAry.begin()); }
	ctrl_iterator cend(){ return ctrl_iterator2(m_ctrlPtrAry.end()); }
	vctrl_iterator vcbegin(){ return vctrl_iterator2(m_ctrlPtrAry.begin(), m_ctrlPtrAry.end()); }
	vctrl_iterator vcend(){ return vctrl_iterator2(m_ctrlPtrAry.end()); }

#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
	int _cpp(int &i){
		i++;
		for(; i<((int)m_ctrlPtrAry.size()); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			break;
		}
		return i;
	}
	int _vcpp(int &i){
		i++;
		for(; i<((int)m_ctrlPtrAry.size()); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			if ( !p_->IsVisualControl() )
				continue;
			break;
		}
		return i;
	}
#else
#endif
	/*int _cpp(int i_in){
		for(int i=i_in; i<m_ctrlPtrAry.size(); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			break;
		}
		return i;
	}
	int _vcpp(int i_in){
		for(int i=i_in; i<m_ctrlPtrAry.size(); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			if ( !p_->IsVisualControl() )
				continue;
			break;
		}
		return i;
	}*/

protected:
#define _AGH_CTRL_LOOP_START	for(citr cit=cbegin(); cit != cend(); cit++){
#define _AGH_CTRL_LOOP_END		}

//	######## I[o[Ch\ȃCxgnh : Overridable Event Handlers ########
_AGH_EVENT_ACCESS_MODIFIER:
	virtual bool OnInit(){return true;}		//	falseԂƃvOI
	virtual bool OnFrame(){return true;}	//	falseԂƃvOI
	virtual bool OnReady(){return true;}	//	falseԂƃvOI

	virtual void OnRegist(){}
	virtual void OnUnregist(){ SetParentControl(NULL); /*m_pParent = NULL;*/ }


//	$$$$$$$ ĂяopCxgnh $$$$$$$
protected:
	virtual bool _OnFrame(){
		//	ƎqAǂŏ낤EEEH
		if ( this->OnFrame() != true )
			return false;
		if ( this->OnFrameChilds() != true )
			return false;
		return true;
		/*
		_AGH_CTRL_LOOP_START
			if ( cit->_OnFrame() != true )
				break;
		_AGH_CTRL_LOOP_END
		*/
	}
	virtual bool OnFrameChilds(){
		_AGH_CTRL_LOOP_START
			if ( cit->_OnFrame() != true )
				break;
		_AGH_CTRL_LOOP_END
		return true;
	}	

//	######### OĂяoWIȂ̑̃\bh #########
private:
	void _CControlBase(){
		m_nTypeFlg = 0;
		m_pParent = NULL;

		SetValInt(AGH_VALKEY_FOUNDA_CTRL, AGH_FOUNDA_CTRL_NORMAL);
		SetValInt(AGH_VALKEY_INHERIT, 0);
		SetValInt(AGH_VALKEY_NOINHERIT, 0);
	}
public:
	//	RXgN^
	CControlBase(){
		_CControlBase();
	}
	CControlBase(int nTypeFlg){
		_CControlBase();
		m_nTypeFlg = nTypeFlg;
		/*m_pParent = NULL;

		SetValInt(AGH_VALKEY_FOUNDA_CTRL, AGH_FOUNDA_CTRL_NORMAL);
		SetValInt(AGH_VALKEY_INHERIT, 0);
		SetValInt(AGH_VALKEY_NOINHERIT, 0);*/
	}
	virtual ~CControlBase(){
		DeleteFromParent();	//	2009/10/27
	}


	//// Rg[̓o^֘A ///////////////////////////////////////////////////////////////////////////

	//	Rg[̓o^
	virtual void RegistSubControl(agh::CControlBase* pControl){
#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
		m_ctrlPtrAry.push_back(pControl);
#else
		m_ctrlPtrAry[pControl] = pControl;
#endif

		//	2009/04/05
		pControl->SetParentControl(this);
		pControl->OnRegist();
		//pControl->OnRegist(this);
	}
	//virtual void RegistSubControl(agh::CControlBase &rControl){ RegistSubControl(&rControl); }
	//virtual void RegistControl(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void RegistControl(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void RegistChildControl(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void RegistChildControl(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void RegistChild(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void RegistChild(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void AddChildControl(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void AddChildControl(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void AddChild(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void AddChild(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void AppendChildControl(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void AppendChildControl(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	//virtual void AppendChild(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void AppendChild(agh::CControlBase* pControl){ RegistSubControl(pControl); }
	
	//virtual void UnregistSubControl(agh::CControlBase* pControl)
	//virtual void UnregistSubControl(agh::CControlBase &rControl)

#ifdef _CControlBase_CHILD_ARRAY_TYPE_VECTOR
	//	o^폜
	virtual void UnregistSubControl(int i){
		//	2009/04/05
		//m_ctrlPtrAry[i]->SetParentControl(NULL);
		m_ctrlPtrAry[i]->OnUnregist();

		m_ctrlPtrAry[i] = NULL;
	}
	virtual void UnregistControl(int i){ UnregistControl(i); }
	virtual void UnregistChildControl(int i){ UnregistControl(i); }
	virtual void UnregistChild(int i){ UnregistControl(i); }
	virtual void RemoveChildControl(int i){ UnregistControl(i); }
	virtual void RemoveChild(int i){ UnregistControl(i); }
#endif

	//	o^폜iagh::CControlBase*Łj
	virtual bool UnregistSubControl(agh::CControlBase* pControl){
		//	2009/04/05
		//m_ctrlPtrAry[i]->SetParentControl(NULL);
		
		CHILD_CTRL_ARY_ITR it = m_ctrlPtrAry.find(pControl);
		if ( it == m_ctrlPtrAry.end() )
			return false;

		it->first->OnUnregist();

		//	2009/10/27 ܂eraseĂ
		m_ctrlPtrAry.erase(it);
		return true;
	}
	virtual bool UnregistControl(agh::CControlBase* pControl){ return UnregistSubControl(pControl); }
	virtual bool UnregistChildControl(agh::CControlBase* pControl){ return UnregistSubControl(pControl); }
	virtual bool UnregistChild(agh::CControlBase* pControl){ return UnregistSubControl(pControl); }
	virtual bool RemoveChildControl(agh::CControlBase* pControl){ return UnregistSubControl(pControl); }
	virtual bool RemoveChild(agh::CControlBase* pControl){ return UnregistSubControl(pControl); }


	/// e폜 *************************************** //

	//	o^폜iagh::CControlBase*Łj
	virtual bool VanishChild(agh::CControlBase* pControl){
		//	2009/04/05
		//m_ctrlPtrAry[i]->SetParentControl(NULL);
		
		CHILD_CTRL_ARY_ITR it = m_ctrlPtrAry.find(pControl);
		if ( it == m_ctrlPtrAry.end() )
			return false;

		//	2009/10/27 ܂eraseĂ
		m_ctrlPtrAry.erase(it);
		return true;
	}

	virtual void DeleteFromParent(){ if ( m_pParent != NULL ) m_pParent->VanishChild(this); }
	virtual void VanishFromParent(){ DeleteFromParent(); }
	virtual void Vanish(){ DeleteFromParent(); }
	virtual void SelfVanish(){ DeleteFromParent(); }


	//// Val ///////////////////////////////////////////////////////////////////////////

	virtual void SetValInt(int nKey, int nVal){
		m_valMapInt[nKey] = nVal;

		//	#### 2009/08/12 qɂǉΉ #########
		for(citr it=cbegin(); it != cend(); it++)
		{
			it->SetValInt(nKey, nVal);
		}
	}
	//virtual void SetValInt(const char* szKey, int nVal){ ; }	//	ĂȂΏNULL
	void SetValPtr(int nKey, void* ptr){ SetValInt(nKey, (int)ptr); }
	//void SetValPtr(const char* szKey, void* ptr){ SetValInt(szKey, (int)ptr); }

	virtual int GetValInt(int nKey){ return FindValMapInt(nKey); }
	//virtual int GetValInt(const char* szKey){ return NULL; }	//	ĂȂΏNULL
	void* GetValPtr(int nKey){ return (void*)GetValInt(nKey); }
	//void* GetValPtr(const char* szKey){ return (void*)GetValInt(szKey); }

	VAL_MAP_INT& GetIntValMap(){ return m_valMapInt; }
	VAL_MAP_STR& GetStrValMap(){ return m_valMapStr; }


	///////////////////////////////////////////////////////////////////////////////


	//virtual void SetParentControl(agh::CControlBase* pParentControl){ m_pParent = pParentControl; }
	//virtual void SetParentControl(agh::CControlBase* pParentControl){ m_valMapInt[AGH_VALKEY_PARENT] = (int)pParentControl; }
	virtual void SetParentControl(agh::CControlBase* pParentControl){
		m_valMapInt[AGH_VALKEY_PARENT] = (int)pParentControl;

		//	2009/08/12 iς肠֗j
		m_pParent = pParentControl;
	
//#ifdef AGH_VALKEY_NOINHERIT == 0
		VAL_MAP_INT &pivm = pParentControl->GetIntValMap();
		VAL_MAP_INT::iterator it = pivm.begin();
		for(; it != pivm.end() ; it++)
		{
			//if ( it->first >= AGH_VALKEY_INHERIT ) <- ?
			//if ( ((unsigned int)it->first) >= ((unsigned int)AGH_VALKEY_NOINHERIT) )
			if ( it->first >= AGH_VALKEY_NOINHERIT )	//	first̂unsignedɂȂ̂ŃLXgsvȂ͂
				break;

			m_valMapInt[it->first] = it->second;
		}

/* String: 
		VAL_MAP_STR &psvm = pParentControl->GetStrValMap();
		VAL_MAP_STR::iterator it2 = psvm.begin();
		for(; it2 != psvm.end() ; it2++)
		{
			if ( it2->first >= AGH_VALKEY_INHERIT )
				break;

			m_valMapStr[it2->first] = it2->second;
		}*/

		/*VAL_MAP_INT &pivm = pParentControl->GetIntValMap();
		m_valMapInt.insert(pivm.find(AGH_VALKEY_INHERIT), pivm.find(AGH_VALKEY_NOINHERIT));*/

		//m_valMapInt = pParentControl->GetIntValMap();
		//m_valMapStr = pParentControl->GetStrValMap();
	}
	virtual agh::CControlBase* GetParentControl(){ return (agh::CControlBase*)GetValPtr(AGH_VALKEY_PARENT); }
	//virtual void OnRegist(agh::CControlBase* pParentControl){ m_pParent = pParentControl; }

	bool IsRegisted(){ return GetParentControl() ? true : false; }

	//	CxgĂяon\bh
	virtual bool DoFrame(){ return _OnFrame(); }

	//// ̑ //////////////////////////////////////////////////////////////////////////////////////

	virtual bool IsVisualControl(){ return ( m_nTypeFlg & AGH_CONTROL_TYPEFLG_VISUAL ? true : false ); }
	virtual int GetTypeFlag(){ return m_nTypeFlg; }

	bool IsVisualCtrl(){
		return GetValInt(AGH_VALKEY_FOUNDA_CTRL) == AGH_FOUNDA_CTRL_VISUAL ? true : false; }
	bool IsVisual(){
		return GetValInt(AGH_VALKEY_FOUNDA_CTRL) == AGH_FOUNDA_CTRL_VISUAL ? true : false; }

	virtual void* GetInternalPtr(){ return NULL; }
	void* GetInternal(){ return GetInternalPtr(); }

	void SetInstanceName(const char* s){ m_strInstanceName = s; }
	const char* GetInstanceName(){ return m_strInstanceName.c_str(); }
	const char* GetClassName(){ return m_strClassName.c_str(); }
	const char* getClassName(){ return m_strClassName.c_str(); }
};



#include "agh_VisualControlBase.h"


#endif//__SFJP_MYU__AGH_ControlBase_H__
