#ifndef __SFJP_MYU__AGH_Controls_H__
#define __SFJP_MYU__AGH_Controls_H__

#include "agh_control_Window.h"
#include "agh_control_Image.h"

/////////////////////////////////////////////////////////////

class CRootBase : public CControlBase {
_AGH_EVENT_ACCESS_MODIFIER:

public:
	virtual ~CRootBase(){}	//	fXgN^ƌĂ΂邽߂̑΍
};

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

#define AGH_DEFAULT_TEXT_POINT		(12)

//	Font name defines
#define AGH_FONT_NAME_MS_GOTHIC		"MS Gothic"		//	Windows Font
#define AGH_FONT_NAME_MS_PGOTHIC	"MS PGothic"	//	Windows Font

#ifdef WIN32
	#define AGH_DEFAULT_FONT_NAME	AGH_FONT_NAME_MS_PGOTHIC
#else
	#define AGH_DEFAULT_FONT_NAME	""
#endif

//	Font Option
#define AGH_FONT_OPTION_NOTHING		(0x00000000)
#define AGH_FONT_OPTION_BOLD		(0x00000001)	//	
#define AGH_FONT_OPTION_ITALIC		(0x00000010)	//	΂ߕ
#define AGH_FONT_OPTION_UNDERLINE	(0x00000020)	//	
#define AGH_FONT_OPTION_STRIKEOUT	(0x00000040)	//	

#define AGH_TEXT_ALIGN_LEFT			(0x00)
#define AGH_TEXT_ALIGN_RIGHT		(0x01)
#define AGH_TEXT_ALIGN_CENTER		(0x02)
#define AGH_TEXT_ALIGN_TOP			(0x10)
#define AGH_TEXT_ALIGN_BOTTOM		(0x11)
#define AGH_TEXT_ALIGN_VCENTER		(0x12)
#define _AGH_TEXT_ALIGN_HFILTER(a)	((a)&0x0f)
#define _AGH_TEXT_ALIGN_VFILTER(a)	((a)&0xf0)


//	CStatic / CLabel / CText
template <typename _BASE = CVisualControlBase>
class CTextBaseT : public _BASE {
//class CTextBase : public CVisualControlBase {
protected:
	_agh_string m_textData;
	_agh_string m_strFontName;
	int m_nPoint;
	//AGHCOLOR m_color;
	AGHDWORD m_dwOption;
	int m_nAlign;
	/*bool m_bBold;
	bool m_bItaric;*/

public:
	CTextBaseT(){
		m_nPoint = AGH_DEFAULT_TEXT_POINT;
		_BASE::m_color = AGHCOLOR_BLACK;
		m_strFontName = AGH_DEFAULT_FONT_NAME;
		m_nAlign = AGH_TEXT_ALIGN_LEFT;
		m_dwOption = 0;
	}
	virtual ~CTextBaseT(){}	//	fXgN^ƌĂ΂邽߂̑΍

	virtual void SetFontName(const char* szFontName){ m_strFontName = szFontName; }
	virtual void SetFontPoint(int point){ m_nPoint = point; }
	void SetFontSize(int point){ SetFontPoint(point); }
	void SetPoint(int point){ SetFontPoint(point); }

	virtual void SetStr(const char* szStr){ m_textData = szStr; }
	_agh_final void SetText(const char* szText){ SetStr(szText); }
	_agh_final void SetTextData(const char* szTextData){ SetStr(szTextData); }
	virtual const char* GetStr(){ return m_textData.c_str(); }
	_agh_final const char* GetText(){ return GetStr(); }
	_agh_final const char* GetTextData(){ return GetStr(); }

	//virtual void SetColor(AGHCOLOR color){ m_color = color; }
	virtual void SetOption(AGHDWORD dwOption){ m_dwOption = dwOption; }
	//virtual AGHCOLOR GetColor(){ return m_color; }
	virtual AGHDWORD GetOption(){ return m_dwOption; }

	virtual void Align(int align){ m_nAlign = align; }
	_agh_final void AlignLeft(){ Align( _AGH_TEXT_ALIGN_VFILTER(m_nAlign) + AGH_TEXT_ALIGN_LEFT ); }
	_agh_final void AlignRight(){ Align( _AGH_TEXT_ALIGN_VFILTER(m_nAlign) + AGH_TEXT_ALIGN_RIGHT); }
	_agh_final void AlignCenter(){ Align( _AGH_TEXT_ALIGN_VFILTER(m_nAlign) + AGH_TEXT_ALIGN_CENTER); }
	_agh_final void AlignTop(){ Align( _AGH_TEXT_ALIGN_HFILTER(m_nAlign) + AGH_TEXT_ALIGN_TOP); }
	_agh_final void AlignBottom(){ Align( _AGH_TEXT_ALIGN_HFILTER(m_nAlign) + AGH_TEXT_ALIGN_BOTTOM); }
	_agh_final void AlignVCenter(){ Align( _AGH_TEXT_ALIGN_HFILTER(m_nAlign) + AGH_TEXT_ALIGN_VCENTER); }
};

//template <typename _BASE = CVisualControlBase> class CLabel : public _BASE {
template <typename T>class CLabelT{ typedef CTextBaseT<T> type; };
template <typename T>class CStaticT{ typedef CTextBaseT<T> type; };
template <typename T>class CTextT{ typedef CTextBaseT<T> type; };

typedef CTextBaseT<CVisualControlBase> CTextBase;
typedef CTextBaseT<CVisualControlBase> CLabel;
typedef CTextBaseT<CVisualControlBase> CStatic;
typedef CTextBaseT<CVisualControlBase> CText;

/*typedef CTextBase<T> CLabel<T>;
typedef CTextBase CStatic;
typedef CTextBase CText;*/

//	CButton
class CButtonBase : public CVisualControlBase {


};

//	EditBox
class CEditBoxBase : public CVisualControlBase {
/*private:
	_agh_string m_str*/
};

//	ComboBox
class CComboBoxBase : public CVisualControlBase {


};

//	ListBox
class CListBoxBase : public CVisualControlBase {


};

//	TreeControl
class CTreeCtrlBase : public CVisualControlBase {


};

#endif//__SFJP_MYU__AGH_Controls_H__
