#include "agh.h"


void EffectTest()
{
	agh::CColorFadeEffect a;

	agh::math::CIntStraightLine l1;
	agh::math::CFloatStraightLine l2;

	l1.SetRange(20, 100);
	l2.SetRange(20, 100);

	printf("%d\n", l1.Get(0.51f));
	printf("%f\n", l2.Get(0.58f));
}

void ControlArrayTest()
{
	agh::CControlArrayT<agh::CWindowBase, std::map<agh::CControlArrayItem<agh::CWindowBase>, int>, int> a;

	//agh::CControlVector<agh::CWindowBase> c;

	///////////////////////////////////////////////

	printf("========== CControlList Test ===========\n");

	agh::CControlList<agh::CWindowBase> caList;

	caList.Add().SetInstanceName("caList[0]");
	caList.Add().SetInstanceName("caList[1]");
	caList.Add().SetInstanceName("caList[2]");
	caList.Add().SetInstanceName("caList[3]");

	caList.Draw();

	{for( agh::CControlList<agh::CWindowBase>::iterator it = caList.begin(); it != caList.end(); it++)
		printf("%s\n", it->GetInstanceName());
	}

	////////////////////////////////////////////////

	printf("========== CControlMap Test ===========\n");

	agh::CControlMap<agh::CWindowBase, std::string> caMap;

	caMap.Add("hoge1").SetInstanceName("caMap[hoge1]");
	caMap.Add("hoge2").SetInstanceName("caMap[hoge2]");
	caMap.Add("hoge3").SetInstanceName("caMap[hoge3]");
	caMap.Add("hoge0").SetInstanceName("caMap[hoge0]");

	caMap.Draw();

	{for( agh::CControlMap<agh::CWindowBase, std::string>::iterator it = caMap.begin(); it != caMap.end(); it++)
		printf("%s : %s\n", it.key().c_str(), it->GetInstanceName());
	}
}

int main()
{
	EffectTest();
	ControlArrayTest();

	return 0;
}