////////////////////////////////////////////////////////////////////////////
//	t@C	F	dx_graphic.cpp
//	t@CTvF	_CNgOtBbN֘ȀsB
//	쐬		F	M.Minami
////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "dx_graphic.h"

////////////////////////////////////////////////////////////////////////////
//                        O[oϐ̐錾
////////////////////////////////////////////////////////////////////////////
// _CNgwOtBbNn
LPDIRECT3DDEVICE8			g_pD3DDevice  = NULL;	// _CNgRcfoCX

// Wϊ}gbNX ----------------------------------------------------
static D3DXMATRIX			g_ProjMat;				// ϊ}gbNX
static D3DXMATRIX			g_ViewMat;				// J}gbNX

// Cg ------------------------------------------------------------------
static D3DMATERIAL8			g_Material;
static D3DLIGHT8			g_Light;

////////////////////////////////////////////////////////////////////////////
//                     t@CԃC^[tF[X֐
////////////////////////////////////////////////////////////////////////////
LPDIRECT3DDEVICE8  GetD3DDevice(void) { return g_pD3DDevice; }

void GrpSetProjMat(float clip_near, float clip_far);
void GrpSetViewMat(D3DXVECTOR3 eye, D3DXVECTOR3 pos);
void GrpSetRotTransMat(D3DXMATRIX &wmat, D3DXVECTOR3 &s, D3DXVECTOR3 &t, D3DXVECTOR3 &r);
void GrpSetLiht(D3DLIGHT_MODE mode);
inline void GrpTLVertexSet(D3DTLVERTEX *v, float x, float y, float z, float tu, float tv, D3DCOLOR rgba);
inline void GrpLVertexSet(D3DLVERTEX *v, float x, float y, float z, float tu, float tv, D3DCOLOR rgba);
inline void GrpVertexSet(D3DVERTEX *v, float x, float y, float z, float nx, float ny, float nz, float tu, float tv);

void GrpSetProjMat(float clip_near, float clip_far)
{
	// ϊs쐬inj
	D3DXMatrixPerspectiveFovLH(&g_ProjMat,							// 쐬vWFNV}gbNXւ̃|C^
					D3DXToRadian(45.0),								// p
					640.0f / 480.0f,								// AXyNgicA䗦j
					clip_near,										// Near Nbv
					clip_far);										// Far  Nbv
	g_pD3DDevice->SetTransform(D3DTS_PROJECTION, &g_ProjMat);		// ϊsݒ
}

void GrpSetViewMat(D3DXVECTOR3 eye, D3DXVECTOR3 pos)
{
	// Js쐬inj	
	D3DXMatrixLookAtLH(&g_ViewMat,									// 쐬r[}gbNX̃|C^
					   &pos,										// Jʒu
					   &eye,										// JÎ_
					   &D3DXVECTOR3(0,1,0));						// [hԂŏRxNgw	

	// Jsݒ
	g_pD3DDevice->SetTransform(D3DTS_VIEW, &g_ViewMat);
}

inline void GrpLVertexSet(D3DLVERTEX *v, float x, float y, float z, float tu, float tv, D3DCOLOR rgba)
{
	v->x		= x;	
	v->y		= y;	
	v->z		= z;
	v->color	= rgba;
	v->specular	= 0;
	v->tu0		= tu;	
	v->tv0		= tv;
}

void GrpSetLight(D3DLIGHT_MODE mode)
{
	if (mode == D3DLIGHT_INIT) {
		// Cg ----------------------------------------------------
		// }eA̐ݒ
		g_Material.Diffuse.r  = 1;									// fBt[YFݒ
		g_Material.Diffuse.g  = 1;
		g_Material.Diffuse.b  = 1;
		g_Material.Ambient.r  = 0.5f;								// ArGgFݒ
		g_Material.Ambient.g  = 0.5f;
		g_Material.Ambient.b  = 0.5f;
		g_Material.Emissive.r = 0;									// G~bVFݒ
		g_Material.Emissive.g = 0;
		g_Material.Emissive.b = 0;

		// ̍쐬
		ZeroMemory(&g_Light,sizeof(D3DLIGHT8));
		g_Light.Type		= D3DLIGHT_DIRECTIONAL;					// fBNViCg
		g_Light.Diffuse.r = 1;										// fBt[YFݒ
		g_Light.Diffuse.g = 1;
		g_Light.Diffuse.b = 1;
		g_Light.Ambient.r = 0.5f;									// ArGgFݒ
		g_Light.Ambient.g = 0.5f;
		g_Light.Ambient.b = 0.5f;
		g_Light.Direction = D3DXVECTOR3(0,0,1);						// Ǝ˕
		g_Light.Position  = D3DXVECTOR3(0,0,0);						// ʒuifBNV͉ej

		g_pD3DDevice->SetRenderState(D3DRS_LIGHTING,TRUE);			// CeBO
		g_pD3DDevice->SetRenderState(D3DRS_SHADEMODE, D3DSHADE_GOURAUD);// O[VF[fBOs
		g_pD3DDevice->SetRenderState(D3DRS_SPECULARENABLE,FALSE);	// XyLgpȂ
		g_pD3DDevice->SetLight(0,&g_Light);							// CgVXeɐݒ

		g_pD3DDevice->SetMaterial(&g_Material);						// }eAVXeɐݒ
		g_pD3DDevice->SetRenderState(D3DRS_NORMALIZENORMALS,TRUE);	// _@̎KLɂ
		g_pD3DDevice->LightEnable(0, TRUE);							// Cgnm
	} else if (mode == D3DLIGHT_ON) {
		// Cgnm ------------------------------------------------------
		g_pD3DDevice->SetRenderState(D3DRS_LIGHTING,TRUE);			// CeBOnm	
	} else {
		// Cgnee ----------------------------------------------------
		g_pD3DDevice->SetRenderState(D3DRS_LIGHTING,FALSE);			// CeBOnee	
	}
}

void GrpSetRotTransMat(D3DXMATRIX &wmat, D3DXVECTOR3 &s, D3DXVECTOR3 &t, D3DXVECTOR3 &r)
{
	D3DXMATRIX smat, tmat, rmat;

	D3DXMatrixScaling(&smat, s.x, s.y, s.z);					// XP[}gbNX
	D3DXMatrixTranslation(&tmat, t.x, t.y, t.z);				// ړ}gbNX
	D3DXMatrixRotationYawPitchRoll(&rmat, r.y, r.x, r.z);		// ]}gbNX

	// XP[}gbNX  XP[}gbNX ~ ]}gbNX
	D3DXMatrixMultiply(&smat, &smat, &rmat);
	// [N}gbNX    LvZ         ~ ړ}gbNX
	D3DXMatrixMultiply(&wmat, &smat, &tmat); 
}

