#include "stdafx.h"
#include "MglOgg.h"

#define VOX_DLL_NAME		"Vox.dll"
//#define VOX_DLL_NAME		"Vox_d.dll"

typedef Vox* __stdcall CreateVox();
#define USE_CHK()		if(m_useFlg!=TRUE)return;

//	RXgN^
CMglOgg::CMglOgg()
{
	m_hDll = NULL;
	m_pDriver = NULL;
	m_loadFlg = FALSE;
	m_useFlg = TRUE;
	m_fNowVolume = VOX_DEFAULT_VOLUME;
}

//	fXgN^
CMglOgg::~CMglOgg()
{
	Release();
}

//	
void CMglOgg::Init( HWND hWnd )
{
	USE_CHK();

	m_hDll = LoadLibrary( VOX_DLL_NAME );
	if ( m_hDll == NULL )
		MyuThrow( 0, "CMglOgg::Init()  %s ̃[hɎs܂B", VOX_DLL_NAME );

	CreateVox *pCreateVox = (CreateVox *)GetProcAddress( m_hDll,"CreateVox" );
	m_pDriver = pCreateVox();
}

//	J
void CMglOgg::Release()
{
	if ( m_pDriver != NULL )
	{
		//UnLoad();
		m_pDriver->Delete(); // delete m_pDriver sĂ͂Ȃ!!
		m_pDriver = NULL;
	}
	if ( m_hDll != NULL )
	{
		FreeLibrary( m_hDll );
		m_hDll = NULL;
	}
}

//	ǂݍ
void CMglOgg::Load( const char* szOggFile )
{
	//	`FbN
	USE_CHK();
	InitCheck();

	//	ǂݍ
	if ( m_loadFlg )
		UnLoad();
	if ( m_pDriver->Load( (char*)szOggFile ) != true )
		MyuThrow( 0, "CMglOgg::Load()  %s ̓ǂݍ݂Ɏs܂B", szOggFile );

	m_loadFlg = TRUE;
}

//	J
void CMglOgg::UnLoad()
{
	//	`FbN
	USE_CHK();
	InitCheck();

	if ( m_loadFlg ){
		m_pDriver->Release();
		m_loadFlg = FALSE;
	}
}

//	Đ
void CMglOgg::Play( int nLoopCnt )
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	[vĐ
	if ( m_pDriver->SetLoop(nLoopCnt) != true )
		MyuThrow( 0, "CMglOgg::SetLoop()  [v񐔂̐ݒɎs܂B" );

	//	Đ
	if ( m_pDriver->Play() != true )
		MyuThrow( 0, "CMglOgg::Play()  ĐɎs܂B" );
}

//	[vĐXgbv
void CMglOgg::StopLoop()
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	[vĐ
	if ( m_pDriver->SetLoop(0) != true )
		MyuThrow( 0, "CMglOgg::SetLoop()  [v񐔂̐ݒɎs܂B" );
}

//	~
void CMglOgg::Stop()
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	Pause();
	SeekToHead();
}

//	|[Y
void CMglOgg::Pause()
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	[vĐ
	if ( m_pDriver->Pause() != true )
		MyuThrow( 0, "CMglOgg::Pause()  |[YɎs܂B" );
}

//	{[̐ݒ
void CMglOgg::SetVolume( float fVolume )
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	[vĐ
	if ( m_pDriver->SetVolume( fVolume ) != true )
		MyuThrow( 0, "CMglOgg::SetVolume()  {[̐ݒɎs܂B" );

	m_fNowVolume = fVolume;
}

//	tF[h
void CMglOgg::Fade( float fTargetVolume, int nFadeTime )
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	Đ
	if ( m_pDriver->Fade( m_fNowVolume, fTargetVolume, nFadeTime ) != true )
		MyuThrow( 0, "CMglOgg::Fade()  tF[hɎs܂B" );

	m_fNowVolume = fTargetVolume;
}


void CMglOgg::SeekTo( long nSeekTime, DWORD dwFlg )
{
	//	`FbN
	USE_CHK();
	LoadCheck();

	//	Đ
	if ( m_pDriver->Seek( nSeekTime ) != true )
		MyuThrow( 0, "CMglOgg::SeekTo()  V[NɎs܂B" );
}
