//////////////////////////////////////////////////////////
//
//	MglSurfacesManager
//		- obt@NX
//
//////////////////////////////////////////////////////////
#include "stdafx.h"
#include "MglSurfacesManager.h"

//	RXgN^
CMglSurfacesManager::CMglSurfacesManager()
{
	initFlg = FALSE;

	//	CMyuStringNameMap̃bZ[W
	m_buffers.SetMessage(
		"CMglSurfacesManager::Add()  \"%s\"̖ÕT[tFX݂͑܂B",
		"CMglSurfacesManager::Get()  \"%s\"̖ÕT[tFX݂͑܂B" );
}

//	fXgN^
CMglSurfacesManager::~CMglSurfacesManager()
{
	Release();
}


//	
void CMglSurfacesManager::Init( CMglGraphicManager *in_myudg, const char* szMgrName )
{
	//	Direct3Dn
	myudg = in_myudg;
	d3d = myudg->GetD3dDevPtr();
	m_strMgrName = szMgrName;

	initFlg = TRUE;
}

//	J
void CMglSurfacesManager::Release()
{
	DeleteAll();
}

//	SẴT[tFX폜i_łRelease()Ɠj
void CMglSurfacesManager::DeleteAll()
{
	//_MGL_DEBUGLOG( "+ CMglSurfacesManager::DeleteAll()" );
	m_buffers.DeleteAll();
	//_MGL_DEBUGLOG( "- CMglSurfacesManager::DeleteAll()" );
}

//	ǉ
CMglImage* CMglSurfacesManager::Add( const char *szBufferName )
{
	_MGL_DEBUGLOG( "+ CMglSurfacesManager::Add( \"%s\" )", szBufferName );
	InitCheck();

	CMglImage surface;
	surface.Init( myudg );

	//	T[tFX̐
	if ( m_strMgrName != "" ){
		char szSurfaceName[256];
		snprintf( szSurfaceName, sizeof(szSurfaceName),
			"%s[\"%s\"]", m_strMgrName.c_str(), szBufferName );
		surface.SetName( szSurfaceName );
	}
	else
		surface.SetName( szBufferName );

	m_buffers.Add( szBufferName, surface );

	_MGL_DEBUGLOG( "- CMglSurfacesManager::Add( \"%s\" )", szBufferName );

	return Get( szBufferName );
}

//	擾
CMglImage* CMglSurfacesManager::Get( const char *szBufferName )
{
	return m_buffers.Get( szBufferName );
}

//	폜
void CMglSurfacesManager::Delete( const char *szBufferName )
{
	m_buffers.Delete( szBufferName );
}
