//////////////////////////////////////////////////////////
//
//	MglText
//		- eLXg
//
//////////////////////////////////////////////////////////

#include "stdafx.h"

//#if _MGL_DXVER == 8
#if _MGL_D3DXVER < MGL_D3DXVER_ID3DXFONT_CHANGED
#include "MglText.h"

//	RXgN^
/*CMglText::CMglText()
{
	_Init();

	//	ftHgtHg
	Create();
}*/

//	fXgN^
CMglText::~CMglText()
{
	Release();
}

////// 쐬n //////////////////////////////////////////////////////

//	TCYwɂ쐬
void CMglText::InitAndCreate( CMglGraphicManager* in_myudg, int nHeight )
{
	Release();	//	ꉞ[X

	HFONT hFont = CreateFont( nHeight, 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, DEFAULT_CHARSET, 0, 0, 4, 0, "" );
	if ( hFont == NULL )
		MyuThrow( 0, "CMglText::InitAndCreate()  CreateFont()ɎsB" );

	InitAndCreate( in_myudg, hFont );

	//	20007/01/02
	DeleteObject(hFont);
}

//	szFontNamẽftHg͋󕶎܂NULL
void CMglText::Create( CMglGraphicManager* in_myudg, int nHeight, const char* szFontName,
		BOOL bItalic, BOOL bBold, BOOL bUnderLine, BOOL bStrikeOut, float fAngle )
{
	Release();	//	ꉞ[X

	int nWeight = FW_DONTCARE;
	if ( bBold )
		nWeight = FW_BOLD;

	HFONT hFont = CreateFont( nHeight, 0, (int)(fAngle*10), (int)(fAngle*10),
		nWeight, bItalic, bUnderLine, bStrikeOut, DEFAULT_CHARSET, 0, 0, 4, 0, szFontName );

	if ( hFont == NULL )
		MyuThrow( 0, "CMglText::InitAndCreate()  CreateFont()ɎsB" );

	InitAndCreate( in_myudg, hFont );

	//	20007/01/02
	DeleteObject(hFont);
}
	
//	yэ쐬
void CMglText::InitAndCreate( CMglGraphicManager* in_myudg, HFONT hFont )
{
	Release();	//	ꉞ[X

	if ( bCreateFlg == TRUE )
		MyuThrow( 0, "CMglText::InitAndCreate()   InitAndCreate() ͎sĂ܂B" );

	if ( hFont == NULL )
		MyuThrow( 0, "CMglText::InitAndCreate()  hFontNULLłB" );

	m_myudg = in_myudg;
	m_d3d = m_myudg->GetD3dDevPtr();

	//	JpɃt@Xǉ
	m_myudg->AddRefOfAutoRelease( this );

	MyuAssert( D3DXCreateFont( m_d3d, hFont, &m_text ),
		D3D_OK, "CMglText::InitAndCreate()  D3DXCreateFont()ɎsB" );

	bCreateFlg = TRUE;
}

//	IJ
void CMglText::Release()
{
	//	Jp̃t@X폜
	DELREF();

	SAFE_RELEASE( m_text );

	bCreateFlg = FALSE;
}


////// Gn //////////////////////////////////////////////////////


//	G
void CMglText::Draw( const char* szString, int nX, int nY, D3DCOLOR color, DWORD dwOption )
{
	if ( bCreateFlg == FALSE )
		MyuThrow( 0, "CMglText::Draw()  InitAndCreate() ܂ InitAndEzCreate() sĂB" );

	RECT rect;
	if ( (dwOption & DT_RIGHT) != 0 )
		_Rect( 0, nY, nX, m_myudg->GetDispY(), &rect );
	else
		_Rect( nX, nY, m_myudg->GetDispX(), m_myudg->GetDispY(), &rect );

	//MyuAssert( m_text->DrawText( szString, -1, &rect, DT_NOCLIP | dwOption, color ),
	//	D3D_OK, "CMglText::Draw()  m_text->DrawText()ɎsB" );

	//	DirectX8̃wvƐI0ŐVDirectX9̃wv
	//	u_IPʂgăeLXg̍ԂvɂȂĂcB
	//	_IPʂŃ`FbNDirectX8œȂ猙Ȃ̂Ń`FbN̂߂܂(;LD`)U
#if _MGL_D3DXVER >= MGL_D3DXVER_ID3DXSPRITE_CHANGED
	//	DirectX9ł͑ƂăXvCgw肷ƃptH[}Xシ炵BƂ肠񂵂ŁEEE (TODO)
	m_text->DrawText( NULL, szString, -1, &rect, DT_NOCLIP | DT_NOPREFIX | dwOption, color );
#else
	m_text->DrawText( szString, -1, &rect, DT_NOCLIP | DT_NOPREFIX | dwOption, color );
#endif
}

//	tH[}bgDraw()
void CMglText::FDraw( const char* szString, ... )
{
	SetParamCheck();

	char szFormatedString[1024];
	if ( strlen( szString ) > sizeof(szFormatedString)-1 )
		MyuThrow( 0, "CMglText::FDraw() %d oCgz镶Ƃ͏o܂B", sizeof(szFormatedString)-1 );

	va_list vl;
	va_start( vl, szString );
	vsprintf( szFormatedString, szString, vl );
	va_end( vl );

	Draw( szFormatedString, m_nX, m_nY, m_color, m_dwOption );
}

//	tHgݒ
void CMglText::SetDrawParam( int in_nX, int in_nY, D3DCOLOR in_color, DWORD in_dwOption )
{
	m_nX = in_nX;
	m_nY = in_nY;
	m_dwOption = in_dwOption;
	m_color = in_color;
	bSetParamFlg = TRUE;
}

#endif