#include "stdafx.h"
#include "MglXShader.h"

//	RXgN^
CMglXShader::CMglXShader()
{
	m_pBufShader = NULL;
	m_pBufErrorInfo = NULL;
}

//	J
void CMglXShader::Release()
{
	SAFE_RELEASE(m_pBufShader);
	SAFE_RELEASE(m_pBufErrorInfo);
}

//	VF[_[t@Cǂݍ
void CMglXShader::Load(const char* szShaderScriptFile)
{
	InitCheck();
	CreatedCheck();

	//	t@C{ɂ邩ǂH
	if ( !msl::IsExistFile(szShaderScriptFile) )
		MyuThrow(MGLMSGNO_SHADER(2), "CMglXShader::Load()  t@C \"%s\" ͌܂B", szShaderScriptFile);

	//	AZut@Cǂݍ݁[
	/*MyuAssert2( D3DXAssembleShaderFromFile( szShaderScriptFile, 0, NULL, &m_pBufShader, &m_pBufErrorInfo ), D3D_OK, <- ȂGetCompileErrorMsg()ɎsĂ܂炵EEE܂œKƂłˁEEE
		MGLMSGNO_SHADER(12), "CMglXShader::Load()  D3DXAssembleShaderFromFile()Ɏs\r\n\r\n%s", GetCompileErrorMsg() );*/
#if _MGL_DXVER == 8
	HRESULT hr = D3DXAssembleShaderFromFile( szShaderScriptFile, 0, NULL, &m_pBufShader, &m_pBufErrorInfo );
#else
	HRESULT hr = D3DXAssembleShaderFromFile( szShaderScriptFile, NULL, NULL, 0, &m_pBufShader, &m_pBufErrorInfo );
#endif
	if ( hr != D3D_OK )
		MyuThrow2( hr, MGLMSGNO_SHADER(13), "CMglXShader::Load()  ̃G[̂ D3DXAssembleShaderFromFile() ͎s܂B\r\n\r\n%s", GetCompileErrorMsg() );
}

//	񂩂ǂݍ
void CMglXShader::LoadFromString(const char* szAssembleString)
{
	InitCheck();
	CreatedCheck();

	//	œǂݍ݁[
	/*MyuAssert2( D3DXAssembleShader( szAssembleString, strlen(szAssembleString), <- ȂGetCompileErrorMsg()ɎsĂ܂炵EEE܂œKƂłˁEEE
		0, NULL, &m_pBufShader, &m_pBufErrorInfo ), D3D_OK,
		MGLMSGNO_SHADER(13), "CMglXShader::LoadFromString()  D3DXAssembleShader()Ɏs\r\n\r\n%s", GetCompileErrorMsg() );*/
#if _MGL_DXVER == 8
	HRESULT hr = D3DXAssembleShader( szAssembleString, strlen(szAssembleString),
		0, NULL, &m_pBufShader, &m_pBufErrorInfo );
#else
	HRESULT hr = D3DXAssembleShader( szAssembleString, strlen(szAssembleString),
		NULL, NULL, 0, &m_pBufShader, &m_pBufErrorInfo );
#endif
	if ( hr != D3D_OK )
		MyuThrow2( hr, MGLMSGNO_SHADER(13), "CMglXShader::LoadFromString()  ̃G[̂ D3DXAssembleShader() ͎s܂B\r\n\r\n%s", GetCompileErrorMsg() );
}

//	G[bZ[W擾
const char* CMglXShader::GetCompileErrorMsg()
{
	if ( m_pBufErrorInfo == NULL )
		return "(No Error Buffer.)";

	return (const char*) m_pBufErrorInfo->GetBufferPointer();
}

//	obt@擾
CONST DWORD* CMglXShader::GetBuffer()
{
	InitCheck();
	CreateCheck();

	return (CONST DWORD*) m_pBufShader->GetBufferPointer();
}

