/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.grapher.ImplementationNode;
import com.google.inject.grapher.NameFactory;
import com.google.inject.grapher.graphviz.GraphvizNode;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import com.google.inject.grapher.graphviz.NodeStyle;
import com.google.inject.grapher.graphviz.PortIdFactory;
import java.lang.reflect.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationNodeFactory
implements ImplementationNode.Factory<String, ImplementationNode<String>> {
    private final GraphvizRenderer renderer;
    private final NameFactory nameFactory;
    private final PortIdFactory portIdFactory;

    @Inject
    public ImplementationNodeFactory(GraphvizRenderer renderer, NameFactory nameFactory, PortIdFactory portIdFactory) {
        this.renderer = renderer;
        this.nameFactory = nameFactory;
        this.portIdFactory = portIdFactory;
    }

    @Override
    public ImplementationNode<String> newImplementationNode(String nodeId) {
        GraphvizNode node = new GraphvizNode(nodeId);
        this.renderer.addNode(node);
        return this.newAdaptor(node);
    }

    protected GraphvizNodeAdaptor newAdaptor(GraphvizNode node) {
        return new GraphvizNodeAdaptor(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphvizNodeAdaptor
    implements ImplementationNode<String> {
        protected final GraphvizNode node;

        public GraphvizNodeAdaptor(GraphvizNode node) {
            this.node = node;
            this.node.setStyle(NodeStyle.INVISIBLE);
        }

        @Override
        public void setClassKey(Key<?> key) {
            this.node.setHeaderBackgroundColor("#000000");
            this.node.setHeaderTextColor("#ffffff");
            this.node.setTitle(ImplementationNodeFactory.this.nameFactory.getClassName(key));
        }

        @Override
        public void setInstance(Object instance) {
            this.node.setHeaderBackgroundColor("#aaaaaa");
            this.node.setHeaderTextColor("#ffffff");
            this.node.setTitle(ImplementationNodeFactory.this.nameFactory.getInstanceName(instance));
        }

        @Override
        public void setSource(Object source) {
            this.node.addSubtitle(0, ImplementationNodeFactory.this.nameFactory.getSourceName(source));
        }

        @Override
        public void addMember(Member member) {
            this.node.addField(ImplementationNodeFactory.this.portIdFactory.getPortId(member), ImplementationNodeFactory.this.nameFactory.getMemberName(member));
        }
    }
}

