/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.persist.jpa;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.internal.util.;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.jpa.Jpa;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class JpaPersistService
implements Provider<EntityManager>,
UnitOfWork,
PersistService {
    private final ThreadLocal<EntityManager> entityManager = new ThreadLocal();
    private final String persistenceUnitName;
    private final Properties persistenceProperties;
    private volatile EntityManagerFactory emFactory;

    @Inject
    public JpaPersistService(@Jpa String persistenceUnitName, @.Nullable @Jpa Properties persistenceProperties) {
        this.persistenceUnitName = persistenceUnitName;
        this.persistenceProperties = persistenceProperties;
    }

    public EntityManager get() {
        EntityManager em;
        if (!this.isWorking()) {
            this.begin();
        }
        .Preconditions.checkState((null != (em = this.entityManager.get()) ? 1 : 0) != 0, (Object)"Requested EntityManager outside work unit. Try calling UnitOfWork.begin() first, or use a PersistFilter if you are inside a servlet environment.");
        return em;
    }

    public boolean isWorking() {
        return this.entityManager.get() != null;
    }

    @Override
    public void begin() {
        .Preconditions.checkState((null == this.entityManager.get() ? 1 : 0) != 0, (Object)"Work already begun on this thread. Looks like you have called UnitOfWork.begin() twice without a balancing call to end() in between.");
        this.entityManager.set(this.emFactory.createEntityManager());
    }

    @Override
    public void end() {
        EntityManager em = this.entityManager.get();
        if (null == em) {
            return;
        }
        em.close();
        this.entityManager.remove();
    }

    @Override
    public synchronized void start() {
        .Preconditions.checkState((null == this.emFactory ? 1 : 0) != 0, (Object)"Persistence service was already initialized.");
        this.emFactory = null != this.persistenceProperties ? Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceProperties) : Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
    }

    @Override
    public synchronized void stop() {
        .Preconditions.checkState((boolean)this.emFactory.isOpen(), (Object)"Persistence service was already shut down.");
        this.emFactory.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class EntityManagerFactoryProvider
    implements Provider<EntityManagerFactory> {
        private final JpaPersistService emProvider;

        @Inject
        public EntityManagerFactoryProvider(JpaPersistService emProvider) {
            this.emProvider = emProvider;
        }

        public EntityManagerFactory get() {
            assert (null != this.emProvider.emFactory);
            return this.emProvider.emFactory;
        }
    }
}

