package controllers
import play.api._
import play.api.mvc._
import models.services._
import models.services.impl._
import com.google.inject._
import modules._

object Autocomplete extends Controller{
  val inject = Guice.createInjector(new ServiceModules)
  val projectManager = inject.getInstance(classOf[ProjectManager])


  def projectList() = Action {
    request => {
      Ok(projectManager.getProjectList(request))
	}
  }
  
  def partList() = Action {
    request => {
      Ok(PartManager().partList(request))
    }
  }
  
  def userList() = Action {
    request => {
      Ok(UserManager().userList(request))
    }
  }
  
  def designChangeList() = Action {
    request => {
      Ok(DesignChangeManager().designChangeList(request))
    }
  }

}