package models.services
import forms._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class ReplyManager() extends AbstractManager{
  def insert(reply: ReplyForm, replyUser: User, notifyId: Long, replyId: Long):Reply = {
    var newReply = Reply(reply.message, replyUser.id, notifyId, replyId, reply.atach)
    if(notifyId != 0) {
      newReply = NotifyManager().getById(notifyId).replies.associate(newReply)
    } else if(replyId != 0) {
      newReply = ReplyManager().getById(replyId).childReplies.associate(newReply)
    } 
    return newReply
  }
  
  def getById(id: Long):Reply = {
    PartsListDb.replies.where(tr => tr.id === id).head
  }

}