##
#	$Id: base.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
require 'thwait'

require 'client/client.rb'
require 'lib/mahjong.rb'

module Ai
  #
  class Base
    UMP_VERSION = '0.1'

    #
    def initialize(host, port)
      @client = OpenMj::Client.new(host, port)
    end

    #
    def start
      @client.start { |command, args|
        case command
        when 'hello'
          @client.send('hello', "ump=#{UMP_VERSION}")
        when 'sutehai?'
          choice_sutehai(@client.get_player.hand)
        when 'naku?'
          @client.send('no')
        when 'tenpai?'
          @client.send('noten')
        when 'ready?'
          @client.send('ok')
        end
      }
    end

    # 捨て牌を選ぶ
    def choice_sutehai(hand)
      #sleep(0.1)
      @client.send('sutehai', hand[-1].to_s, 'tsumogiri')
    end
  end
end

if $0 == __FILE__
  threads = Array.new
  3.times {
    threads << Thread.start {
      Ai::Base.new('localhost', 1326).start
    }
  }
  ThreadsWait.all_waits(*threads)
end
